/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.oio.nio;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.oio.nio.NioFile;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class NioFileUtil {
    private NioFileUtil() {
    }

    public static File createTempDirectory(String prefix) throws IOException {
        return OioFileFactory.createFile((java.io.File)Files.createTempDirectory(prefix, new FileAttribute[0]).toFile());
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return OioFileFactory.createFile((java.io.File)java.io.File.createTempFile(prefix, suffix));
    }

    public static File createTempFile(String prefix, String suffix, File parentDir) throws IOException {
        return OioFileFactory.createFile((java.io.File)java.io.File.createTempFile(prefix, suffix, NioFileUtil.castOrFail(parentDir).getIoFile()));
    }

    static NioFile castOrFail(File file) {
        if (file instanceof NioFile) {
            return (NioFile)file;
        }
        throw new IllegalArgumentException("Could not cast file: " + file.getClass().getCanonicalName());
    }

    static String toPathString(Path path) {
        AssertUtil.assertNotNull((Object)path, (String)"path");
        return path.toString().replace(java.io.File.separatorChar, '/');
    }

    static String toPathString(java.io.File file) {
        Path path = file.toPath();
        AssertUtil.assertNotNull((Object)path, (String)"path");
        return path.toString().replace(java.io.File.separatorChar, '/');
    }

    static File[] convert(java.io.File[] ioFilesListFiles) {
        if (ioFilesListFiles == null) {
            return null;
        }
        File[] listFiles = new NioFile[ioFilesListFiles.length];
        for (int i = 0; i < ioFilesListFiles.length; ++i) {
            listFiles[i] = new NioFile(ioFilesListFiles[i]);
        }
        return listFiles;
    }
}

