/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot.key;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.wot.PgpFile;
import org.bouncycastle.openpgp.wot.internal.Util;
import org.bouncycastle.openpgp.wot.key.PgpKey;
import org.bouncycastle.openpgp.wot.key.PgpKeyFingerprint;
import org.bouncycastle.openpgp.wot.key.PgpKeyId;
import org.bouncycastle.openpgp.wot.key.PgpKeyRegistry;
import org.bouncycastle.openpgp.wot.key.PgpUserId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpKeyRegistryImpl
implements PgpKeyRegistry {
    private static final Logger logger = LoggerFactory.getLogger(PgpKeyRegistryImpl.class);
    private final PgpFile pubringFile;
    private final PgpFile secringFile;
    private final Object mutex;
    private long pubringFileLastModified = Long.MIN_VALUE;
    private long secringFileLastModified = Long.MIN_VALUE;
    private Map<PgpKeyFingerprint, PgpKey> pgpKeyFingerprint2pgpKey;
    private Map<PgpKeyId, PgpKey> pgpKeyId2pgpKey;
    private Map<PgpKeyId, PgpKey> pgpKeyId2masterKey;
    private Map<PgpKeyId, Set<PgpKeyId>> certifyingKeyId2certifiedKeyIds;

    public PgpKeyRegistryImpl(PgpFile pubringFile, PgpFile secringFile) {
        this.pubringFile = Util.assertNotNull(pubringFile, "pubringFile");
        this.secringFile = Util.assertNotNull(secringFile, "secringFile");
        this.mutex = pubringFile.getPgpId();
    }

    @Override
    public PgpFile getPubringFile() {
        return this.pubringFile;
    }

    @Override
    public PgpFile getSecringFile() {
        return this.secringFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PgpKey getPgpKeyOrFail(PgpKeyId pgpKeyId) throws IllegalArgumentException {
        Object object = this.mutex;
        synchronized (object) {
            PgpKey pgpKey = this.getPgpKey(pgpKeyId);
            if (pgpKey == null) {
                throw new IllegalArgumentException("No PGP key found for this keyId: " + pgpKeyId);
            }
            return pgpKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PgpKey getPgpKey(PgpKeyId pgpKeyId) throws IllegalArgumentException {
        Object object = this.mutex;
        synchronized (object) {
            Util.assertNotNull(pgpKeyId, "pgpKeyId");
            this.loadIfNeeded();
            PgpKey pgpKey = this.pgpKeyId2pgpKey.get(pgpKeyId);
            return pgpKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PgpKey getPgpKeyOrFail(PgpKeyFingerprint pgpKeyFingerprint) throws IllegalArgumentException {
        Object object = this.mutex;
        synchronized (object) {
            PgpKey pgpKey = this.getPgpKey(pgpKeyFingerprint);
            if (pgpKey == null) {
                throw new IllegalArgumentException("No PGP key found for this fingerprint: " + pgpKeyFingerprint);
            }
            return pgpKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PgpKey getPgpKey(PgpKeyFingerprint pgpKeyFingerprint) throws IllegalArgumentException {
        Object object = this.mutex;
        synchronized (object) {
            Util.assertNotNull(pgpKeyFingerprint, "pgpKeyFingerprint");
            this.loadIfNeeded();
            PgpKey pgpKey = this.pgpKeyFingerprint2pgpKey.get(pgpKeyFingerprint);
            return pgpKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PgpKey> getMasterKeys() {
        Object object = this.mutex;
        synchronized (object) {
            this.loadIfNeeded();
            return Collections.unmodifiableCollection(this.pgpKeyId2masterKey.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markStale() {
        Object object = this.mutex;
        synchronized (object) {
            this.pubringFileLastModified = Long.MIN_VALUE;
            this.secringFileLastModified = Long.MIN_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadIfNeeded() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.pgpKeyId2pgpKey == null || this.getPubringFile().getLastModified() != this.pubringFileLastModified || this.getSecringFile().getLastModified() != this.secringFileLastModified) {
                logger.debug("loadIfNeeded: invoking load().");
                this.load();
            } else {
                logger.trace("loadIfNeeded: *not* invoking load().");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() {
        Object object = this.mutex;
        synchronized (object) {
            long pubringFileLastModified;
            long secringFileLastModified;
            HashMap<PgpKeyFingerprint, PgpKey> pgpKeyFingerprint2pgpKey = new HashMap<PgpKeyFingerprint, PgpKey>();
            HashMap<PgpKeyId, PgpKey> pgpKeyId2pgpKey = new HashMap<PgpKeyId, PgpKey>();
            HashMap<PgpKeyId, PgpKey> pgpKeyId2masterKey = new HashMap<PgpKeyId, PgpKey>();
            try {
                PGPPublicKeyRingCollection pgpPublicKeyRingCollection;
                Object it3;
                PGPSecretKeyRingCollection pgpSecretKeyRingCollection;
                PgpFile secringFile = this.getSecringFile();
                logger.debug("load: secringFile='{}'", (Object)secringFile);
                secringFileLastModified = secringFile.getLastModified();
                try (BufferedInputStream in = new BufferedInputStream(secringFile.createInputStream());){
                    pgpSecretKeyRingCollection = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)in), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                }
                Iterator it1 = pgpSecretKeyRingCollection.getKeyRings();
                while (it1.hasNext()) {
                    PGPSecretKeyRing keyRing = (PGPSecretKeyRing)it1.next();
                    PgpKey masterKey = null;
                    Iterator it2 = keyRing.getPublicKeys();
                    while (it2.hasNext()) {
                        PGPPublicKey publicKey = (PGPPublicKey)it2.next();
                        masterKey = this.enlistPublicKey(pgpKeyFingerprint2pgpKey, pgpKeyId2pgpKey, pgpKeyId2masterKey, masterKey, (PGPKeyRing)keyRing, publicKey);
                    }
                    it3 = keyRing.getSecretKeys();
                    while (it3.hasNext()) {
                        PGPSecretKey secretKey = (PGPSecretKey)it3.next();
                        PgpKeyId pgpKeyId = new PgpKeyId(secretKey.getKeyID());
                        PgpKey pgpKey = (PgpKey)pgpKeyId2pgpKey.get(pgpKeyId);
                        if (pgpKey == null) {
                            throw new IllegalStateException("Secret key does not have corresponding public key in secret key ring! pgpKeyId=" + pgpKeyId);
                        }
                        pgpKey.setSecretKey(secretKey);
                        logger.debug("load: read secretKey with pgpKeyId={}", (Object)pgpKeyId);
                    }
                }
                PgpFile pubringFile = this.getPubringFile();
                logger.debug("load: pubringFile='{}'", (Object)pubringFile);
                pubringFileLastModified = pubringFile.getLastModified();
                BufferedInputStream in = new BufferedInputStream(pubringFile.createInputStream());
                it3 = null;
                try {
                    pgpPublicKeyRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)in), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                }
                catch (Throwable secretKey) {
                    it3 = secretKey;
                    throw secretKey;
                }
                finally {
                    if (in != null) {
                        if (it3 != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (Throwable secretKey) {
                                ((Throwable)it3).addSuppressed(secretKey);
                            }
                        } else {
                            ((InputStream)in).close();
                        }
                    }
                }
                Iterator it12 = pgpPublicKeyRingCollection.getKeyRings();
                while (it12.hasNext()) {
                    PGPPublicKeyRing keyRing = (PGPPublicKeyRing)it12.next();
                    PgpKey masterKey = null;
                    Iterator it2 = keyRing.getPublicKeys();
                    while (it2.hasNext()) {
                        PGPPublicKey publicKey = (PGPPublicKey)it2.next();
                        masterKey = this.enlistPublicKey(pgpKeyFingerprint2pgpKey, pgpKeyId2pgpKey, pgpKeyId2masterKey, masterKey, (PGPKeyRing)keyRing, publicKey);
                    }
                }
            }
            catch (IOException | PGPException x) {
                throw new RuntimeException(x);
            }
            for (PgpKey pgpKey : pgpKeyId2pgpKey.values()) {
                if (pgpKey.getPublicKey() == null) {
                    throw new IllegalStateException("pgpKey.publicKey == null :: keyId = " + pgpKey.getPgpKeyId());
                }
                if (pgpKey.getPublicKeyRing() != null) continue;
                throw new IllegalStateException("pgpKey.publicKeyRing == null :: keyId = " + pgpKey.getPgpKeyId());
            }
            this.secringFileLastModified = secringFileLastModified;
            this.pubringFileLastModified = pubringFileLastModified;
            this.pgpKeyFingerprint2pgpKey = Collections.unmodifiableMap(pgpKeyFingerprint2pgpKey);
            this.pgpKeyId2pgpKey = Collections.unmodifiableMap(pgpKeyId2pgpKey);
            this.pgpKeyId2masterKey = Collections.unmodifiableMap(pgpKeyId2masterKey);
            this.certifyingKeyId2certifiedKeyIds = null;
            this.assignSubKeys();
        }
    }

    private void assignSubKeys() {
        for (PgpKey masterKey : this.pgpKeyId2masterKey.values()) {
            Set<PgpKeyId> subKeyIds = masterKey.getSubKeyIds();
            ArrayList<PgpKey> subKeys = new ArrayList<PgpKey>(subKeyIds.size());
            for (PgpKeyId subKeyId : subKeyIds) {
                PgpKey subKey = this.getPgpKeyOrFail(subKeyId);
                subKeys.add(subKey);
            }
            masterKey.setSubKeys(Collections.unmodifiableList(subKeys));
            masterKey.setSubKeyIds(Collections.unmodifiableSet(subKeyIds));
        }
    }

    private PgpKey enlistPublicKey(Map<PgpKeyFingerprint, PgpKey> pgpKeyFingerprint2pgpKey, Map<PgpKeyId, PgpKey> pgpKeyId2PgpKey, Map<PgpKeyId, PgpKey> pgpKeyId2masterKey, PgpKey masterKey, PGPKeyRing keyRing, PGPPublicKey publicKey) {
        PgpKeyId pgpKeyId = new PgpKeyId(publicKey.getKeyID());
        PgpKeyFingerprint pgpKeyFingerprint = new PgpKeyFingerprint(publicKey.getFingerprint());
        PgpKey pgpKey = pgpKeyFingerprint2pgpKey.get(pgpKeyFingerprint);
        if (pgpKey == null) {
            pgpKey = new PgpKey(pgpKeyId, pgpKeyFingerprint);
            pgpKeyFingerprint2pgpKey.put(pgpKeyFingerprint, pgpKey);
            PgpKey old = pgpKeyId2PgpKey.put(pgpKeyId, pgpKey);
            if (old != null) {
                throw new IllegalStateException(String.format("PGP-key-ID collision! Two keys with different fingerprints have the same key-ID! keyId=%s fingerprint1=%s fingerprint2=%s", pgpKeyId, old.getPgpKeyFingerprint(), pgpKey.getPgpKeyFingerprint()));
            }
        }
        if (keyRing instanceof PGPSecretKeyRing) {
            pgpKey.setSecretKeyRing((PGPSecretKeyRing)keyRing);
        } else if (keyRing instanceof PGPPublicKeyRing) {
            pgpKey.setPublicKeyRing((PGPPublicKeyRing)keyRing);
        } else {
            throw new IllegalArgumentException("keyRing is neither an instance of PGPSecretKeyRing nor PGPPublicKeyRing!");
        }
        pgpKey.setPublicKey(publicKey);
        if (publicKey.isMasterKey()) {
            masterKey = pgpKey;
            pgpKeyId2masterKey.put(pgpKey.getPgpKeyId(), pgpKey);
        } else {
            if (masterKey == null) {
                throw new IllegalStateException("First key is a non-master key!");
            }
            pgpKey.setMasterKey(masterKey);
            masterKey.getSubKeyIds().add(pgpKey.getPgpKeyId());
        }
        return masterKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PgpKeyFingerprint> getPgpKeyFingerprintsCertifiedBy(PgpKeyFingerprint certifyingPgpKeyFingerprint) {
        Object object = this.mutex;
        synchronized (object) {
            Util.assertNotNull(certifyingPgpKeyFingerprint, "signingPgpKeyFingerprint");
            PgpKey signingPgpKey = this.getPgpKey(certifyingPgpKeyFingerprint);
            if (signingPgpKey == null) {
                return Collections.emptySet();
            }
            Set<PgpKeyId> pgpKeyIds = this.getCertifyingKeyId2certifiedKeyIds().get(signingPgpKey.getPgpKeyId());
            if (pgpKeyIds == null) {
                return Collections.emptySet();
            }
            HashSet<PgpKeyFingerprint> result = new HashSet<PgpKeyFingerprint>(pgpKeyIds.size());
            for (PgpKeyId pgpKeyId : pgpKeyIds) {
                PgpKey pgpKey = this.getPgpKeyOrFail(pgpKeyId);
                result.add(pgpKey.getPgpKeyFingerprint());
            }
            return Collections.unmodifiableSet(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PgpKeyId> getPgpKeyIdsCertifiedBy(PgpKeyId certifyingPgpKeyId) {
        Object object = this.mutex;
        synchronized (object) {
            Set<PgpKeyId> pgpKeyIds = this.getCertifyingKeyId2certifiedKeyIds().get(certifyingPgpKeyId);
            if (pgpKeyIds == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(pgpKeyIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<PgpKeyId, Set<PgpKeyId>> getCertifyingKeyId2certifiedKeyIds() {
        Object object = this.mutex;
        synchronized (object) {
            this.loadIfNeeded();
            if (this.certifyingKeyId2certifiedKeyIds == null) {
                HashMap<PgpKeyId, Set<PgpKeyId>> m = new HashMap<PgpKeyId, Set<PgpKeyId>>();
                for (PgpKey pgpKey : this.pgpKeyId2pgpKey.values()) {
                    PGPPublicKey publicKey = pgpKey.getPublicKey();
                    for (PgpUserId pgpUserId : pgpKey.getPgpUserIds()) {
                        PGPSignature pgpSignature;
                        Iterator it;
                        if (pgpUserId.getUserId() != null) {
                            it = Util.nullToEmpty(publicKey.getSignaturesForID(pgpUserId.getUserId()));
                            while (it.hasNext()) {
                                pgpSignature = (PGPSignature)it.next();
                                if (!this.isCertification(pgpSignature)) continue;
                                this.enlistInSigningKey2signedKeyIds(m, pgpKey, pgpSignature);
                            }
                            continue;
                        }
                        if (pgpUserId.getUserAttribute() != null) {
                            it = Util.nullToEmpty(publicKey.getSignaturesForUserAttribute(pgpUserId.getUserAttribute()));
                            while (it.hasNext()) {
                                pgpSignature = (PGPSignature)it.next();
                                if (!this.isCertification(pgpSignature)) continue;
                                this.enlistInSigningKey2signedKeyIds(m, pgpKey, pgpSignature);
                            }
                            continue;
                        }
                        throw new IllegalStateException("WTF?!");
                    }
                    Iterator it = Util.nullToEmpty(publicKey.getKeySignatures());
                    while (it.hasNext()) {
                        PGPSignature pgpSignature = (PGPSignature)it.next();
                        if (!this.isCertification(pgpSignature)) continue;
                        this.enlistInSigningKey2signedKeyIds(m, pgpKey, pgpSignature);
                    }
                }
                this.certifyingKeyId2certifiedKeyIds = Collections.unmodifiableMap(m);
            }
            return this.certifyingKeyId2certifiedKeyIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PGPSignature> getCertifications(PgpUserId pgpUserId) {
        Object object = this.mutex;
        synchronized (object) {
            PGPSignature pgpSignature;
            Iterator it;
            Util.assertNotNull(pgpUserId, "pgpUserId");
            PGPPublicKey publicKey = pgpUserId.getPgpKey().getPublicKey();
            IdentityHashMap<PGPSignature, PGPSignature> pgpSignatures = new IdentityHashMap<PGPSignature, PGPSignature>();
            ArrayList<PGPSignature> result = new ArrayList<PGPSignature>();
            if (pgpUserId.getUserId() != null) {
                it = Util.nullToEmpty(publicKey.getSignaturesForID(pgpUserId.getUserId()));
                while (it.hasNext()) {
                    pgpSignature = (PGPSignature)it.next();
                    if (pgpSignatures.containsKey(pgpSignature) || !this.isCertification(pgpSignature)) continue;
                    pgpSignatures.put(pgpSignature, pgpSignature);
                    result.add(pgpSignature);
                }
            } else if (pgpUserId.getUserAttribute() != null) {
                it = Util.nullToEmpty(publicKey.getSignaturesForUserAttribute(pgpUserId.getUserAttribute()));
                while (it.hasNext()) {
                    pgpSignature = (PGPSignature)it.next();
                    if (pgpSignatures.containsKey(pgpSignature) || !this.isCertification(pgpSignature)) continue;
                    pgpSignatures.put(pgpSignature, pgpSignature);
                    result.add(pgpSignature);
                }
            } else {
                throw new IllegalStateException("WTF?!");
            }
            it = Util.nullToEmpty(publicKey.getKeySignatures());
            while (it.hasNext()) {
                pgpSignature = (PGPSignature)it.next();
                if (pgpSignatures.containsKey(pgpSignature) || !this.isCertification(pgpSignature)) continue;
                pgpSignatures.put(pgpSignature, pgpSignature);
                result.add(pgpSignature);
            }
            return result;
        }
    }

    private void enlistInSigningKey2signedKeyIds(Map<PgpKeyId, Set<PgpKeyId>> signingKeyId2signedKeyIds, PgpKey pgpKey, PGPSignature pgpSignature) {
        PgpKeyId signingPgpKeyId = new PgpKeyId(pgpSignature.getKeyID());
        Set<PgpKeyId> signedKeyIds = signingKeyId2signedKeyIds.get(signingPgpKeyId);
        if (signedKeyIds == null) {
            signedKeyIds = new HashSet<PgpKeyId>();
            signingKeyId2signedKeyIds.put(signingPgpKeyId, signedKeyIds);
        }
        signedKeyIds.add(pgpKey.getPgpKeyId());
    }

    @Override
    public boolean isCertification(PGPSignature pgpSignature) {
        Util.assertNotNull(pgpSignature, "pgpSignature");
        return this.isCertification(pgpSignature.getSignatureType());
    }

    @Override
    public boolean isCertification(int pgpSignatureType) {
        return 16 == pgpSignatureType || 17 == pgpSignatureType || 18 == pgpSignatureType || 19 == pgpSignatureType;
    }
}

