/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.dto.split;

import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.subshare.core.dto.CryptoChangeSetDto;
import org.subshare.core.dto.jaxb.CryptoChangeSetDtoIo;

public class CryptoChangeSetDtoSplitFileManager {
    protected static final String CRYPTO_CHANGE_SET_DTO_DIR_SUFFIX = ".CryptoChangeSetDto";
    protected static final String CRYPTO_CHANGE_SET_DTO_TMP_DIR_INFIX = ".tmp.";
    protected static final String CRYPTO_CHANGE_SET_DTO_FILE_PREFIX = "CryptoChangeSetDto.";
    protected static final String CRYPTO_CHANGE_SET_DTO_FILE_SUFFIX = ".xml.gz";
    protected static final String CRYPTO_CHANGE_SET_DTO_FILE_IMPORTED_SUFFIX = ".imported";
    protected static final String REPO_TEMP_DIR_NAME = "tmp";
    protected static final String PROP_KEY_LAST_CRYPTO_KEY_SYNC_TO_REMOTE_REPO_LOCAL_REPOSITORY_REVISION_SYNCED = "lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced";
    private final LocalRepoManager localRepoManager;
    private final UUID remoteRepositoryId;
    private File baseDir;
    private File cryptoChangeSetDtoTmpDir;
    private File cryptoChangeSetDtoFinalDir;

    protected CryptoChangeSetDtoSplitFileManager(LocalRepoManager localRepoManager, UUID remoteRepositoryId) {
        this.localRepoManager = (LocalRepoManager)AssertUtil.assertNotNull((Object)localRepoManager, (String)"localRepoManager");
        this.remoteRepositoryId = (UUID)AssertUtil.assertNotNull((Object)remoteRepositoryId, (String)"remoteRepositoryId");
    }

    public static CryptoChangeSetDtoSplitFileManager createInstance(LocalRepoManager localRepoManager, UUID remoteRepositoryId) {
        return new CryptoChangeSetDtoSplitFileManager(localRepoManager, remoteRepositoryId);
    }

    protected File getBaseDir() throws IOException {
        if (this.baseDir == null) {
            File metaDir = this.getMetaDir();
            if (!metaDir.isDirectory()) {
                if (metaDir.isFile()) {
                    throw new IOException(String.format("Path '%s' already exists as ordinary file! It should be a directory!", metaDir.getAbsolutePath()));
                }
                throw new IOException(String.format("Directory '%s' does not exist!", metaDir.getAbsolutePath()));
            }
            File baseDir = metaDir.createFile(new String[]{REPO_TEMP_DIR_NAME});
            if (!baseDir.isDirectory()) {
                baseDir.mkdir();
                if (!baseDir.isDirectory()) {
                    if (baseDir.isFile()) {
                        throw new IOException(String.format("Cannot create directory '%s', because this path already exists as an ordinary file!", baseDir.getAbsolutePath()));
                    }
                    throw new IOException(String.format("Creating directory '%s' failed for an unknown reason (permissions? disk full?)!", baseDir.getAbsolutePath()));
                }
            }
            this.baseDir = baseDir;
        }
        return this.baseDir;
    }

    protected File getCryptoChangeSetDtoFinalDir() throws IOException {
        if (this.cryptoChangeSetDtoFinalDir == null) {
            this.cryptoChangeSetDtoFinalDir = this.getBaseDir().createFile(new String[]{this.remoteRepositoryId.toString() + CRYPTO_CHANGE_SET_DTO_DIR_SUFFIX});
        }
        return this.cryptoChangeSetDtoFinalDir;
    }

    protected File getCryptoChangeSetDtoTmpDir() throws IOException {
        if (this.cryptoChangeSetDtoTmpDir == null) {
            File finalDir = this.getCryptoChangeSetDtoFinalDir();
            this.cryptoChangeSetDtoTmpDir = IOUtil.createUniqueRandomFolder((File)finalDir.getParentFile(), (String)(finalDir.getName() + CRYPTO_CHANGE_SET_DTO_TMP_DIR_INFIX));
        }
        return this.cryptoChangeSetDtoTmpDir;
    }

    public void writeCryptoChangeSetDtos(List<CryptoChangeSetDto> cryptoChangeSetDtos, Long lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced) throws IOException {
        AssertUtil.assertNotNull(cryptoChangeSetDtos, (String)"cryptoChangeSetDtos");
        if (cryptoChangeSetDtos.isEmpty()) {
            throw new IllegalArgumentException("cryptoChangeSetDtos empty");
        }
        File finalDir = this.getCryptoChangeSetDtoFinalDir();
        if (finalDir.exists()) {
            throw new IllegalStateException(String.format("Directory '%s' exists, but should not!", finalDir.getAbsolutePath()));
        }
        File tmpDir = this.getCryptoChangeSetDtoTmpDir();
        CryptoChangeSetDtoIo dtoIo = new CryptoChangeSetDtoIo();
        int expectedMultiPartIndex = -1;
        for (CryptoChangeSetDto cryptoChangeSetDto : cryptoChangeSetDtos) {
            int multiPartIndex = cryptoChangeSetDto.getMultiPartIndex();
            if (++expectedMultiPartIndex != multiPartIndex) {
                throw new IllegalArgumentException(String.format("Wrong multiPartIndex! expectedMultiPartIndex=%s, multiPartIndex=%s", expectedMultiPartIndex, multiPartIndex));
            }
            File file = tmpDir.createFile(new String[]{this.getCryptoChangeSetDtoFileName(multiPartIndex)});
            if (file.exists()) {
                throw new IllegalStateException("File already exists: " + file.getAbsolutePath());
            }
            dtoIo.serializeWithGz(cryptoChangeSetDto, file);
        }
        Properties properties = new Properties();
        properties.setProperty(PROP_KEY_LAST_CRYPTO_KEY_SYNC_TO_REMOTE_REPO_LOCAL_REPOSITORY_REVISION_SYNCED, lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced == null ? "" : lastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced.toString());
        try (IOutputStream out = this.getCryptoChangeSetDtoPropertiesFile(tmpDir).createOutputStream();){
            properties.store(StreamUtil.castStream((IOutputStream)out), null);
        }
        if (!tmpDir.renameTo(finalDir)) {
            throw new IOException(String.format("Renaming '%s' to '%s' failed!", tmpDir.getAbsolutePath(), finalDir.getAbsolutePath()));
        }
    }

    public Long readLastCryptoKeySyncToRemoteRepoLocalRepositoryRevisionSynced() throws IOException {
        File finalDir = this.getCryptoChangeSetDtoFinalDir();
        if (!finalDir.exists()) {
            return null;
        }
        File propertiesFile = this.getCryptoChangeSetDtoPropertiesFile(finalDir);
        if (!propertiesFile.exists()) {
            return null;
        }
        Properties properties = new Properties();
        try (IInputStream in = propertiesFile.createInputStream();){
            properties.load(StreamUtil.castStream((IInputStream)in));
        }
        String s = properties.getProperty(PROP_KEY_LAST_CRYPTO_KEY_SYNC_TO_REMOTE_REPO_LOCAL_REPOSITORY_REVISION_SYNCED);
        if (s == null || s.isEmpty()) {
            return null;
        }
        long result = Long.parseLong(s.trim());
        return result;
    }

    protected File getCryptoChangeSetDtoPropertiesFile(File dir) {
        return dir.createFile(new String[]{"CryptoChangeSetDto..properties"});
    }

    protected String getCryptoChangeSetDtoFileName(int multiPartIndex) {
        return CRYPTO_CHANGE_SET_DTO_FILE_PREFIX + multiPartIndex + CRYPTO_CHANGE_SET_DTO_FILE_SUFFIX;
    }

    public CryptoChangeSetDto readCryptoChangeSetDto(int multiPartIndex) throws IOException {
        int cryptoChangeSetDtoFinalFileCount = this.getFinalFileCount();
        if (cryptoChangeSetDtoFinalFileCount < 1) {
            throw new IllegalStateException("No multi-part-CryptoChangeSetDto-files prepared!");
        }
        if (cryptoChangeSetDtoFinalFileCount <= multiPartIndex) {
            throw new IllegalArgumentException("multiPartIndex out of range!");
        }
        File finalDir = this.getCryptoChangeSetDtoFinalDir();
        File file = finalDir.createFile(new String[]{this.getCryptoChangeSetDtoFileName(multiPartIndex)});
        CryptoChangeSetDtoIo dtoIo = new CryptoChangeSetDtoIo();
        CryptoChangeSetDto result = (CryptoChangeSetDto)dtoIo.deserializeWithGz(file);
        return result;
    }

    public byte[] readCryptoChangeSetDtoFile(int multiPartIndex) throws IOException {
        int cryptoChangeSetDtoFinalFileCount = this.getFinalFileCount();
        if (cryptoChangeSetDtoFinalFileCount < 1) {
            throw new IllegalStateException("No multi-part-CryptoChangeSetDto-files prepared!");
        }
        if (cryptoChangeSetDtoFinalFileCount <= multiPartIndex) {
            throw new IllegalArgumentException("multiPartIndex out of range!");
        }
        File finalDir = this.getCryptoChangeSetDtoFinalDir();
        File file = finalDir.createFile(new String[]{this.getCryptoChangeSetDtoFileName(multiPartIndex)});
        long fileLength = file.length();
        if (fileLength > Integer.MAX_VALUE) {
            throw new IllegalStateException(String.format("File '%s' too large!", file.getAbsolutePath()));
        }
        byte[] result = new byte[(int)fileLength];
        try (IInputStream in = file.createInputStream();){
            IOUtil.readOrFail((InputStream)StreamUtil.castStream((IInputStream)in), (byte[])result, (int)0, (int)result.length);
        }
        return result;
    }

    public void deleteCryptoChangeSetDtoFinalDir() throws IOException {
        File finalDir = this.getCryptoChangeSetDtoFinalDir();
        if (finalDir.exists()) {
            finalDir.deleteRecursively();
        }
        if (finalDir.exists()) {
            throw new IOException(String.format("Deleting '%s' recursively failed!", finalDir.getAbsolutePath()));
        }
    }

    private File getMetaDir() {
        return OioFileFactory.createFile((File)this.localRepoManager.getLocalRoot(), (String[])new String[]{LocalRepoManager.META_DIR_NAME});
    }

    public int getFinalFileCount() throws IOException {
        File finalDir = this.getCryptoChangeSetDtoFinalDir();
        if (!finalDir.exists()) {
            return 0;
        }
        String[] fileNames = finalDir.list();
        if (fileNames == null) {
            return 0;
        }
        int result = 0;
        for (String fileName : fileNames) {
            if (!fileName.startsWith(CRYPTO_CHANGE_SET_DTO_FILE_PREFIX) || !fileName.endsWith(CRYPTO_CHANGE_SET_DTO_FILE_SUFFIX)) continue;
            ++result;
        }
        return result;
    }

    public boolean existsCryptoChangeSetDtoFile(int multiPartIndex) throws IOException {
        File finalDir = this.getCryptoChangeSetDtoFinalDir();
        File finalFile = finalDir.createFile(new String[]{this.getCryptoChangeSetDtoFileName(multiPartIndex)});
        return finalFile.exists();
    }

    public void writeCryptoChangeSetDtoFile(int multiPartIndex, byte[] fileData) throws IOException {
        File tmpDir = this.getCryptoChangeSetDtoTmpDir();
        File tmpFile = tmpDir.createFile(new String[]{this.getCryptoChangeSetDtoFileName(multiPartIndex)});
        File finalDir = this.getCryptoChangeSetDtoFinalDir();
        File finalFile = finalDir.createFile(new String[]{this.getCryptoChangeSetDtoFileName(multiPartIndex)});
        if (!finalDir.isDirectory()) {
            finalDir.mkdir();
            if (!finalDir.isDirectory()) {
                throw new IOException("Creating directory failed: " + finalDir.getAbsolutePath());
            }
        }
        try (IOutputStream out = tmpFile.createOutputStream();){
            out.write(fileData);
        }
        finalFile.deleteRecursively();
        if (!tmpFile.renameTo(finalFile)) {
            throw new IOException(String.format("Renaming '%s' to '%s' failed!", tmpFile.getAbsolutePath(), finalFile.getAbsolutePath()));
        }
    }

    public void markCryptoChangeSetDtoImported(int multiPartIndex) throws IOException {
        File finalDir = this.getCryptoChangeSetDtoFinalDir();
        File finalFile = finalDir.createFile(new String[]{this.getCryptoChangeSetDtoFileName(multiPartIndex)});
        if (!finalFile.isFile()) {
            throw new IllegalArgumentException("Cannot mark nonexistent file: " + finalFile.getAbsolutePath());
        }
        File markerFile = finalDir.createFile(new String[]{this.getCryptoChangeSetDtoFileName(multiPartIndex) + CRYPTO_CHANGE_SET_DTO_FILE_IMPORTED_SUFFIX});
        markerFile.createNewFile();
        if (!markerFile.isFile()) {
            throw new IOException("Creating file failed: " + markerFile.getAbsolutePath());
        }
    }

    public boolean isCryptoChangeSetDtoImported(int multiPartIndex) throws IOException {
        File finalDir = this.getCryptoChangeSetDtoFinalDir();
        File finalFile = finalDir.createFile(new String[]{this.getCryptoChangeSetDtoFileName(multiPartIndex)});
        if (!finalFile.isFile()) {
            throw new IllegalArgumentException("Nonexistent file: " + finalFile.getAbsolutePath());
        }
        File markerFile = finalDir.createFile(new String[]{this.getCryptoChangeSetDtoFileName(multiPartIndex) + CRYPTO_CHANGE_SET_DTO_FILE_IMPORTED_SUFFIX});
        return markerFile.isFile();
    }

    public void deleteAll() throws IOException {
        String startsWithFileNameMask = this.remoteRepositoryId.toString() + CRYPTO_CHANGE_SET_DTO_DIR_SUFFIX;
        for (File file : this.getBaseDir().listFiles()) {
            if (!file.getName().startsWith(startsWithFileNameMask)) continue;
            file.deleteRecursively();
        }
    }
}

