/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.repo;

import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.observable.ObservableList;
import org.subshare.core.observable.standard.StandardPostModificationEvent;
import org.subshare.core.observable.standard.StandardPostModificationListener;
import org.subshare.core.observable.standard.StandardPreModificationEvent;
import org.subshare.core.observable.standard.StandardPreModificationListener;
import org.subshare.core.repo.LocalRepo;
import org.subshare.core.repo.LocalRepoImpl;
import org.subshare.core.repo.LocalRepoRegistry;

public class LocalRepoRegistryImpl
implements LocalRepoRegistry {
    private static final Logger logger = LoggerFactory.getLogger(LocalRepoRegistryImpl.class);
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private co.codewizards.cloudstore.core.repo.local.LocalRepoRegistry backendLocalRepoRegistry;
    private Map<UUID, LocalRepo> repositoryId2LocalRepo;
    private final ObservableList<LocalRepo> localRepos;
    private final PreModificationListener preModificationListener = new PreModificationListener();
    private final PostModificationListener postModificationListener = new PostModificationListener();
    private boolean backendLocalRepoRegistryChangeListenerIgnored;
    private final PropertyChangeListener localRepoPropertyChangeListener = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LocalRepoRegistryImpl.this.repositoryId2LocalRepo = null;
            LocalRepo localRepo = (LocalRepo)evt.getSource();
            if (LocalRepo.PropertyEnum.name.name().equals(evt.getPropertyName())) {
                LocalRepoRegistryImpl localRepoRegistryImpl = LocalRepoRegistryImpl.this;
                synchronized (localRepoRegistryImpl) {
                    LocalRepoRegistryImpl.this.backendLocalRepoRegistryChangeListenerIgnored = true;
                    try {
                        String newName;
                        co.codewizards.cloudstore.core.repo.local.LocalRepoRegistry backendLocalRepoRegistry = LocalRepoRegistryImpl.this.getBackendLocalRepoRegistry();
                        UUID repositoryId = localRepo.getRepositoryId();
                        Collection repositoryAliases = backendLocalRepoRegistry.getRepositoryAliases(repositoryId.toString());
                        if (repositoryAliases != null) {
                            for (String repositoryAlias : repositoryAliases) {
                                backendLocalRepoRegistry.removeRepositoryAlias(repositoryAlias);
                            }
                        }
                        if (!StringUtil.isEmpty((String)(newName = (String)evt.getNewValue()))) {
                            backendLocalRepoRegistry.putRepositoryAlias(newName, repositoryId);
                        }
                    }
                    finally {
                        LocalRepoRegistryImpl.this.backendLocalRepoRegistryChangeListenerIgnored = false;
                    }
                }
            }
            LocalRepoRegistryImpl.this.firePropertyChange(LocalRepoRegistry.PropertyEnum.localRepos_localRepo, null, localRepo);
        }
    };
    private final PropertyChangeListener backendLocalRepoRegistryChangeListener = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LocalRepoRegistryImpl localRepoRegistryImpl = LocalRepoRegistryImpl.this;
            synchronized (localRepoRegistryImpl) {
                if (LocalRepoRegistryImpl.this.backendLocalRepoRegistryChangeListenerIgnored) {
                    return;
                }
                co.codewizards.cloudstore.core.repo.local.LocalRepoRegistry backendLocalRepoRegistry = LocalRepoRegistryImpl.this.getBackendLocalRepoRegistry();
                HashSet repositoryIds = new HashSet(backendLocalRepoRegistry.getRepositoryIds());
                ArrayList<LocalRepo> newLocalRepos = new ArrayList<LocalRepo>();
                for (UUID repositoryId : repositoryIds) {
                    LocalRepo localRepo = LocalRepoRegistryImpl.this.getRepositoryId2LocalRepo().get(repositoryId);
                    if (localRepo != null || (localRepo = LocalRepoRegistryImpl.this.createPopulatedLocalRepo(repositoryId)) == null) continue;
                    newLocalRepos.add(localRepo);
                }
                for (LocalRepo localRepo : LocalRepoRegistryImpl.this.localRepos) {
                    UUID repositoryId = localRepo.getRepositoryId();
                    co.codewizards.cloudstore.core.oio.File localRoot = backendLocalRepoRegistry.getLocalRoot(repositoryId);
                    if (localRoot == null) continue;
                    localRepo.setLocalRoot(localRoot);
                    Collection repositoryAliases = backendLocalRepoRegistry.getRepositoryAliases(repositoryId.toString());
                    if (repositoryAliases == null) continue;
                    if (repositoryAliases.isEmpty()) {
                        localRepo.setName(null);
                        continue;
                    }
                    localRepo.setName((String)repositoryAliases.iterator().next());
                }
                for (LocalRepo localRepo : newLocalRepos) {
                    LocalRepoRegistryImpl.this.localRepos.add(localRepo);
                }
                if (repositoryIds.size() < LocalRepoRegistryImpl.this.localRepos.size()) {
                    ArrayList<LocalRepo> localReposToBeRemoved = new ArrayList<LocalRepo>();
                    for (LocalRepo localRepo : LocalRepoRegistryImpl.this.localRepos) {
                        if (repositoryIds.contains(localRepo.getRepositoryId())) continue;
                        localReposToBeRemoved.add(localRepo);
                    }
                    LocalRepoRegistryImpl.this.localRepos.removeAll(localReposToBeRemoved);
                }
            }
        }
    };

    protected LocalRepoRegistryImpl() {
        this.localRepos = ObservableList.decorate(new CopyOnWriteArrayList());
        this.localRepos.getHandler().addPreModificationListener(this.preModificationListener);
        this.localRepos.getHandler().addPostModificationListener(this.postModificationListener);
        this.read();
    }

    private void read() {
        for (UUID repositoryId : this.getBackendLocalRepoRegistry().getRepositoryIds()) {
            LocalRepo localRepo;
            co.codewizards.cloudstore.core.oio.File localRoot = this.getBackendLocalRepoRegistry().getLocalRoot(repositoryId);
            if (localRoot == null || (localRepo = this.createPopulatedLocalRepo(repositoryId)) == null) continue;
            this.localRepos.add(localRepo);
        }
    }

    private boolean isMetaOnly(co.codewizards.cloudstore.core.oio.File localRoot) {
        try {
            localRoot = localRoot.getCanonicalFile();
        }
        catch (IOException e) {
            logger.warn("isMetaOnly: Canonicalising '" + localRoot.getAbsolutePath() + "' failed: " + e, (Throwable)e);
        }
        co.codewizards.cloudstore.core.oio.File configDir = ConfigDir.getInstance().getFile();
        try {
            configDir = configDir.getCanonicalFile();
        }
        catch (IOException e) {
            logger.warn("isMetaOnly: Canonicalising '" + configDir.getAbsolutePath() + "' failed: " + e, (Throwable)e);
        }
        String configDirStr = configDir.getAbsolutePath() + File.separatorChar;
        return localRoot.getAbsolutePath().startsWith(configDirStr);
    }

    private LocalRepo createPopulatedLocalRepo(UUID repositoryId) {
        co.codewizards.cloudstore.core.repo.local.LocalRepoRegistry backendLocalRepoRegistry = this.getBackendLocalRepoRegistry();
        LocalRepo localRepo = this.createLocalRepo(repositoryId);
        co.codewizards.cloudstore.core.oio.File localRoot = backendLocalRepoRegistry.getLocalRoot(repositoryId);
        if (localRoot == null) {
            return null;
        }
        if (this.isMetaOnly(localRoot)) {
            return null;
        }
        localRepo.setLocalRoot(localRoot);
        Collection repositoryAliases = backendLocalRepoRegistry.getRepositoryAliases(repositoryId.toString());
        if (repositoryAliases != null && !repositoryAliases.isEmpty()) {
            localRepo.setName((String)repositoryAliases.iterator().next());
        }
        return localRepo;
    }

    @Override
    public List<LocalRepo> getLocalRepos() {
        return Collections.unmodifiableList(this.localRepos);
    }

    public static LocalRepoRegistry getInstance() {
        return Holder.instance;
    }

    protected synchronized co.codewizards.cloudstore.core.repo.local.LocalRepoRegistry getBackendLocalRepoRegistry() {
        if (this.backendLocalRepoRegistry == null) {
            this.backendLocalRepoRegistry = co.codewizards.cloudstore.core.repo.local.LocalRepoRegistryImpl.getInstance();
            this.backendLocalRepoRegistry.getRepositoryIds();
            this.backendLocalRepoRegistry.addPropertyChangeListener(this.backendLocalRepoRegistryChangeListener);
        }
        return this.backendLocalRepoRegistry;
    }

    protected synchronized Map<UUID, LocalRepo> getRepositoryId2LocalRepo() {
        if (this.repositoryId2LocalRepo == null) {
            HashMap<UUID, LocalRepo> m = new HashMap<UUID, LocalRepo>();
            for (LocalRepo localRepo : this.getLocalRepos()) {
                m.put(localRepo.getRepositoryId(), localRepo);
            }
            this.repositoryId2LocalRepo = Collections.unmodifiableMap(m);
        }
        return this.repositoryId2LocalRepo;
    }

    protected void finalize() throws Throwable {
        co.codewizards.cloudstore.core.repo.local.LocalRepoRegistry backendLocalRepoRegistry = this.backendLocalRepoRegistry;
        if (backendLocalRepoRegistry != null) {
            backendLocalRepoRegistry.removePropertyChangeListener(this.backendLocalRepoRegistryChangeListener);
        }
        super.finalize();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(LocalRepoRegistry.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(LocalRepoRegistry.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), listener);
    }

    protected void firePropertyChange(LocalRepoRegistry.Property property, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(property.name(), oldValue, newValue);
    }

    @Override
    public LocalRepo createLocalRepo(UUID repositoryId) {
        return new LocalRepoImpl(repositoryId);
    }

    private class PostModificationListener
    implements StandardPostModificationListener {
        private PostModificationListener() {
        }

        @Override
        public void modificationOccurred(StandardPostModificationEvent event) {
            LocalRepoRegistryImpl.this.repositoryId2LocalRepo = null;
            LocalRepoRegistryImpl.this.firePropertyChange(LocalRepoRegistry.PropertyEnum.localRepos, null, LocalRepoRegistryImpl.this.getLocalRepos());
        }
    }

    private class PreModificationListener
    implements StandardPreModificationListener {
        private PreModificationListener() {
        }

        @Override
        public void modificationOccurring(StandardPreModificationEvent event) {
            block5: {
                Collection changeCollection;
                block7: {
                    block6: {
                        block4: {
                            changeCollection = event.getChangeCollection();
                            if ((0x3F & event.getType()) == 0) break block4;
                            for (LocalRepo localRepo : changeCollection) {
                                localRepo.addPropertyChangeListener(LocalRepoRegistryImpl.this.localRepoPropertyChangeListener);
                            }
                            break block5;
                        }
                        if ((0x3F00 & event.getType()) == 0) break block6;
                        for (LocalRepo localRepo : changeCollection) {
                            localRepo.removePropertyChangeListener(LocalRepoRegistryImpl.this.localRepoPropertyChangeListener);
                        }
                        break block5;
                    }
                    if ((0x8000 & event.getType()) == 0) break block7;
                    for (LocalRepo localRepo : LocalRepoRegistryImpl.this.localRepos) {
                        localRepo.removePropertyChangeListener(LocalRepoRegistryImpl.this.localRepoPropertyChangeListener);
                    }
                    break block5;
                }
                if ((0x4000 & event.getType()) == 0) break block5;
                for (LocalRepo localRepo : LocalRepoRegistryImpl.this.localRepos) {
                    if (changeCollection.contains(localRepo)) continue;
                    localRepo.removePropertyChangeListener(LocalRepoRegistryImpl.this.localRepoPropertyChangeListener);
                }
            }
        }
    }

    private static final class Holder {
        public static final LocalRepoRegistry instance = new LocalRepoRegistryImpl();

        private Holder() {
        }
    }
}

