/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.Configuration;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.store.Extent;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.Localiser;

public abstract class AbstractSQLQuery
extends Query {
    private static final long serialVersionUID = 3079774959293575353L;
    protected final transient String inputSQL;
    protected transient String compiledSQL = null;
    protected QueryResultMetaData resultMetaData = null;

    public AbstractSQLQuery(StoreManager storeMgr, ExecutionContext ec, AbstractSQLQuery query) {
        this(storeMgr, ec, query.inputSQL);
    }

    public AbstractSQLQuery(StoreManager storeMgr, ExecutionContext ec, String sqlText) {
        super(storeMgr, ec);
        this.candidateClass = null;
        this.filter = null;
        this.imports = null;
        this.explicitVariables = null;
        this.explicitParameters = null;
        this.ordering = null;
        if (sqlText == null) {
            throw new NucleusUserException(Localiser.msg("059001"));
        }
        this.inputSQL = sqlText.replace('\r', ' ').replace('\n', ' ').replace('\t', ' ').trim();
        String firstToken = this.inputSQL.trim().substring(0, 6).toUpperCase();
        if (firstToken.equals("SELECT")) {
            this.type = 0;
        } else if (firstToken.equals("DELETE")) {
            this.type = (short)2;
            this.unique = true;
        } else if (firstToken.equals("UPDATE") || firstToken.equals("INSERT") || firstToken.startsWith("MERGE")) {
            this.type = 1;
            this.unique = true;
        } else {
            this.type = (short)3;
            this.unique = true;
        }
        if (ec.getApiAdapter().getName().equalsIgnoreCase("JDO")) {
            Configuration conf = ec.getNucleusContext().getConfiguration();
            boolean allowAllSyntax = conf.getBooleanProperty("datanucleus.query.sql.allowAll");
            if (ec.getProperty("datanucleus.query.sql.allowAll") != null) {
                allowAllSyntax = ec.getBooleanProperty("datanucleus.query.sql.allowAll");
            }
            if (!allowAllSyntax && !firstToken.equals("SELECT")) {
                throw new NucleusUserException(Localiser.msg("059002", this.inputSQL));
            }
        }
    }

    @Override
    public String getLanguage() {
        return "SQL";
    }

    @Override
    protected void discardCompiled() {
        super.discardCompiled();
        this.compiledSQL = null;
    }

    public String getInputSQL() {
        return this.inputSQL;
    }

    @Override
    public void setCandidates(Extent pcs) {
        throw new NucleusUserException(Localiser.msg("059004"));
    }

    @Override
    public void setCandidates(Collection pcs) {
        throw new NucleusUserException(Localiser.msg("059005"));
    }

    @Override
    public void setResult(String result) {
        throw new NucleusUserException(Localiser.msg("059006"));
    }

    @Override
    public void setResultMetaData(QueryResultMetaData qrmd) {
        this.resultMetaData = qrmd;
        super.setResultClass(null);
    }

    @Override
    public void setResultClass(Class result_cls) {
        super.setResultClass(result_cls);
        this.resultMetaData = null;
    }

    public void setRange(int fromIncl, int toExcl) {
        throw new NucleusUserException(Localiser.msg("059007"));
    }

    @Override
    public void setSubclasses(boolean subclasses) {
        throw new NucleusUserException(Localiser.msg("059004"));
    }

    @Override
    public void setFilter(String filter) {
        throw new NucleusUserException(Localiser.msg("059008"));
    }

    @Override
    public void declareExplicitVariables(String variables) {
        throw new NucleusUserException(Localiser.msg("059009"));
    }

    @Override
    public void declareExplicitParameters(String parameters) {
        throw new NucleusUserException(Localiser.msg("059016"));
    }

    @Override
    public void declareImports(String imports) {
        throw new NucleusUserException(Localiser.msg("059026"));
    }

    @Override
    public void setGrouping(String grouping) {
        throw new NucleusUserException(Localiser.msg("059010"));
    }

    @Override
    public void setOrdering(String ordering) {
        throw new NucleusUserException(Localiser.msg("059011"));
    }

    @Override
    protected long performDeletePersistentAll(Map parameters) {
        throw new NucleusUserException(Localiser.msg("059000"));
    }

    @Override
    public Object executeWithArray(Object[] parameters) {
        HashMap<Integer, Object> parameterMap = new HashMap<Integer, Object>();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                parameterMap.put(i + 1, parameters[i]);
            }
        }
        Map executionMap = this.prepareForExecution(parameterMap);
        return super.executeQuery(executionMap);
    }

    @Override
    public Object executeWithMap(Map executeParameters) {
        Map executionMap = this.prepareForExecution(executeParameters);
        return super.executeQuery(executionMap);
    }

    protected Map prepareForExecution(Map executeParameters) {
        HashMap params = new HashMap();
        if (this.implicitParameters != null) {
            params.putAll(this.implicitParameters);
        }
        if (executeParameters != null) {
            params.putAll(executeParameters);
        }
        this.compileInternal(executeParameters);
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<Object> expectedParams = new ArrayList<Object>();
        boolean complete = false;
        int charPos = 0;
        char[] statement = this.compiledSQL.toCharArray();
        StringBuilder paramName = null;
        int paramPos = 0;
        boolean colonParam = true;
        StringBuilder runtimeJdbcText = new StringBuilder();
        while (!complete) {
            char c = statement[charPos];
            boolean endOfParam = false;
            if (c == '?') {
                colonParam = false;
                ++paramPos;
                paramName = new StringBuilder();
            } else if (c == ':') {
                if (charPos > 0) {
                    char c2 = statement[charPos - 1];
                    if (!Character.isLetterOrDigit(c2)) {
                        colonParam = true;
                        ++paramPos;
                        paramName = new StringBuilder();
                    }
                } else {
                    colonParam = true;
                    ++paramPos;
                    paramName = new StringBuilder();
                }
            } else if (paramName != null) {
                if (Character.isLetterOrDigit(c)) {
                    paramName.append(c);
                } else {
                    endOfParam = true;
                }
            }
            if (paramName != null) {
                if (endOfParam) {
                    runtimeJdbcText.append('?');
                    runtimeJdbcText.append(c);
                }
            } else {
                runtimeJdbcText.append(c);
            }
            boolean bl = complete = ++charPos == this.compiledSQL.length();
            if (complete && paramName != null && !endOfParam) {
                runtimeJdbcText.append('?');
            }
            if (paramName == null || !complete && !endOfParam) continue;
            if (paramName.length() > 0) {
                if (colonParam) {
                    expectedParams.add(paramName.toString());
                } else {
                    try {
                        Integer n = Integer.valueOf(paramName.toString());
                        expectedParams.add(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new NucleusUserException("SQL query " + this.inputSQL + " contains an invalid parameter specification " + paramName.toString());
                    }
                }
            } else if (!colonParam) {
                expectedParams.add(paramPos);
            }
            paramName = null;
        }
        this.compiledSQL = runtimeJdbcText.toString();
        if (expectedParams.size() > 0 && params.isEmpty()) {
            throw new NucleusUserException(Localiser.msg("059028", this.inputSQL, "" + expectedParams.size()));
        }
        HashMap executeMap = new HashMap();
        paramPos = 1;
        for (Object e : expectedParams) {
            if (!params.containsKey(e)) {
                throw new NucleusUserException(Localiser.msg("059030", this.inputSQL, "" + e));
            }
            executeMap.put(paramPos, params.get(e));
            paramNames.add("" + paramPos);
            ++paramPos;
        }
        this.parameterNames = paramNames.toArray(new String[paramNames.size()]);
        return executeMap;
    }

    @Override
    protected boolean shouldReturnSingleRow() {
        return this.unique;
    }
}

