/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.qtesla;

import java.util.Arrays;
import org.bouncycastle.pqc.crypto.qtesla.CommonFunction;
import org.bouncycastle.pqc.crypto.qtesla.FederalInformationProcessingStandard202;
import org.bouncycastle.pqc.crypto.qtesla.Polynomial;
import org.bouncycastle.pqc.crypto.qtesla.PolynomialHeuristic;
import org.bouncycastle.pqc.crypto.qtesla.PolynomialProvablySecure;
import org.bouncycastle.pqc.crypto.qtesla.Sample;

public class Test {
    static CommonFunction function = new CommonFunction();
    static FederalInformationProcessingStandard202 fips = new FederalInformationProcessingStandard202();
    static Sample sample = new Sample();
    static Polynomial polynomial = new Polynomial();
    static short shortNumber = (short)-13091;
    static int integerNumber = -857870593;
    static long longNumber = -3684526138270744559L;
    static byte[] byteArray = new byte[]{-85, -68, -51, -34, -17, -16, 1, 18, 35, 52, 69, 86, 103, 120, -119, -102};
    static byte[] seed = new byte[]{18, 35, 52, 69, 86, 103, 120, -119, -102, -85, -68, -51, -34, -17, -15, 19, 36, 53, 70, 87, 104, 121, -118, -101, -84, -67, -50, -33, -31, -14, 20, 37};

    public static void main(String[] args) {
    }

    public static void testMemoryCopy() {
        System.out.println("Test for Memory Copy in Common Function\n");
        byte[] newByteArray = new byte[8];
        function.memoryCopy(newByteArray, 0, byteArray, 2, 8);
        for (int i = 0; i < newByteArray.length; i = (int)((short)(i + 1))) {
            System.out.printf("%02X\t", newByteArray[i]);
        }
        System.out.printf("\n\n", new Object[0]);
    }

    public static void testMemoryEquivalence() {
        System.out.println("Test for Memory Equivalence in Common Function\n");
        byte[] newByteArray = new byte[8];
        function.memoryCopy(newByteArray, 0, byteArray, 2, 8);
        System.out.printf("%B\n\n", function.memoryEqual(byteArray, 2, newByteArray, 0, 8));
        Arrays.fill(newByteArray, (byte)-86);
        System.out.printf("%B\n\n", function.memoryEqual(byteArray, 2, newByteArray, 0, 8));
    }

    public static void testLoadShortNumber() {
        System.out.println("Test for Loading Short Number in Common Function\n");
        System.out.printf("%X\n\n", function.load16(byteArray, 15));
    }

    public static void testLoadIntegerNumber() {
        System.out.println("Test for Loading Integer Number in Common Function\n");
        System.out.printf("%X\n\n", function.load32(byteArray, 13));
    }

    public static void testLoadLongNumber() {
        System.out.println("Test for Loading Long Number in Common Function\n");
        System.out.printf("%X\n\n", function.load64(byteArray, 9));
    }

    public static void testStoreShortNumber() {
        System.out.println("Test for Storing Short Number in Common Function\n");
        byte[] newByteArray = new byte[64];
        function.store16(newByteArray, 4, shortNumber);
        for (int i = 0; i < 2; i = (int)((short)(i + 1))) {
            System.out.printf("%02X\t", newByteArray[i + 4]);
        }
        System.out.printf("\n\n", new Object[0]);
    }

    public static void testStoreIntegerNumber() {
        byte[] newByteArray = new byte[64];
        System.out.println("Test for Storing Integer Number in Common Function\n");
        function.store32(newByteArray, 4, integerNumber);
        for (int i = 0; i < 4; i = (int)((short)(i + 1))) {
            System.out.printf("%02X\t", newByteArray[i + 4]);
        }
        System.out.printf("\n\n", new Object[0]);
    }

    public static void testStoreLongNumber() {
        System.out.println("Test for Storing Long Number in Common Function\n");
        byte[] newByteArray = new byte[64];
        function.store64(newByteArray, 0, longNumber);
        for (int i = 0; i < 8; i = (int)((short)(i + 1))) {
            System.out.printf("%02X\t", newByteArray[i]);
        }
        System.out.printf("\n\n", new Object[0]);
    }

    public static void testModulus7() {
        System.out.println("Test for Modulus 7 in Sample\n");
        System.out.printf("%X\n\n", sample.modulus7(-6066929318394868241L));
    }

    public static void testSampleYIIIP() {
        long[] Y = new long[2048];
        System.out.println("Test for Sampling Y in Sample for Provably-Secure qTESLA Security Category-3\n");
        sample.sampleY(Y, seed, (short)0, 16, (short)2048, 0x7FFFFF, (short)23);
        for (int i = 0; i < 2048; i = (int)((short)(i + 1))) {
            System.out.printf("%016X\t", Y[i]);
            if (i % 4 != 3) continue;
            System.out.printf("LINE %3d\n", i / 4 + 1);
        }
        System.out.printf("\n", new Object[0]);
    }

    public static void testPolynomialGaussSamplerI() {
        System.out.println("Test for Polynomial Gauss Sampler in Sample for Heuristic qTESLA Security Category-1\n");
        long[] data = new long[512];
        sample.polynomialGaussSamplerI(data, seed, (short)0, 128, (short)512, 27.9988, Sample.EXPONENTIAL_DISTRIBUTION_I);
        for (int i = 0; i < 512; i = (int)((short)(i + 1))) {
            System.out.printf("%016X\t", data[i]);
            if (i % 4 != 3) continue;
            System.out.printf("LINE %3d\n", i / 4 + 1);
        }
        System.out.printf("\n", new Object[0]);
    }

    public static void testPolynomialGaussSamplerIIIP() {
        System.out.println("Test for Polynomial Gauss Sampler in Sample for Provably-Secure qTESLA Security Category-3\n");
        long[] data = new long[2048];
        sample.polynomialGaussSamplerIII(data, seed, (short)0, 256, (short)2048, 12.0, Sample.EXPONENTIAL_DISTRIBUTION_P);
        for (int i = 0; i < 2048; i = (int)((short)(i + 1))) {
            System.out.printf("%016X\t", data[i]);
            if (i % 4 != 3) continue;
            System.out.printf("LINE %3d\n", i / 4 + 1);
        }
        System.out.printf("\n", new Object[0]);
    }

    public static void testEncodeC() {
        int i;
        System.out.println("Test for Encoding C in Sample\n");
        short[] positionList = new short[40];
        short[] signList = new short[40];
        sample.encodeC(positionList, signList, seed, (short)0, (short)2048, (short)40);
        System.out.println("Position List\n");
        for (i = 0; i < 40; i = (int)((short)(i + 1))) {
            System.out.printf("%4d\t", positionList[i]);
            if (i % 8 != 7) continue;
            System.out.printf("LINE %d\n", i / 8 + 1);
        }
        System.out.println("\nSignature List\n");
        for (i = 0; i < 40; i = (int)((short)(i + 1))) {
            if (signList[i] > 0) {
                System.out.printf("+", new Object[0]);
            }
            System.out.printf("%d\t", signList[i]);
            if (i % 8 != 7) continue;
            System.out.printf("LINE %d\n", i / 8 + 1);
        }
    }

    public static void testBarrettReductionIIISize() {
        System.out.println("Test for Barrett Reduction in Polynomial for Heuristic qTESLA Security Category-3 (Option for Size)\n");
        System.out.printf("%X\n\n", polynomial.barrett(longNumber, 4206593, (short)1021, (short)32));
    }

    public static void testBarrettReductionIIIP() {
        System.out.println("Test for Barrett Reduction in Polynomial for Provably-Secure qTESLA Security Category-3\n");
        System.out.printf("%X\n\n", polynomial.barrettP(longNumber, 1129725953, (short)15, (short)34));
    }

    public static void testPolynomialMultiplicationIIISize() {
        System.out.println("Test for Polynomial Multiplication in Polynomial for Heuristic qTESLA Security Category-3 (Option for Size)\n");
        long[] longArray = new long[1024];
        polynomial.polynomialMultiplication(longArray, PolynomialHeuristic.ZETA_III_SIZE, PolynomialHeuristic.ZETA_INVERSE_III_SIZE, (short)1024, 4206593, 4148178943L, PolynomialHeuristic.ZETA_III_SIZE);
        for (int i = 0; i < 1024; i = (int)((short)(i + 1))) {
            System.out.printf("%06X\t", longArray[i]);
            if (i % 16 != 15) continue;
            System.out.printf("LINE %2d\n", i / 16 + 1);
        }
        System.out.printf("\n", new Object[0]);
    }

    public static void testPolynomialMultiplicationIIIP() {
        System.out.println("Test for Polynomial Multiplication in Polynomial for Polynomial Multiplication for Provably-Secure qTESLA Security Category-3\n");
        long[] longArray = new long[2048];
        polynomial.polynomialMultiplication(longArray, PolynomialProvablySecure.ZETA_III_P, PolynomialProvablySecure.ZETA_INVERSE_III_P, (short)2048, 1129725953, 861290495L);
        for (int i = 0; i < 2048; i = (int)((short)(i + 1))) {
            System.out.printf("%08X\t", longArray[i]);
            if (i % 8 != 7) continue;
            System.out.printf("LINE %3d\n", i / 8 + 1);
        }
        System.out.printf("\n", new Object[0]);
    }

    public static void testPolynomialAdditionIIIP() {
        System.out.println("Test for Polynomial Addition in Polynomial for Provably-Secure qTESLA Security Category-3\n");
        long[] longArray = new long[2048];
        polynomial.polynomialAddition(longArray, PolynomialProvablySecure.ZETA_III_P, PolynomialProvablySecure.ZETA_INVERSE_III_P, (short)2048);
        for (int i = 0; i < 2048; i = (int)((short)(i + 1))) {
            System.out.printf("%08X\t", longArray[i]);
            if (i % 8 != 7) continue;
            System.out.printf("LINE %3d\n", i / 8 + 1);
        }
        System.out.printf("\n", new Object[0]);
    }

    public static void testPolynomialSubtractionIIISize() {
        System.out.println("Test for Polynomial Subtraction in Heuristic qTESLA Security Category-3 (Option for Size)\n");
        long[] longArray = new long[1024];
        polynomial.polynomialSubtraction(longArray, PolynomialHeuristic.ZETA_III_SIZE, PolynomialHeuristic.ZETA_INVERSE_III_SIZE, (short)1024, 4206593, (short)1021, (short)32);
        for (int i = 0; i < 1024; i = (int)((short)(i + 1))) {
            System.out.printf("%06X\t", longArray[i]);
            if (i % 16 != 15) continue;
            System.out.printf("LINE %2d\n", i / 16 + 1);
        }
        System.out.printf("\n", new Object[0]);
    }

    public static void testPolynomialSubtractionIIIP() {
        System.out.println("Test for Polynomial Subtraction in Polynomial for Provably-Secure qTESLA Security Category-3\n");
        long[] longArray = new long[2048];
        polynomial.polynomialSubtractionP(longArray, PolynomialProvablySecure.ZETA_III_P, PolynomialProvablySecure.ZETA_INVERSE_III_P, (short)2048, 1129725953, (short)15, (short)34);
        for (int i = 0; i < 2048; i = (int)((short)(i + 1))) {
            System.out.printf("%08X\t", longArray[i]);
            if (i % 8 != 7) continue;
            System.out.printf("LINE %3d\n", i / 8 + 1);
        }
        System.out.printf("\n", new Object[0]);
    }

    public static void testPolynomialUniformIIIP() {
        System.out.println("Test for Polynomial Uniform in Polynomial for Provably-Secure qTESLA Security Category-3\n");
        long[] A = new long[10240];
        polynomial.polynomialUniform(A, seed, 0, (short)2048, (short)5, 1129725953, 861290495L, (short)31, (short)180, 851423148);
        for (int k = 0; k < 5; k = (int)((short)(k + 1))) {
            System.out.printf("SAMPLE %d\n\n", k + 1);
            for (int i = 0; i < 2048; i = (int)((short)(i + 1))) {
                System.out.printf("%08X\t", A[i]);
                if (i % 8 != 7) continue;
                System.out.printf("LINE %3d\n", i / 8 + 1);
            }
            System.out.printf("\n", new Object[0]);
        }
    }
}

