/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.crypto.internal.asymmetric.keypairgenerator;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.subshare.crypto.internal.asymmetric.keypairgenerator.AbstractAsymmetricCipherKeyPairGeneratorFactory;

public class RSAKeyPairGeneratorFactory
extends AbstractAsymmetricCipherKeyPairGeneratorFactory {
    private static final BigInteger defaultPublicExponent = BigInteger.valueOf(65537L);
    private static final int defaultCertainty = 12;
    private SecureRandom random;

    public RSAKeyPairGeneratorFactory() {
        this.setAlgorithmName("RSA");
    }

    @Override
    public AsymmetricCipherKeyPairGenerator createAsymmetricCipherKeyPairGenerator(boolean initWithDefaults) {
        RSAKeyPairGenerator generator = new RSAKeyPairGenerator();
        if (initWithDefaults) {
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            generator.init((KeyGenerationParameters)new RSAKeyGenerationParameters(defaultPublicExponent, this.random, 4096, 12));
        }
        return generator;
    }
}

