/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.openpgp.wot.internal.TrustRecord;
import org.bouncycastle.openpgp.wot.internal.Util;

enum TrustRecordType {
    UNUSED(0, TrustRecord.Unused.class),
    VERSION(1, TrustRecord.Version.class),
    HTBL(10, TrustRecord.HashTbl.class),
    HLST(11, TrustRecord.HashLst.class),
    TRUST(12, TrustRecord.Trust.class),
    VALID(13, TrustRecord.Valid.class),
    FREE(254, TrustRecord.Free.class);

    private static volatile Map<Short, TrustRecordType> id2Type;
    private static volatile Map<Class<? extends TrustRecord>, TrustRecordType> class2Type;
    private final short id;
    private Class<? extends TrustRecord> trustRecordClass;

    private TrustRecordType(short id, Class<? extends TrustRecord> trustRecordClass) {
        this.id = id;
        this.trustRecordClass = Util.assertNotNull(trustRecordClass, "trustRecordClass");
    }

    public short getId() {
        return this.id;
    }

    public Class<? extends TrustRecord> getTrustRecordClass() {
        return this.trustRecordClass;
    }

    public static TrustRecordType fromId(short id) {
        TrustRecordType type = TrustRecordType.getId2Type().get(id);
        if (type == null) {
            throw new IllegalArgumentException("id unknown: " + id);
        }
        return type;
    }

    public static TrustRecordType fromClass(Class<? extends TrustRecord> trustRecordClass) {
        Util.assertNotNull(trustRecordClass, "trustRecordClass");
        TrustRecordType type = TrustRecordType.getClass2Type().get(trustRecordClass);
        if (type == null) {
            throw new IllegalArgumentException("trustRecordClass unknown: " + trustRecordClass.getName());
        }
        return type;
    }

    private static Map<Short, TrustRecordType> getId2Type() {
        if (id2Type == null) {
            HashMap<Short, TrustRecordType> m = new HashMap<Short, TrustRecordType>(TrustRecordType.values().length);
            for (TrustRecordType type : TrustRecordType.values()) {
                m.put(type.getId(), type);
            }
            id2Type = Collections.unmodifiableMap(m);
        }
        return id2Type;
    }

    private static Map<Class<? extends TrustRecord>, TrustRecordType> getClass2Type() {
        if (class2Type == null) {
            HashMap<Class<? extends TrustRecord>, TrustRecordType> m = new HashMap<Class<? extends TrustRecord>, TrustRecordType>(TrustRecordType.values().length);
            for (TrustRecordType type : TrustRecordType.values()) {
                m.put(type.getTrustRecordClass(), type);
            }
            class2Type = Collections.unmodifiableMap(m);
        }
        return class2Type;
    }
}

