/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.filetree;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.FileFilter;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.ref.IdentityWeakReference;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.gui.filetree.FileFileTreeItem;
import org.subshare.gui.filetree.FileTreeItem;
import org.subshare.gui.filetree.RefreshListener;
import org.subshare.gui.filetree.RootFileTreeItem;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.util.PlatformUtil;

public class FileTreePane
extends BorderPane {
    private static final Logger logger = LoggerFactory.getLogger(FileTreePane.class);
    private final StringProperty useCaseProperty = new SimpleStringProperty((Object)this, "useCase", "default"){

        public void set(String useCase) {
            AssertUtil.assertNotNull((String)"useCase", (Object)useCase);
        }
    };
    @FXML
    private TreeTableView<FileTreeItem<?>> treeTableView;
    @FXML
    private CheckBox showHiddenFilesCheckBox;
    @FXML
    private Button refreshButton;
    @FXML
    private Button createDirButton;
    @FXML
    private Button renameButton;
    @FXML
    private Button deleteButton;
    @FXML
    private TreeTableColumn<FileTreeItem<?>, String> nameTreeTableColumn;
    @FXML
    private TreeTableColumn<FileTreeItem<?>, String> sizeTreeTableColumn;
    @FXML
    private TreeTableColumn<FileTreeItem<?>, String> lastModifiedTreeTableColumn;
    private final BooleanProperty showHiddenFilesProperty = new SimpleBooleanProperty((Object)this, "showHiddenFiles", false);
    private FileTreeItem<?> rootFileTreeItem;
    private final ObservableSet<File> selectedFiles = FXCollections.observableSet(new HashSet());
    private final ObjectProperty<FileFilter> fileFilterProperty = new SimpleObjectProperty<FileFilter>((Object)this, "fileFilter"){

        public void set(FileFilter newValue) {
            if (FileTreePane.this.updatingSelectedFiles) {
                super.set((Object)newValue);
                return;
            }
            FileTreePane.this.updatingSelectedFiles = true;
            try {
                super.set((Object)newValue);
                FileTreePane.this.treeTableView.getSelectionModel().clearSelection();
            }
            finally {
                FileTreePane.this.updatingSelectedFiles = false;
            }
            for (File f : FileTreePane.this.selectedFiles) {
                FileTreePane.this.selectFileTreeItemForSelectedFile(f);
            }
        }
    };
    private final SetChangeListener<File> selectedFilesChangeListener = new SetChangeListener<File>(){

        public void onChanged(SetChangeListener.Change<? extends File> c) {
            PlatformUtil.assertFxApplicationThread();
            if (c.getElementRemoved() != null) {
                FileTreePane.this.unselectTreeItemForUnselectedFile((File)c.getElementRemoved());
            }
            if (c.getElementAdded() != null) {
                FileTreePane.this.selectFileTreeItemForSelectedFile((File)c.getElementAdded());
            }
            FileTreePane.this.updateDisable();
        }
    };
    private boolean updatingSelectedFiles;
    private final CopyOnWriteArrayList<WeakReference<RefreshListener>> refreshListeners = new CopyOnWriteArrayList();
    private final ReferenceQueue<RefreshListener> refreshListenersReferenceQueue = new ReferenceQueue();

    public FileTreePane() {
        FxmlUtil.loadDynamicComponentFxml(FileTreePane.class, this);
        this.rootFileTreeItem = new RootFileTreeItem(this);
        this.treeTableView.setShowRoot(false);
        this.treeTableView.setRoot(this.rootFileTreeItem);
        this.treeTableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.treeTableView.getSelectionModel().selectedItemProperty().addListener((observable, o, n) -> this.updateSelectedFiles());
        this.treeTableView.getSelectionModel().getSelectedItems().addListener(observable -> this.updateSelectedFiles());
        this.selectedFiles.addListener(this.selectedFilesChangeListener);
        this.showHiddenFilesCheckBox.selectedProperty().bindBidirectional((Property)this.showHiddenFilesProperty);
        this.selectedFiles.add((Object)IOUtil.getUserHome());
        this.updateDisable();
    }

    private void updateDisable() {
        int seletectItemsSize = this.treeTableView.getSelectionModel().getSelectedItems().size();
        this.createDirButton.setDisable(seletectItemsSize != 1);
        this.renameButton.setDisable(seletectItemsSize != 1);
        this.deleteButton.setDisable(seletectItemsSize < 1);
    }

    public boolean isRefreshButtonVisible() {
        return this.refreshButton.isVisible();
    }

    public void setRefreshButtonVisible(boolean visible) {
        this.refreshButton.setVisible(visible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelectedFiles() {
        PlatformUtil.assertFxApplicationThread();
        if (this.updatingSelectedFiles) {
            return;
        }
        this.updatingSelectedFiles = true;
        try {
            ObservableList selectedItems = this.treeTableView.getSelectionModel().getSelectedItems();
            HashSet<File> newSelectedFiles = new HashSet<File>(selectedItems.size());
            for (TreeItem selectedItem : selectedItems) {
                FileTreeItem fileTreeItem = selectedItem == null ? null : (FileTreeItem)((Object)selectedItem.getValue());
                if (!(fileTreeItem instanceof FileFileTreeItem)) continue;
                newSelectedFiles.add(((FileFileTreeItem)fileTreeItem).getFile());
            }
            this.selectedFiles.retainAll(newSelectedFiles);
            this.selectedFiles.addAll(newSelectedFiles);
        }
        finally {
            this.updatingSelectedFiles = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectFileTreeItemForSelectedFile(File file) {
        if (this.updatingSelectedFiles) {
            return;
        }
        this.updatingSelectedFiles = true;
        try {
            FileTreeItem<?> fileTreeItem = this.rootFileTreeItem.findFirst(file);
            if (fileTreeItem == null) {
                IllegalStateException x = new IllegalStateException("File does not have corresponding FileTreeItem: " + file);
                logger.warn("selectFileTreeItemForSelectedFile: " + x, x);
            } else {
                for (TreeItem ti = fileTreeItem.getParent(); ti != null; ti = ti.getParent()) {
                    ti.setExpanded(true);
                }
                this.treeTableView.getSelectionModel().select(fileTreeItem);
                int row = this.treeTableView.getRow(fileTreeItem);
                if (row >= 0) {
                    this.treeTableView.scrollTo(row);
                }
            }
        }
        finally {
            this.updatingSelectedFiles = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unselectTreeItemForUnselectedFile(File file) {
        if (this.updatingSelectedFiles) {
            return;
        }
        this.updatingSelectedFiles = true;
        try {
            LinkedHashSet selectedItems;
            FileTreeItem<?> fileTreeItem = this.rootFileTreeItem.findFirst(file);
            if (fileTreeItem != null && (selectedItems = new LinkedHashSet(this.treeTableView.getSelectionModel().getSelectedItems())).remove(fileTreeItem)) {
                this.treeTableView.getSelectionModel().clearSelection();
                for (TreeItem treeItem : selectedItems) {
                    this.treeTableView.getSelectionModel().select((Object)treeItem);
                }
            }
        }
        finally {
            this.updatingSelectedFiles = false;
        }
    }

    public ObservableSet<File> getSelectedFiles() {
        return this.selectedFiles;
    }

    public void refresh() {
        this.fireRefreshEvent();
    }

    private void fireRefreshEvent() {
        RefreshListener.RefreshEvent event = new RefreshListener.RefreshEvent((Object)this);
        this.expungeRefreshListeners();
        for (Reference reference : this.refreshListeners) {
            RefreshListener listener = (RefreshListener)reference.get();
            if (listener == null) continue;
            listener.onRefresh(event);
        }
    }

    protected void addRefreshListener(RefreshListener listener) {
        this.expungeRefreshListeners();
        this.refreshListeners.add((WeakReference<RefreshListener>)new IdentityWeakReference(AssertUtil.assertNotNull((String)"listener", (Object)listener), this.refreshListenersReferenceQueue));
    }

    protected void removeRefreshListener(RefreshListener listener) {
        this.expungeRefreshListeners();
        this.refreshListeners.remove(new IdentityWeakReference(AssertUtil.assertNotNull((String)"listener", (Object)listener)));
    }

    private void expungeRefreshListeners() {
        Reference<RefreshListener> ref;
        while ((ref = this.refreshListenersReferenceQueue.poll()) != null) {
            this.refreshListeners.remove(ref);
        }
    }

    public SelectionMode getSelectionMode() {
        return this.treeTableView.getSelectionModel().getSelectionMode();
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        AssertUtil.assertNotNull((String)"selectionMode", (Object)selectionMode);
        this.treeTableView.getSelectionModel().setSelectionMode(selectionMode);
    }

    protected TreeTableView<FileTreeItem<?>> getTreeTableView() {
        return this.treeTableView;
    }

    public FileTreeItem<?> getRootFileTreeItem() {
        return this.rootFileTreeItem;
    }

    public void setRootFileTreeItem(FileTreeItem<?> rootFileTreeItem) {
        this.rootFileTreeItem = rootFileTreeItem;
        this.treeTableView.setRoot(rootFileTreeItem);
    }

    public BooleanProperty showHiddenFilesProperty() {
        return this.showHiddenFilesProperty;
    }

    public ObjectProperty<FileFilter> fileFilterProperty() {
        return this.fileFilterProperty;
    }

    public String getUseCase() {
        return (String)this.useCaseProperty.get();
    }

    public void setUseCase(String useCase) {
        this.useCaseProperty.set((Object)useCase);
    }

    public StringProperty useCaseProperty() {
        return this.useCaseProperty;
    }

    public void requestFocus() {
        super.requestFocus();
        this.treeTableView.requestFocus();
    }

    @FXML
    private void refreshButtonClicked(ActionEvent event) {
        this.fireRefreshEvent();
        this.treeTableView.refresh();
    }

    @FXML
    private void createDirButtonClicked(ActionEvent event) {
        File parent = (File)AssertUtil.assertNotNull((String)"getSelectedDirectory()", (Object)this.getSelectedDirectory());
        String dirName = this.showCreateOrRenameDialog("Create folder", "What should be the new folder's name?", parent, null, name -> !OioFileFactory.createFile((File)parent, (String[])new String[]{name}).exists());
        if (dirName != null) {
            File directory = OioFileFactory.createFile((File)parent, (String[])new String[]{dirName});
            directory.mkdirs();
            if (!directory.isDirectory()) {
                this.showErrorDialog("Failed to create directory!", "The directory could not be created! Maybe you're missing the required permissions?!");
            } else {
                this.refresh();
                this.getSelectedFiles().clear();
                this.getSelectedFiles().add((Object)directory);
            }
        }
    }

    @FXML
    private void renameButtonClicked(ActionEvent event) {
        File selectedFile = this.getSelectedFile();
        File parent = selectedFile.getParentFile();
        String newName = this.showCreateOrRenameDialog("Rename", "What should be the new name?", parent, selectedFile.getName(), name -> !selectedFile.getName().equals(name) && !OioFileFactory.createFile((File)parent, (String[])new String[]{name}).exists());
        if (newName != null) {
            File newFile = OioFileFactory.createFile((File)parent, (String[])new String[]{newName});
            if (!selectedFile.renameTo(newFile)) {
                this.showErrorDialog("Failed to rename file!", "The file could not be renamed! Maybe you're missing the required permissions?!");
            } else {
                this.refresh();
                this.getSelectedFiles().clear();
                this.getSelectedFiles().add((Object)newFile);
            }
        }
    }

    @FXML
    private void deleteButtonClicked(ActionEvent event) {
        ObservableSet<File> selectedFiles = this.getSelectedFiles();
        if (selectedFiles.isEmpty()) {
            return;
        }
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Delete");
        alert.setHeaderText("Delete these files?");
        VBox contentContainer = new VBox();
        contentContainer.setSpacing(8.0);
        Text contentText = new Text("The following files and folders are about to be deleted (folders recursively!):");
        contentText.setWrappingWidth(400.0);
        contentContainer.getChildren().add((Object)contentText);
        ListView fileListView = new ListView();
        for (File file : selectedFiles) {
            fileListView.getItems().add((Object)file.getAbsolutePath());
        }
        fileListView.setPrefSize(400.0, 200.0);
        contentContainer.getChildren().add((Object)fileListView);
        alert.getDialogPane().setContent((Node)contentContainer);
        if (alert.showAndWait().get() == ButtonType.OK) {
            ArrayList<File> notDeletedFiles = new ArrayList<File>();
            for (File file : selectedFiles) {
                file.deleteRecursively();
                if (!file.exists()) continue;
                notDeletedFiles.add(file);
            }
            this.refresh();
            if (!notDeletedFiles.isEmpty()) {
                this.showErrorDialog("Deleting failed!", "The selected files (or directories) could be not deleted. They may have been deleted partially, though.");
            }
        }
    }

    private String showCreateOrRenameDialog(String title, String headerText, File parent, String name, NameVerifier nameVerifier) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle(title);
        alert.setHeaderText(headerText);
        GridPane contentContainer = new GridPane();
        contentContainer.setPadding(new Insets(8.0));
        contentContainer.setHgap(8.0);
        contentContainer.setVgap(8.0);
        contentContainer.add((Node)new Label("Parent:"), 0, 0);
        TextField parentTextField = new TextField();
        parentTextField.setEditable(false);
        parentTextField.setText(parent.getAbsolutePath());
        contentContainer.add((Node)parentTextField, 1, 0);
        contentContainer.add((Node)new Label("Name:"), 0, 1);
        TextField dirNameTextField = new TextField();
        dirNameTextField.setText(name);
        GridPane.setHgrow((Node)dirNameTextField, (Priority)Priority.ALWAYS);
        contentContainer.add((Node)dirNameTextField, 1, 1);
        InvalidationListener updateDisableInvalidationListener = observable -> {
            String dirName = dirNameTextField.getText();
            Node okButton = alert.getDialogPane().lookupButton(ButtonType.OK);
            if (StringUtil.isEmpty((String)dirName)) {
                okButton.setDisable(true);
            } else {
                boolean nameAcceptable = nameVerifier.isNameAcceptable(dirName);
                okButton.setDisable(!nameAcceptable);
            }
        };
        dirNameTextField.textProperty().addListener(updateDisableInvalidationListener);
        alert.getDialogPane().setContent((Node)contentContainer);
        alert.setOnShowing(event -> {
            dirNameTextField.requestFocus();
            dirNameTextField.selectAll();
            updateDisableInvalidationListener.invalidated(null);
        });
        if (alert.showAndWait().get() == ButtonType.OK) {
            return dirNameTextField.getText();
        }
        return null;
    }

    private void showErrorDialog(String headerText, String contentText) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setHeaderText(headerText);
        alert.setContentText(contentText);
        alert.showAndWait();
    }

    private File getSelectedFile() {
        Iterator iterator = this.getSelectedFiles().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        File file = (File)iterator.next();
        if (iterator.hasNext()) {
            return null;
        }
        return file;
    }

    private File getSelectedDirectory() {
        File directory = this.getSelectedFile();
        if (directory != null && !directory.isDirectory()) {
            directory = directory.getParentFile();
        }
        return directory;
    }

    protected TreeTableColumn<FileTreeItem<?>, String> getNameTreeTableColumn() {
        return this.nameTreeTableColumn;
    }

    protected TreeTableColumn<FileTreeItem<?>, String> getSizeTreeTableColumn() {
        return this.sizeTreeTableColumn;
    }

    protected TreeTableColumn<FileTreeItem<?>, String> getLastModifiedTreeTableColumn() {
        return this.lastModifiedTreeTableColumn;
    }

    @FunctionalInterface
    private static interface NameVerifier {
        public boolean isNameAcceptable(String var1);
    }
}

