/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.selectkey;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableSet;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import org.subshare.core.pgp.PgpKey;
import org.subshare.gui.pgp.keytree.PgpKeyPgpKeyTreeItem;
import org.subshare.gui.pgp.keytree.PgpKeyTreeItem;
import org.subshare.gui.pgp.keytree.PgpKeyTreePane;
import org.subshare.gui.pgp.keytree.SimpleRootPgpKeyTreeItem;
import org.subshare.gui.util.FxmlUtil;

public abstract class SelectPgpKeyPane
extends GridPane {
    private final List<PgpKey> pgpKeys;
    private final ObservableSet<PgpKey> selectedPgpKeys;
    private final List<PgpKeyPgpKeyTreeItem> pgpKeyPgpKeyTreeItems;
    private final Timer applyFilterLaterTimer = new Timer(true);
    private TimerTask applyFilterLaterTimerTask;
    private final SimpleRootPgpKeyTreeItem simpleRootPgpKeyTreeItem;
    @FXML
    private Text headerText;
    @FXML
    private TextField filterTextField;
    @FXML
    private PgpKeyTreePane pgpKeyTreePane;
    @FXML
    private Button okButton;
    @FXML
    private Button cancelButton;
    private final ListChangeListener<TreeItem<PgpKeyTreeItem<?>>> selectedItemsChangeListener = new ListChangeListener<TreeItem<PgpKeyTreeItem<?>>>(){

        public void onChanged(ListChangeListener.Change<? extends TreeItem<PgpKeyTreeItem<?>>> c) {
            while (c.next()) {
                PgpKeyPgpKeyTreeItem item;
                ArrayList<PgpKey> pgpKeys = new ArrayList<PgpKey>(c.getRemoved().size());
                for (TreeItem treeItem : c.getRemoved()) {
                    item = SelectPgpKeyPane.this.getPgpKeyPgpKeyTreeItem(treeItem);
                    if (item == null) continue;
                    pgpKeys.add(item.getPgpKey());
                }
                SelectPgpKeyPane.this.selectedPgpKeys.removeAll(pgpKeys);
                pgpKeys = new ArrayList(c.getAddedSubList().size());
                for (TreeItem treeItem : c.getAddedSubList()) {
                    item = SelectPgpKeyPane.this.getPgpKeyPgpKeyTreeItem(treeItem);
                    if (item == null) continue;
                    pgpKeys.add(item.getPgpKey());
                }
                SelectPgpKeyPane.this.selectedPgpKeys.addAll(pgpKeys);
            }
        }
    };

    public SelectPgpKeyPane(List<PgpKey> pgpKeys, Collection<PgpKey> selectedPgpKeys, SelectionMode selectionMode, String headerText) {
        PgpKeyPgpKeyTreeItem treeItem;
        AssertUtil.assertNotNull((String)"pgpKeys", pgpKeys);
        AssertUtil.assertNotNull((String)"selectionMode", (Object)selectionMode);
        FxmlUtil.loadDynamicComponentFxml(SelectPgpKeyPane.class, this);
        this.headerText.setText(headerText);
        this.simpleRootPgpKeyTreeItem = new SimpleRootPgpKeyTreeItem(this.pgpKeyTreePane);
        this.pgpKeys = pgpKeys;
        this.pgpKeyPgpKeyTreeItems = new ArrayList<PgpKeyPgpKeyTreeItem>(pgpKeys.size());
        IdentityHashMap<PgpKey, PgpKeyPgpKeyTreeItem> pgpKey2TreeItem = new IdentityHashMap<PgpKey, PgpKeyPgpKeyTreeItem>();
        for (PgpKey pgpKey : pgpKeys) {
            if (pgpKey2TreeItem.put(pgpKey, treeItem = new PgpKeyPgpKeyTreeItem(pgpKey)) != null) {
                throw new IllegalArgumentException("Duplicate PgpKey element: " + pgpKey);
            }
            this.pgpKeyPgpKeyTreeItems.add(treeItem);
        }
        this.simpleRootPgpKeyTreeItem.getChildren().addAll(this.pgpKeyPgpKeyTreeItems);
        this.pgpKeyTreePane.getTreeTableView().setRoot((TreeItem)this.simpleRootPgpKeyTreeItem);
        this.selectedPgpKeys = FXCollections.observableSet(new HashSet<PgpKey>(selectedPgpKeys != null ? selectedPgpKeys : Collections.emptyList()));
        for (PgpKey pgpKey : this.selectedPgpKeys) {
            treeItem = (PgpKeyPgpKeyTreeItem)((Object)pgpKey2TreeItem.get(pgpKey));
            if (treeItem == null) {
                throw new IllegalArgumentException("selectedPgpKeys contains PgpKey not being contained in pgpKeys: " + pgpKey);
            }
            this.pgpKeyTreePane.getTreeTableView().getSelectionModel().getSelectedItems().add((Object)treeItem);
        }
        this.filterTextField.textProperty().addListener(observable -> this.applyFilterLater());
        this.pgpKeyTreePane.getTreeTableView().getSelectionModel().getSelectedItems().addListener(this.selectedItemsChangeListener);
        this.pgpKeyTreePane.getTreeTableView().getSelectionModel().setSelectionMode(selectionMode);
        this.selectedPgpKeys.addListener(observable -> this.updateDisable());
        this.updateDisable();
    }

    private void applyFilterLater() {
        if (this.applyFilterLaterTimerTask != null) {
            this.applyFilterLaterTimerTask.cancel();
            this.applyFilterLaterTimerTask = null;
        }
        this.applyFilterLaterTimerTask = new TimerTask(){

            @Override
            public void run() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SelectPgpKeyPane.this.applyFilterLaterTimerTask = null;
                        SelectPgpKeyPane.this.applyFilter();
                    }
                });
            }
        };
        this.applyFilterLaterTimer.schedule(this.applyFilterLaterTimerTask, 300L);
    }

    private void applyFilter() {
        String filterText = this.filterTextField.getText().toLowerCase();
        Iterator<PgpKeyPgpKeyTreeItem> sourceIterator = this.pgpKeyPgpKeyTreeItems.iterator();
        ListIterator treeItemIterator = (ListIterator)Util.cast((Object)this.simpleRootPgpKeyTreeItem.getChildren().listIterator());
        HashSet<PgpKey> includedPgpKeys = new HashSet<PgpKey>();
        while (sourceIterator.hasNext()) {
            PgpKeyPgpKeyTreeItem treeItem;
            PgpKeyPgpKeyTreeItem sourceItem = sourceIterator.next();
            boolean matchesFilter = this.matchesFilter(sourceItem, filterText);
            if (matchesFilter) {
                includedPgpKeys.add(sourceItem.getPgpKey());
            }
            PgpKeyPgpKeyTreeItem pgpKeyPgpKeyTreeItem = treeItem = treeItemIterator.hasNext() ? (PgpKeyPgpKeyTreeItem)((Object)treeItemIterator.next()) : null;
            if (treeItem == null) {
                if (!matchesFilter) continue;
                treeItemIterator.add(sourceItem);
                continue;
            }
            if (treeItem == sourceItem) {
                if (matchesFilter) continue;
                treeItemIterator.remove();
                continue;
            }
            if (matchesFilter) {
                treeItemIterator.previous();
                treeItemIterator.add(sourceItem);
                continue;
            }
            treeItemIterator.previous();
        }
        while (treeItemIterator.hasNext()) {
            treeItemIterator.next();
            treeItemIterator.remove();
        }
        this.selectedPgpKeys.retainAll(includedPgpKeys);
    }

    private boolean matchesFilter(PgpKeyPgpKeyTreeItem treeItem, String filterText) {
        if (StringUtil.isEmpty((String)filterText)) {
            return true;
        }
        PgpKey pgpKey = treeItem.getPgpKey();
        for (String userId : pgpKey.getUserIds()) {
            if (!userId.toLowerCase().contains(filterText)) continue;
            return true;
        }
        return false;
    }

    public void requestFocus() {
        super.requestFocus();
        this.pgpKeyTreePane.requestFocus();
    }

    private PgpKeyPgpKeyTreeItem getPgpKeyPgpKeyTreeItem(TreeItem<PgpKeyTreeItem<?>> treeItem) {
        while (treeItem != null) {
            if (treeItem instanceof PgpKeyPgpKeyTreeItem) {
                return (PgpKeyPgpKeyTreeItem)treeItem;
            }
            treeItem = treeItem.getParent();
        }
        return null;
    }

    protected void updateDisable() {
        this.okButton.setDisable(this.selectedPgpKeys.isEmpty());
    }

    public ObservableSet<PgpKey> getSelectedPgpKeys() {
        return this.selectedPgpKeys;
    }

    @FXML
    protected abstract void okButtonClicked(ActionEvent var1);

    @FXML
    protected abstract void cancelButtonClicked(ActionEvent var1);
}

