/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.auth;

import co.codewizards.cloudstore.core.auth.BouncyCastleRegistrationUtil;
import co.codewizards.cloudstore.core.auth.EncryptedSignedAuthToken;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedAuthTokenEncrypter {
    private static final Logger logger = LoggerFactory.getLogger(SignedAuthTokenEncrypter.class);
    public static final int DEFAULT_KEY_SIZE = 128;
    public static final String CONFIG_KEY_KEY_SIZE = "authTokenEncryption.keySize";
    private static SecureRandom random = new SecureRandom();
    private PublicKey publicKey;

    public SignedAuthTokenEncrypter(byte[] publicKeyData) {
        AssertUtil.assertNotNull("publicKeyData", publicKeyData);
        BouncyCastleRegistrationUtil.registerBouncyCastleIfNeeded();
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKeyData);
            this.publicKey = keyFactory.generatePublic(publicKeySpec);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public EncryptedSignedAuthToken encrypt(byte[] signedAuthTokenData) {
        try {
            byte[] symKey = new byte[this.getKeySize() / 8];
            random.nextBytes(symKey);
            Cipher asymCipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA1ANDMGF1PADDING");
            asymCipher.init(1, this.publicKey);
            byte[] symKeyEncrypted = asymCipher.doFinal(symKey);
            Cipher symCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            symCipher.init(1, new SecretKeySpec(symKey, "AES"));
            byte[] symIV = symCipher.getIV();
            byte[] signedAuthTokenDataEncrypted = symCipher.doFinal(signedAuthTokenData);
            EncryptedSignedAuthToken result = new EncryptedSignedAuthToken();
            result.setEncryptedSignedAuthTokenData(signedAuthTokenDataEncrypted);
            result.setEncryptedSignedAuthTokenDataIV(symIV);
            result.setEncryptedSymmetricKey(symKeyEncrypted);
            return result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected int getKeySize() {
        int keySize = ConfigImpl.getInstance().getPropertyAsInt(CONFIG_KEY_KEY_SIZE, 128);
        if (keySize < 64) {
            logger.warn("Config key '{}': keySize {} is out of range! Using default {} instead!", new Object[]{CONFIG_KEY_KEY_SIZE, keySize, 128});
            return 128;
        }
        return keySize;
    }
}

