/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.collection;

import co.codewizards.cloudstore.core.ref.IdentityWeakReference;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakIdentityHashMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ReferenceQueue<K> keyRefQueue = new ReferenceQueue();
    private final HashMap<Reference<K>, V> delegate;
    private transient Set<Map.Entry<K, V>> entrySet;

    public WeakIdentityHashMap() {
        this.delegate = new HashMap();
    }

    public WeakIdentityHashMap(int initialCapacity) {
        this.delegate = new HashMap(initialCapacity);
    }

    public WeakIdentityHashMap(Map<? extends K, ? extends V> map) {
        this(AssertUtil.assertNotNull("map", map).size());
        this.putAll(map);
    }

    public WeakIdentityHashMap(int initialCapacity, float loadFactor) {
        this.delegate = new HashMap(initialCapacity, loadFactor);
    }

    @Override
    public V get(Object key) {
        this.expunge();
        WeakReference<Object> keyRef = this.createReference(key);
        return this.delegate.get(keyRef);
    }

    @Override
    public V put(K key, V value) {
        this.expunge();
        AssertUtil.assertNotNull("key", key);
        WeakReference<K> keyRef = this.createReference(key, this.keyRefQueue);
        return this.delegate.put(keyRef, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.expunge();
        AssertUtil.assertNotNull("map", map);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            AssertUtil.assertNotNull("entry.key", key);
            WeakReference<K> keyRef = this.createReference(key, this.keyRefQueue);
            this.delegate.put(keyRef, entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        this.expunge();
        WeakReference<Object> keyref = this.createReference(key);
        return this.delegate.remove(keyref);
    }

    @Override
    public void clear() {
        this.expunge();
        this.delegate.clear();
    }

    @Override
    public int size() {
        this.expunge();
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        this.expunge();
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.expunge();
        WeakReference<Object> keyRef = this.createReference(key);
        return this.delegate.containsKey(keyRef);
    }

    @Override
    public boolean containsValue(Object value) {
        this.expunge();
        return this.delegate.containsValue(value);
    }

    @Override
    public Set<K> keySet() {
        this.expunge();
        throw new UnsupportedOperationException("NYI");
    }

    @Override
    public Collection<V> values() {
        this.expunge();
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.expunge();
        Set<Map.Entry<K, V>> es = this.entrySet;
        if (es != null) {
            return es;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    private void expunge() {
        Reference<K> keyRef;
        while ((keyRef = this.keyRefQueue.poll()) != null) {
            this.delegate.remove(keyRef);
        }
    }

    private WeakReference<K> createReference(K referent) {
        return new IdentityWeakReference<K>(referent);
    }

    private WeakReference<K> createReference(K referent, ReferenceQueue<K> q) {
        return new IdentityWeakReference<K>(referent, q);
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<Reference<K>, V>> delegateIterator;
        private Map.Entry<K, V> nextEntry;

        private EntryIterator() {
            this.delegateIterator = WeakIdentityHashMap.this.delegate.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.nextEntry != null) {
                return true;
            }
            this.nextEntry = this.pullNext();
            return this.nextEntry != null;
        }

        @Override
        public Map.Entry<K, V> next() throws NoSuchElementException {
            Map.Entry result = this.nextEntry;
            this.nextEntry = null;
            if (result == null && (result = this.pullNext()) == null) {
                throw new NoSuchElementException();
            }
            return result;
        }

        private Map.Entry<K, V> pullNext() {
            while (this.delegateIterator.hasNext()) {
                final Map.Entry delegateNext = this.delegateIterator.next();
                Object key = delegateNext.getKey().get();
                if (key == null) continue;
                Object value = delegateNext.getValue();
                return new AbstractMap.SimpleEntry<K, V>(key, value){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public V setValue(V value) {
                        return delegateNext.setValue(value);
                    }
                };
            }
            return null;
        }

        @Override
        public void remove() throws IllegalStateException {
            this.delegateIterator.remove();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object keyParam = entry.getKey();
            if (!WeakIdentityHashMap.this.containsKey(keyParam)) {
                return false;
            }
            Object value = WeakIdentityHashMap.this.get(keyParam);
            return Util.equal(value, entry.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object keyParam = entry.getKey();
            if (!WeakIdentityHashMap.this.containsKey(keyParam)) {
                return false;
            }
            WeakIdentityHashMap.this.remove(keyParam);
            return true;
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean modified = false;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (!c.contains(i.next())) continue;
                i.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            Iterator it = this.iterator();
            for (int i = 0; i < size; ++i) {
                result[i] = new AbstractMap.SimpleEntry(it.next());
            }
            return result;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            Iterator it = this.iterator();
            for (int i = 0; i < size; ++i) {
                a[i] = new AbstractMap.SimpleEntry(it.next());
            }
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }
    }
}

