/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.client.transport;

import co.codewizards.cloudstore.core.auth.AuthToken;
import co.codewizards.cloudstore.core.auth.AuthTokenIO;
import co.codewizards.cloudstore.core.auth.AuthTokenVerifier;
import co.codewizards.cloudstore.core.auth.EncryptedSignedAuthToken;
import co.codewizards.cloudstore.core.auth.SignedAuthToken;
import co.codewizards.cloudstore.core.auth.SignedAuthTokenDecrypter;
import co.codewizards.cloudstore.core.auth.SignedAuthTokenIO;
import co.codewizards.cloudstore.core.concurrent.DeferredCompletionException;
import co.codewizards.cloudstore.core.dto.ChangeSetDto;
import co.codewizards.cloudstore.core.dto.ConfigPropSetDto;
import co.codewizards.cloudstore.core.dto.DateTime;
import co.codewizards.cloudstore.core.dto.RepoFileDto;
import co.codewizards.cloudstore.core.dto.RepositoryDto;
import co.codewizards.cloudstore.core.dto.VersionInfoDto;
import co.codewizards.cloudstore.core.io.TimeoutException;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistryImpl;
import co.codewizards.cloudstore.core.repo.transport.AbstractRepoTransport;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.rest.client.ClientBuilderDefaultValuesDecorator;
import co.codewizards.cloudstore.rest.client.CloudStoreRestClient;
import co.codewizards.cloudstore.rest.client.CredentialsProvider;
import co.codewizards.cloudstore.rest.client.request.BeginPutFile;
import co.codewizards.cloudstore.rest.client.request.Copy;
import co.codewizards.cloudstore.rest.client.request.Delete;
import co.codewizards.cloudstore.rest.client.request.EndPutFile;
import co.codewizards.cloudstore.rest.client.request.EndSyncFromRepository;
import co.codewizards.cloudstore.rest.client.request.EndSyncToRepository;
import co.codewizards.cloudstore.rest.client.request.GetChangeSetDto;
import co.codewizards.cloudstore.rest.client.request.GetEncryptedSignedAuthToken;
import co.codewizards.cloudstore.rest.client.request.GetFileData;
import co.codewizards.cloudstore.rest.client.request.GetRepoFileDto;
import co.codewizards.cloudstore.rest.client.request.GetRepositoryDto;
import co.codewizards.cloudstore.rest.client.request.GetVersionInfoDto;
import co.codewizards.cloudstore.rest.client.request.MakeDirectory;
import co.codewizards.cloudstore.rest.client.request.MakeSymlink;
import co.codewizards.cloudstore.rest.client.request.Move;
import co.codewizards.cloudstore.rest.client.request.PutFileData;
import co.codewizards.cloudstore.rest.client.request.PutParentConfigPropSetDto;
import co.codewizards.cloudstore.rest.client.request.RequestRepoConnection;
import co.codewizards.cloudstore.rest.client.ssl.DynamicX509TrustManagerCallback;
import co.codewizards.cloudstore.rest.client.ssl.SSLContextBuilder;
import co.codewizards.cloudstore.rest.client.transport.RestRepoTransportFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.ClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestRepoTransport
extends AbstractRepoTransport
implements CredentialsProvider {
    private static final Logger logger = LoggerFactory.getLogger(RestRepoTransport.class);
    private final long changeSetTimeout = 3600000L;
    private final long fileChunkSetTimeout = 3600000L;
    private UUID repositoryId;
    private byte[] publicKey;
    private String repositoryName;
    private CloudStoreRestClient client;
    private final Map<UUID, AuthToken> clientRepositoryId2AuthToken = new HashMap<UUID, AuthToken>(1);
    private String pathAfterBaseURL;

    protected DynamicX509TrustManagerCallback getDynamicX509TrustManagerCallback() {
        RestRepoTransportFactory repoTransportFactory = (RestRepoTransportFactory)this.getRepoTransportFactory();
        Class<? extends DynamicX509TrustManagerCallback> klass = repoTransportFactory.getDynamicX509TrustManagerCallbackClass();
        if (klass == null) {
            throw new IllegalStateException("dynamicX509TrustManagerCallbackClass is not set!");
        }
        try {
            DynamicX509TrustManagerCallback instance = klass.newInstance();
            return instance;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not instantiate class %s: %s", klass.getName(), e.toString()), e);
        }
    }

    public UUID getRepositoryId() {
        if (this.repositoryId == null) {
            RepositoryDto repositoryDto = this.getRepositoryDto();
            this.repositoryId = repositoryDto.getRepositoryId();
            this.publicKey = repositoryDto.getPublicKey();
        }
        return this.repositoryId;
    }

    public byte[] getPublicKey() {
        this.getRepositoryId();
        return (byte[])AssertUtil.assertNotNull((String)"publicKey", (Object)this.publicKey);
    }

    public RepositoryDto getRepositoryDto() {
        return this.getClient().execute(new GetRepositoryDto(this.getRepositoryName()));
    }

    public void requestRepoConnection(byte[] publicKey) {
        RepositoryDto repositoryDto = new RepositoryDto();
        repositoryDto.setRepositoryId(this.getClientRepositoryIdOrFail());
        repositoryDto.setPublicKey(publicKey);
        this.getClient().execute(new RequestRepoConnection(this.getRepositoryName(), this.getPathPrefix(), repositoryDto));
    }

    public void close() {
        this.client = null;
        super.close();
    }

    public ChangeSetDto getChangeSetDto(boolean localSync) {
        long beginTimestamp = System.currentTimeMillis();
        while (true) {
            try {
                return this.getClient().execute(new GetChangeSetDto(this.getRepositoryId().toString(), localSync));
            }
            catch (DeferredCompletionException x) {
                if (System.currentTimeMillis() > beginTimestamp + 3600000L) {
                    throw new TimeoutException(String.format("Could not get change-set within %s milliseconds!", 3600000L), (Throwable)x);
                }
                logger.info("getChangeSet: Got DeferredCompletionException; will retry.");
                continue;
            }
            break;
        }
    }

    public void prepareForChangeSetDto(ChangeSetDto changeSetDto) {
    }

    public void makeDirectory(String path, Date lastModified) {
        path = this.prefixPath(path);
        this.getClient().execute(new MakeDirectory(this.getRepositoryId().toString(), path, lastModified));
    }

    public void makeSymlink(String path, String target, Date lastModified) {
        path = this.prefixPath(path);
        this.getClient().execute(new MakeSymlink(this.getRepositoryId().toString(), path, target, lastModified));
    }

    public void copy(String fromPath, String toPath) {
        fromPath = this.prefixPath(fromPath);
        toPath = this.prefixPath(toPath);
        this.getClient().execute(new Copy(this.getRepositoryId().toString(), fromPath, toPath));
    }

    public void move(String fromPath, String toPath) {
        fromPath = this.prefixPath(fromPath);
        toPath = this.prefixPath(toPath);
        this.getClient().execute(new Move(this.getRepositoryId().toString(), fromPath, toPath));
    }

    public void delete(String path) {
        path = this.prefixPath(path);
        this.getClient().execute(new Delete(this.getRepositoryId().toString(), path));
    }

    public RepoFileDto getRepoFileDto(String path) {
        path = this.prefixPath(path);
        long beginTimestamp = System.currentTimeMillis();
        while (true) {
            try {
                return this.getClient().execute(new GetRepoFileDto(this.getRepositoryId().toString(), path));
            }
            catch (DeferredCompletionException x) {
                if (System.currentTimeMillis() > beginTimestamp + 3600000L) {
                    throw new TimeoutException(String.format("Could not get file-chunk-set within %s milliseconds!", 3600000L), (Throwable)x);
                }
                logger.info("getFileChunkSet: Got DeferredCompletionException; will retry.");
                continue;
            }
            break;
        }
    }

    public byte[] getFileData(String path, long offset, int length) {
        path = this.prefixPath(path);
        return this.getClient().execute(new GetFileData(this.getRepositoryId().toString(), path, offset, length));
    }

    public void beginPutFile(String path) {
        path = this.prefixPath(path);
        this.getClient().execute(new BeginPutFile(this.getRepositoryId().toString(), path));
    }

    public void putFileData(String path, long offset, byte[] fileData) {
        path = this.prefixPath(path);
        this.getClient().execute(new PutFileData(this.getRepositoryId().toString(), path, offset, fileData));
    }

    public void endPutFile(String path, Date lastModified, long length, String sha1) {
        path = this.prefixPath(path);
        this.getClient().execute(new EndPutFile(this.getRepositoryId().toString(), path, new DateTime(lastModified), length, sha1));
    }

    public void endSyncFromRepository() {
        this.getClient().execute(new EndSyncFromRepository(this.getRepositoryId().toString()));
    }

    public void endSyncToRepository(long fromLocalRevision) {
        this.getClient().execute(new EndSyncToRepository(this.getRepositoryId().toString(), fromLocalRevision));
    }

    public void putParentConfigPropSetDto(ConfigPropSetDto parentConfigPropSetDto) {
        this.getClient().execute(new PutParentConfigPropSetDto(this.getRepositoryId().toString(), parentConfigPropSetDto));
    }

    @Override
    public String getUserName() {
        UUID clientRepositoryId = this.getClientRepositoryIdOrFail();
        return "_repositoryId/" + clientRepositoryId;
    }

    @Override
    public String getPassword() {
        AuthToken authToken = this.getAuthToken();
        return authToken.getPassword();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthToken getAuthToken() {
        UUID clientRepositoryId = this.getClientRepositoryIdOrFail();
        AuthToken authToken = this.clientRepositoryId2AuthToken.get(clientRepositoryId);
        if (authToken != null && this.isAfterRenewalDate(authToken)) {
            logger.debug("getAuthToken: old AuthToken passed renewal-date: clientRepositoryId={} serverRepositoryId={} renewalDateTime={} expiryDateTime={}", new Object[]{clientRepositoryId, this.getRepositoryId(), authToken.getRenewalDateTime(), authToken.getExpiryDateTime()});
            authToken = null;
        }
        if (authToken == null) {
            logger.debug("getAuthToken: getting new AuthToken: clientRepositoryId={} serverRepositoryId={}", (Object)clientRepositoryId, (Object)this.getRepositoryId());
            File localRoot = LocalRepoRegistryImpl.getInstance().getLocalRoot(clientRepositoryId);
            try (LocalRepoManager localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(localRoot);){
                EncryptedSignedAuthToken encryptedSignedAuthToken = this.getClient().execute(new GetEncryptedSignedAuthToken(this.getRepositoryName(), localRepoManager.getRepositoryId()));
                byte[] signedAuthTokenData = new SignedAuthTokenDecrypter(localRepoManager.getPrivateKey()).decrypt(encryptedSignedAuthToken);
                SignedAuthToken signedAuthToken = new SignedAuthTokenIO().deserialise(signedAuthTokenData);
                AuthTokenVerifier verifier = new AuthTokenVerifier(localRepoManager.getRemoteRepositoryPublicKeyOrFail(this.getRepositoryId()));
                verifier.verify(signedAuthToken);
                authToken = new AuthTokenIO().deserialise(signedAuthToken.getAuthTokenData());
                Date expiryDate = ((DateTime)AssertUtil.assertNotNull((String)"authToken.expiryDateTime", (Object)authToken.getExpiryDateTime())).toDate();
                Date renewalDate = ((DateTime)AssertUtil.assertNotNull((String)"authToken.renewalDateTime", (Object)authToken.getRenewalDateTime())).toDate();
                if (!renewalDate.before(expiryDate)) {
                    throw new IllegalArgumentException(String.format("Invalid AuthToken: renewalDateTime >= expiryDateTime :: renewalDateTime=%s expiryDateTime=%s", authToken.getRenewalDateTime(), authToken.getExpiryDateTime()));
                }
                this.clientRepositoryId2AuthToken.put(clientRepositoryId, authToken);
            }
            logger.info("getAuthToken: got new AuthToken: clientRepositoryId={} serverRepositoryId={} renewalDateTime={} expiryDateTime={}", new Object[]{clientRepositoryId, this.getRepositoryId(), authToken.getRenewalDateTime(), authToken.getExpiryDateTime()});
        } else {
            logger.trace("getAuthToken: old AuthToken still valid: clientRepositoryId={} serverRepositoryId={} renewalDateTime={} expiryDateTime={}", new Object[]{clientRepositoryId, this.getRepositoryId(), authToken.getRenewalDateTime(), authToken.getExpiryDateTime()});
        }
        return authToken;
    }

    private boolean isAfterRenewalDate(AuthToken authToken) {
        AssertUtil.assertNotNull((String)"authToken", (Object)authToken);
        return System.currentTimeMillis() > authToken.getRenewalDateTime().getMillis();
    }

    protected CloudStoreRestClient getClient() {
        if (this.client == null) {
            ClientBuilder clientBuilder = this.createClientBuilder();
            CloudStoreRestClient c = new CloudStoreRestClient(this.getRemoteRoot(), clientBuilder);
            c.setCredentialsProvider(this);
            this.client = c;
        }
        return this.client;
    }

    protected URL determineRemoteRootWithoutPathPrefix() {
        String repositoryName = this.getRepositoryName();
        String baseURL = this.getClient().getBaseUrl();
        if (!baseURL.endsWith("/")) {
            throw new IllegalStateException(String.format("baseURL does not end with a '/'! baseURL='%s'", baseURL));
        }
        try {
            return new URL(baseURL + repositoryName);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getRepositoryName() {
        if (this.repositoryName == null) {
            String pathAfterBaseURL = this.getPathAfterBaseURL();
            int indexOfFirstSlash = pathAfterBaseURL.indexOf(47);
            this.repositoryName = indexOfFirstSlash < 0 ? pathAfterBaseURL : pathAfterBaseURL.substring(0, indexOfFirstSlash);
            if (this.repositoryName.isEmpty()) {
                throw new IllegalStateException("repositoryName is empty!");
            }
        }
        return this.repositoryName;
    }

    protected String getPathAfterBaseURL() {
        String pathAfterBaseURL = this.pathAfterBaseURL;
        if (pathAfterBaseURL == null) {
            URL remoteRoot = this.getRemoteRoot();
            if (remoteRoot == null) {
                throw new IllegalStateException("remoteRoot not yet assigned!");
            }
            String baseURL = this.getClient().getBaseUrl();
            if (!baseURL.endsWith("/")) {
                throw new IllegalStateException(String.format("baseURL does not end with a '/'! remoteRoot='%s' baseURL='%s'", remoteRoot, baseURL));
            }
            String remoteRootString = remoteRoot.toExternalForm();
            if (!remoteRootString.startsWith(baseURL)) {
                throw new IllegalStateException(String.format("remoteRoot does not start with baseURL! remoteRoot='%s' baseURL='%s'", remoteRoot, baseURL));
            }
            this.pathAfterBaseURL = pathAfterBaseURL = remoteRootString.substring(baseURL.length());
        }
        return pathAfterBaseURL;
    }

    private ClientBuilder createClientBuilder() {
        ClientBuilderDefaultValuesDecorator builder = new ClientBuilderDefaultValuesDecorator();
        try {
            builder.sslContext(SSLContextBuilder.create().remoteURL(this.getRemoteRoot()).callback(this.getDynamicX509TrustManagerCallback()).build());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        return builder;
    }

    public VersionInfoDto getVersionInfoDto() {
        VersionInfoDto versionInfoDto = this.getClient().execute(new GetVersionInfoDto());
        return versionInfoDto;
    }
}

