/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.util.Collection;
import java.util.HashMap;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.local.persistence.UserIdentity;
import org.subshare.local.persistence.UserIdentityLinkDao;
import org.subshare.local.persistence.UserRepoKeyPublicKey;

public class UserIdentityDao
extends Dao<UserIdentity, UserIdentityDao> {
    private static final Logger logger = LoggerFactory.getLogger(UserIdentityDao.class);

    public UserIdentity getUserIdentityOrFail(Uid userIdentityId) {
        UserIdentity userIdentity = this.getUserIdentity(userIdentityId);
        if (userIdentity == null) {
            throw new IllegalArgumentException("There is no UserIdentity with this userIdentityId: " + userIdentityId);
        }
        return userIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserIdentity getUserIdentity(Uid userIdentityId) {
        AssertUtil.assertNotNull((String)"userIdentityId", (Object)userIdentityId);
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getUserIdentity_userIdentityId");
        try {
            UserIdentity userIdentity;
            UserIdentity userIdentity2 = userIdentity = (UserIdentity)((Object)query.execute((Object)userIdentityId.toString()));
            return userIdentity2;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<UserIdentity> getUserIdentitiesOf(UserRepoKeyPublicKey ofUserRepoKeyPublicKey) {
        AssertUtil.assertNotNull((String)"ofUserRepoKeyPublicKey", (Object)((Object)ofUserRepoKeyPublicKey));
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getUserIdentities_ofUserRepoKeyPublicKey");
        try {
            HashMap<String, UserRepoKeyPublicKey> params = new HashMap<String, UserRepoKeyPublicKey>(1);
            params.put("ofUserRepoKeyPublicKey", ofUserRepoKeyPublicKey);
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.executeWithMap(params);
            logger.debug("getUserIdentitiesOf: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getUserIdentitiesOf: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<UserIdentity> getUserIdentitiesChangedAfter(long localRevision) {
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getUserIdentitiesChangedAfter_localRevision");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.execute((Object)localRevision);
            logger.debug("getUserIdentitiesChangedAfter: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getUserIdentitiesChangedAfter: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    public void deletePersistent(UserIdentity entity) {
        this.deleteDependentObjects(entity);
        this.pm().flush();
        super.deletePersistent((Entity)entity);
    }

    public void deletePersistentAll(Collection<? extends UserIdentity> entities) {
        for (UserIdentity userIdentity : entities) {
            this.deleteDependentObjects(userIdentity);
        }
        this.pm().flush();
        super.deletePersistentAll(entities);
    }

    protected void deleteDependentObjects(UserIdentity userIdentity) {
        AssertUtil.assertNotNull((String)"userIdentity", (Object)((Object)userIdentity));
        UserIdentityLinkDao userIdentityLinkDao = (UserIdentityLinkDao)this.getDao(UserIdentityLinkDao.class);
        userIdentityLinkDao.deletePersistentAll(userIdentityLinkDao.getUserIdentityLinksOf(userIdentity));
    }
}

