/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot.key;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.wot.key.PgpKey;
import org.bouncycastle.openpgp.wot.key.PgpKeyFingerprint;
import org.bouncycastle.openpgp.wot.key.PgpKeyId;
import org.bouncycastle.openpgp.wot.key.PgpKeyRegistryImpl;
import org.bouncycastle.openpgp.wot.key.PgpUserId;

public interface PgpKeyRegistry {
    public File getPubringFile();

    public File getSecringFile();

    public PgpKey getPgpKeyOrFail(PgpKeyId var1) throws IllegalArgumentException;

    public PgpKey getPgpKey(PgpKeyId var1) throws IllegalArgumentException;

    public PgpKey getPgpKeyOrFail(PgpKeyFingerprint var1) throws IllegalArgumentException;

    public PgpKey getPgpKey(PgpKeyFingerprint var1) throws IllegalArgumentException;

    public Collection<PgpKey> getMasterKeys();

    public void markStale();

    public Set<PgpKeyFingerprint> getPgpKeyFingerprintsSignedBy(PgpKeyFingerprint var1);

    public Set<PgpKeyId> getPgpKeyIdsSignedBy(PgpKeyId var1);

    public List<PGPSignature> getSignatures(PgpUserId var1);

    public boolean isCertification(PGPSignature var1);

    public boolean isCertification(int var1);

    public static class Helper {
        public static PgpKeyRegistry createInstance(File pubringFile, File secringFile) {
            return new PgpKeyRegistryImpl(pubringFile, secringFile);
        }
    }
}

