/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.server;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.UrlUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.dto.DeletedUid;
import org.subshare.core.dto.ServerDto;
import org.subshare.core.dto.ServerRegistryDto;
import org.subshare.core.dto.jaxb.ServerRegistryDtoIo;
import org.subshare.core.fbor.FileBasedObjectRegistry;
import org.subshare.core.observable.ObservableList;
import org.subshare.core.observable.standard.StandardPostModificationEvent;
import org.subshare.core.observable.standard.StandardPostModificationListener;
import org.subshare.core.observable.standard.StandardPreModificationEvent;
import org.subshare.core.observable.standard.StandardPreModificationListener;
import org.subshare.core.server.Server;
import org.subshare.core.server.ServerDtoConverter;
import org.subshare.core.server.ServerImpl;
import org.subshare.core.server.ServerRegistry;

public class ServerRegistryImpl
extends FileBasedObjectRegistry
implements ServerRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ServerRegistryImpl.class);
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String SERVER_REGISTRY_FILE_NAME = "serverRegistry.subshare";
    private static final String PAYLOAD_ENTRY_NAME = ServerRegistryDto.class.getSimpleName() + ".xml";
    private final ObservableList<Server> servers;
    private final List<DeletedUid> deletedServerIds = new CopyOnWriteArrayList<DeletedUid>();
    private final ThreadLocal<Boolean> suppressAddToDeletedServerIds = new ThreadLocal();
    private final PreModificationListener preModificationListener = new PreModificationListener();
    private final PostModificationListener postModificationListener = new PostModificationListener();
    private final PropertyChangeListener serverPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ServerRegistryImpl.this.markDirty();
            Server server = (Server)evt.getSource();
            ServerRegistryImpl.this.firePropertyChange(ServerRegistry.PropertyEnum.servers_server, null, server);
        }
    };
    private final File serverRegistryFile;
    private Uid version;

    private void addToDeletedServerIds(Uid serverId) {
        if (!Boolean.TRUE.equals(this.suppressAddToDeletedServerIds.get())) {
            this.deletedServerIds.add(new DeletedUid(serverId));
        }
    }

    private void removeDeletedServerId(Uid serverId) {
        ArrayList<DeletedUid> deletedUidsToRemove = new ArrayList<DeletedUid>();
        for (DeletedUid deletedUid : this.deletedServerIds) {
            if (!serverId.equals((Object)deletedUid.getUid())) continue;
            deletedUidsToRemove.add(deletedUid);
        }
        this.deletedServerIds.removeAll(deletedUidsToRemove);
    }

    protected ServerRegistryImpl() {
        this.servers = ObservableList.decorate(new CopyOnWriteArrayList());
        this.servers.getHandler().addPreModificationListener(this.preModificationListener);
        this.servers.getHandler().addPostModificationListener(this.postModificationListener);
        this.serverRegistryFile = OioFileFactory.createFile((File)ConfigDir.getInstance().getFile(), (String[])new String[]{SERVER_REGISTRY_FILE_NAME});
        this.read();
    }

    @Override
    protected String getContentType() {
        return "application/vnd.subshare.server-registry";
    }

    @Override
    protected void preRead() {
        this.version = null;
    }

    @Override
    protected void postRead() {
        if (this.version == null) {
            this.markDirty();
        }
    }

    @Override
    protected void readPayloadEntry(ZipInputStream zin, ZipEntry zipEntry) throws IOException {
        if (!PAYLOAD_ENTRY_NAME.equals(zipEntry.getName())) {
            logger.warn("readPayloadEntry: Ignoring unexpected zip-entry: {}", (Object)zipEntry.getName());
            return;
        }
        ServerDtoConverter serverDtoConverter = new ServerDtoConverter();
        ServerRegistryDtoIo serverRegistryDtoIo = new ServerRegistryDtoIo();
        ServerRegistryDto serverRegistryDto = (ServerRegistryDto)serverRegistryDtoIo.deserialize(zin);
        for (ServerDto serverDto : serverRegistryDto.getServerDtos()) {
            Server server = serverDtoConverter.fromServerDto(serverDto);
            this.servers.add(server);
        }
        this.deletedServerIds.clear();
        this.deletedServerIds.addAll(serverRegistryDto.getDeletedServerIds());
        this.version = serverRegistryDto.getVersion();
    }

    @Override
    protected File getFile() {
        return this.serverRegistryFile;
    }

    @Override
    public Server getServerForRemoteRoot(URL remoteRoot) {
        AssertUtil.assertNotNull((String)"remoteRoot", (Object)remoteRoot);
        for (Server server : this.servers) {
            if (server.getUrl() == null || !this.isSubUrl(server.getUrl(), remoteRoot)) continue;
            return server;
        }
        return null;
    }

    @Override
    public Server getServer(Uid serverId) {
        AssertUtil.assertNotNull((String)"serverId", (Object)serverId);
        for (Server server : this.servers) {
            if (!serverId.equals((Object)server.getServerId())) continue;
            return server;
        }
        return null;
    }

    private boolean isSubUrl(URL baseUrl, URL subUrl) {
        String subUrlStr;
        AssertUtil.assertNotNull((String)"baseUrl", (Object)subUrl);
        String baseUrlStr = UrlUtil.canonicalizeURL((URL)baseUrl).toExternalForm();
        if (baseUrlStr.contains("?")) {
            throw new IllegalArgumentException("baseUrl should not contain a query part!");
        }
        if (!baseUrlStr.endsWith("/")) {
            baseUrlStr = baseUrlStr + '/';
        }
        if (!(subUrlStr = UrlUtil.canonicalizeURL((URL)subUrl).toExternalForm()).endsWith("/")) {
            subUrlStr = subUrlStr + '/';
        }
        return subUrlStr.startsWith(baseUrlStr);
    }

    public static ServerRegistry getInstance() {
        return Holder.instance;
    }

    @Override
    public List<Server> getServers() {
        return this.servers;
    }

    @Override
    public Server createServer() {
        return new ServerImpl();
    }

    @Override
    protected synchronized void writePayload(ZipOutputStream zout) throws IOException {
        ServerRegistryDtoIo serverRegistryDtoIo = new ServerRegistryDtoIo();
        ServerRegistryDto serverRegistryDto = this.createServerRegistryDto();
        zout.putNextEntry(new ZipEntry(PAYLOAD_ENTRY_NAME));
        serverRegistryDtoIo.serialize(serverRegistryDto, zout);
        zout.closeEntry();
    }

    private ServerRegistryDto createServerRegistryDto() {
        ServerDtoConverter converter = new ServerDtoConverter();
        ServerRegistryDto result = new ServerRegistryDto();
        for (Server server : this.servers) {
            ServerDto serverDto = converter.toServerDto(server);
            result.getServerDtos().add(serverDto);
        }
        result.getDeletedServerIds().addAll(this.deletedServerIds);
        result.setVersion(this.version);
        return result;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(ServerRegistry.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(ServerRegistry.Property property, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), listener);
    }

    protected void firePropertyChange(ServerRegistry.Property property, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(property.name(), oldValue, newValue);
    }

    @Override
    protected void mergeFrom(ZipInputStream zin, ZipEntry zipEntry) {
        if (PAYLOAD_ENTRY_NAME.equals(zipEntry.getName())) {
            ServerRegistryDtoIo serverRegistryDtoIo = new ServerRegistryDtoIo();
            ServerRegistryDto serverRegistryDto = (ServerRegistryDto)serverRegistryDtoIo.deserialize(zin);
            this.mergeFrom(serverRegistryDto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void mergeFrom(ServerRegistryDto serverRegistryDto) {
        AssertUtil.assertNotNull((String)"serverRegistryDto", (Object)serverRegistryDto);
        HashSet<Uid> deletedServerIdSet = new HashSet<Uid>(this.deletedServerIds.size());
        for (DeletedUid deletedUid : this.deletedServerIds) {
            deletedServerIdSet.add(deletedUid.getUid());
        }
        ArrayList<ServerDto> newServerDtos = new ArrayList<ServerDto>(serverRegistryDto.getServerDtos().size());
        for (ServerDto serverDto : serverRegistryDto.getServerDtos()) {
            Uid serverId = (Uid)AssertUtil.assertNotNull((String)"serverDto.serverId", (Object)serverDto.getServerId());
            if (deletedServerIdSet.contains(serverId)) continue;
            Server server = this.getServerByServerId(serverId);
            if (server == null) {
                newServerDtos.add(serverDto);
                continue;
            }
            this.merge(server, serverDto);
        }
        HashSet<DeletedUid> hashSet = new HashSet<DeletedUid>(serverRegistryDto.getDeletedServerIds());
        hashSet.removeAll(this.deletedServerIds);
        HashMap<DeletedUid, Server> newDeletedServers = new HashMap<DeletedUid, Server>(hashSet.size());
        for (DeletedUid deletedServerId : hashSet) {
            Server server = this.getServerByServerId(deletedServerId.getUid());
            if (server == null) continue;
            newDeletedServers.put(deletedServerId, server);
        }
        ServerDtoConverter serverDtoConverter = new ServerDtoConverter();
        for (ServerDto serverDto : newServerDtos) {
            Server server = serverDtoConverter.fromServerDto(serverDto);
            this.servers.add(server);
        }
        this.suppressAddToDeletedServerIds.set(Boolean.TRUE);
        try {
            for (Map.Entry entry : newDeletedServers.entrySet()) {
                this.servers.remove(entry.getValue());
                this.deletedServerIds.add((DeletedUid)entry.getKey());
            }
        }
        finally {
            this.suppressAddToDeletedServerIds.remove();
        }
        this.writeIfNeeded();
    }

    private void merge(Server toServer, ServerDto fromServerDto) {
        AssertUtil.assertNotNull((String)"toServer", (Object)toServer);
        AssertUtil.assertNotNull((String)"fromServerDto", (Object)fromServerDto);
        if (toServer.getChanged().before(fromServerDto.getChanged())) {
            toServer.setName(fromServerDto.getName());
            try {
                toServer.setUrl(fromServerDto.getUrl() == null ? null : new URL(fromServerDto.getUrl()));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            toServer.setChanged(fromServerDto.getChanged());
            if (!toServer.getChanged().equals(fromServerDto.getChanged())) {
                throw new IllegalStateException("toServer.changed != fromServerDto.changed");
            }
        }
    }

    protected Server getServerByServerId(Uid serverId) {
        AssertUtil.assertNotNull((String)"serverId", (Object)serverId);
        for (Server server : this.getServers()) {
            if (!serverId.equals((Object)server.getServerId())) continue;
            return server;
        }
        return null;
    }

    @Override
    protected void markDirty() {
        super.markDirty();
        this.version = new Uid();
        this.deferredWrite();
    }

    public Uid getVersion() {
        return this.version;
    }

    private class PostModificationListener
    implements StandardPostModificationListener {
        private PostModificationListener() {
        }

        @Override
        public void modificationOccurred(StandardPostModificationEvent event) {
            ServerRegistryImpl.this.markDirty();
            ServerRegistryImpl.this.firePropertyChange(ServerRegistry.PropertyEnum.servers, null, ServerRegistryImpl.this.getServers());
        }
    }

    private class PreModificationListener
    implements StandardPreModificationListener {
        private PreModificationListener() {
        }

        @Override
        public void modificationOccurring(StandardPreModificationEvent event) {
            block6: {
                Collection changeCollection;
                block8: {
                    block7: {
                        block5: {
                            changeCollection = event.getChangeCollection();
                            if ((0x3F & event.getType()) == 0) break block5;
                            for (Server server : changeCollection) {
                                if (ServerRegistryImpl.this.getServerByServerId(server.getServerId()) != null) {
                                    throw new UnsupportedOperationException(String.format("Cannot add the same Server (serverId=%s) twice!", server.getServerId()));
                                }
                                server.addPropertyChangeListener(ServerRegistryImpl.this.serverPropertyChangeListener);
                                ServerRegistryImpl.this.removeDeletedServerId(server.getServerId());
                            }
                            break block6;
                        }
                        if ((0x3F00 & event.getType()) == 0) break block7;
                        for (Server server : changeCollection) {
                            server.removePropertyChangeListener(ServerRegistryImpl.this.serverPropertyChangeListener);
                            ServerRegistryImpl.this.addToDeletedServerIds(server.getServerId());
                        }
                        break block6;
                    }
                    if ((0x8000 & event.getType()) == 0) break block8;
                    for (Server server : ServerRegistryImpl.this.servers) {
                        server.removePropertyChangeListener(ServerRegistryImpl.this.serverPropertyChangeListener);
                        ServerRegistryImpl.this.addToDeletedServerIds(server.getServerId());
                    }
                    break block6;
                }
                if ((0x4000 & event.getType()) == 0) break block6;
                for (Server server : ServerRegistryImpl.this.servers) {
                    if (changeCollection.contains(server)) continue;
                    server.removePropertyChangeListener(ServerRegistryImpl.this.serverPropertyChangeListener);
                    ServerRegistryImpl.this.addToDeletedServerIds(server.getServerId());
                }
            }
        }
    }

    private static final class Holder {
        public static final ServerRegistryImpl instance = new ServerRegistryImpl();

        private Holder() {
        }
    }
}

