/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.user;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.bean.AbstractBean;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.crypto.KeyFactory;
import org.subshare.core.observable.ObservableList;
import org.subshare.core.observable.ObservableSet;
import org.subshare.core.observable.standard.StandardPostModificationEvent;
import org.subshare.core.observable.standard.StandardPostModificationListener;
import org.subshare.core.observable.standard.StandardPreModificationEvent;
import org.subshare.core.observable.standard.StandardPreModificationListener;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.PgpRegistry;
import org.subshare.core.sign.SignableSigner;
import org.subshare.core.user.User;
import org.subshare.core.user.UserRepoKey;
import org.subshare.core.user.UserRepoKeyImpl;
import org.subshare.core.user.UserRepoKeyRing;
import org.subshare.core.user.UserRepoKeyRingImpl;

public class UserImpl
extends AbstractBean<User.Property>
implements User {
    private static final Logger logger = LoggerFactory.getLogger(UserImpl.class);
    private Uid userId;
    private String firstName;
    private String lastName;
    private ObservableList<String> emails;
    private UserRepoKeyRing userRepoKeyRing;
    private ObservableList<PgpKeyId> pgpKeyIds;
    private ObservableSet<UserRepoKey.PublicKeyWithSignature> userRepoKeyPublicKeys;
    private final UserRepoKeyRingChangeListener userRepoKeyRingChangeListener = new UserRepoKeyRingChangeListener();
    private Date changed = new Date();

    @Override
    public synchronized Uid getUserId() {
        if (this.userId == null) {
            this.userId = new Uid();
        }
        return this.userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserId(Uid userId) {
        UserImpl userImpl = this;
        synchronized (userImpl) {
            if (this.userId != null && !this.userId.equals((Object)userId)) {
                throw new IllegalStateException("this.userId is already assigned! Cannot modify afterwards!");
            }
        }
        this.setPropertyValue(User.PropertyEnum.userId, userId);
        this.updateChanged();
    }

    @Override
    public synchronized String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.setPropertyValue(User.PropertyEnum.firstName, firstName);
        this.updateChanged();
    }

    @Override
    public synchronized String getLastName() {
        return this.lastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.setPropertyValue(User.PropertyEnum.lastName, lastName);
        this.updateChanged();
    }

    @Override
    public synchronized List<String> getEmails() {
        if (this.emails == null) {
            this.emails = ObservableList.decorate(new CopyOnWriteArrayList());
            this.emails.getHandler().addPostModificationListener(new PostModificationListener(User.PropertyEnum.emails));
        }
        return this.emails;
    }

    @Override
    public synchronized List<PgpKeyId> getPgpKeyIds() {
        if (this.pgpKeyIds == null) {
            this.pgpKeyIds = ObservableList.decorate(new CopyOnWriteArrayList());
            this.pgpKeyIds.getHandler().addPostModificationListener(new PostModificationListener(User.PropertyEnum.pgpKeyIds));
        }
        return this.pgpKeyIds;
    }

    @Override
    public synchronized UserRepoKeyRing getUserRepoKeyRing() {
        return this.userRepoKeyRing;
    }

    @Override
    public void setUserRepoKeyRing(UserRepoKeyRing userRepoKeyRing) {
        UserRepoKeyRing old = this._setUserRepoKeyRing(userRepoKeyRing);
        this.firePropertyChange(User.PropertyEnum.userRepoKeyRing, old, userRepoKeyRing);
        this.updateChanged();
    }

    protected synchronized UserRepoKeyRing _setUserRepoKeyRing(UserRepoKeyRing userRepoKeyRing) {
        UserRepoKeyRing old = this.userRepoKeyRing;
        this.userRepoKeyRing = userRepoKeyRing;
        if (old != null) {
            old.removePropertyChangeListener(this.userRepoKeyRingChangeListener);
        }
        if (userRepoKeyRing != null) {
            userRepoKeyRing.addPropertyChangeListener(this.userRepoKeyRingChangeListener);
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserRepoKeyRing getUserRepoKeyRingOrCreate() {
        UserRepoKeyRing userRepoKeyRing;
        boolean created = false;
        UserImpl userImpl = this;
        synchronized (userImpl) {
            if (!this.getUserRepoKeyPublicKeys().isEmpty()) {
                throw new IllegalStateException(String.format("%s already has public keys! Cannot create a userRepoKeyRing! Either there is a userRepoKeyRing or there are public keys! There cannot be both! userRepoKeyPublicKeys=%s, userRepoKeyRing=%s", this, this.getUserRepoKeyPublicKeys(), this.getUserRepoKeyRing()));
            }
            userRepoKeyRing = this.getUserRepoKeyRing();
            if (userRepoKeyRing == null) {
                created = true;
                userRepoKeyRing = new UserRepoKeyRingImpl();
                this._setUserRepoKeyRing(userRepoKeyRing);
            }
        }
        if (created) {
            this.firePropertyChange(User.PropertyEnum.userRepoKeyRing, null, userRepoKeyRing);
            this.updateChanged();
        }
        return userRepoKeyRing;
    }

    @Override
    public UserRepoKey createUserRepoKey(UUID serverRepositoryId) {
        AssertUtil.assertNotNull((String)"serverRepositoryId", (Object)serverRepositoryId);
        PgpKey pgpKey = this.getPgpKeyContainingSecretKeyOrFail();
        AsymmetricCipherKeyPair keyPair = KeyFactory.getInstance().createAsymmetricKeyPair();
        UserRepoKeyImpl userRepoKey = new UserRepoKeyImpl(serverRepositoryId, keyPair, Collections.singleton(pgpKey), pgpKey, null);
        logger.debug("createUserRepoKey: pgpKey={}, userRepoKey={}", (Object)pgpKey, (Object)userRepoKey);
        UserRepoKeyRing userRepoKeyRing = this.getUserRepoKeyRingOrCreate();
        userRepoKeyRing.addUserRepoKey(userRepoKey);
        return userRepoKey;
    }

    @Override
    public UserRepoKey createInvitationUserRepoKey(User invitedUser, UUID serverRepositoryId, long validityDurationMillis) {
        AssertUtil.assertNotNull((String)"invitedUser", (Object)invitedUser);
        AssertUtil.assertNotNull((String)"serverRepositoryId", (Object)serverRepositoryId);
        PgpKey ownPgpKey = this.getPgpKeyContainingSecretKeyOrFail();
        if (invitedUser.getPgpKeyIds().isEmpty()) {
            throw new IllegalStateException("There is no PGP key associated with the invited user!");
        }
        if (invitedUser.getPgpKeys().isEmpty()) {
            throw new IllegalStateException("None of the PGP keys associated with the invited user is available in our PGP key ring!");
        }
        Set<PgpKey> invitedUserPgpKeys = invitedUser.getValidPgpKeys();
        if (invitedUserPgpKeys.isEmpty()) {
            throw new IllegalStateException("All PGP keys associated with the invited user and available in our PGP key ring are revoked or expired!");
        }
        AsymmetricCipherKeyPair keyPair = KeyFactory.getInstance().createAsymmetricKeyPair();
        UserRepoKeyImpl userRepoKey = new UserRepoKeyImpl(serverRepositoryId, keyPair, invitedUserPgpKeys, ownPgpKey, new Date(System.currentTimeMillis() + validityDurationMillis));
        logger.debug("createInvitationUserRepoKey: ownPgpKey={}, userRepoKey={}", (Object)ownPgpKey, (Object)userRepoKey);
        UserRepoKey signingUserRepoKey = this.getUserRepoKeyRing().getPermanentUserRepoKeys(serverRepositoryId).get(0);
        new SignableSigner(signingUserRepoKey).sign(userRepoKey.getPublicKey());
        return userRepoKey;
    }

    @Override
    public Set<PgpKey> getPgpKeys() {
        Pgp pgp = PgpRegistry.getInstance().getPgpOrFail();
        HashSet<PgpKey> pgpKeys = new HashSet<PgpKey>(this.getPgpKeyIds().size());
        for (PgpKeyId pgpKeyId : this.getPgpKeyIds()) {
            PgpKey k = pgp.getPgpKey(pgpKeyId);
            if (k == null) continue;
            pgpKeys.add(k);
        }
        return Collections.unmodifiableSet(pgpKeys);
    }

    @Override
    public Set<PgpKey> getValidPgpKeys() {
        Set<PgpKey> pgpKeys = this.getPgpKeys();
        Date now = new Date();
        HashSet<PgpKey> result = new HashSet<PgpKey>(pgpKeys.size());
        for (PgpKey pgpKey : pgpKeys) {
            if (!pgpKey.isValid(now)) continue;
            result.add(pgpKey);
        }
        return result;
    }

    @Override
    public PgpKey getPgpKeyContainingSecretKeyOrFail() {
        PgpKey pgpKey = this.getPgpKeyContainingSecretKey();
        if (pgpKey == null) {
            throw new IllegalStateException(String.format("None of the PGP keys associated with %s has a private key available!", this));
        }
        return pgpKey;
    }

    @Override
    public PgpKey getPgpKeyContainingSecretKey() {
        List<PgpKeyId> pgpKeyIds = this.getPgpKeyIds();
        if (pgpKeyIds.isEmpty()) {
            throw new IllegalStateException(String.format("There is no PGP key associated with %s!", this));
        }
        Pgp pgp = PgpRegistry.getInstance().getPgpOrFail();
        PgpKey pgpKey = null;
        for (PgpKeyId pgpKeyId : pgpKeyIds) {
            PgpKey k = pgp.getPgpKey(pgpKeyId);
            if (k == null || !k.isSecretKeyAvailable()) continue;
            pgpKey = k;
            break;
        }
        return pgpKey;
    }

    @Override
    public Set<UserRepoKey.PublicKeyWithSignature> getUserRepoKeyPublicKeys() {
        if (this.userRepoKeyPublicKeys == null) {
            this.userRepoKeyPublicKeys = ObservableSet.decorate(new CopyOnWriteArraySet());
            this.userRepoKeyPublicKeys.getHandler().addPreModificationListener(new PreventUserRepoKeyRingAndPublicKeysCollisionListener());
            this.userRepoKeyPublicKeys.getHandler().addPostModificationListener(new PostModificationListener(User.PropertyEnum.userRepoKeyPublicKeys));
        }
        return this.userRepoKeyPublicKeys;
    }

    @Override
    public List<UserRepoKey.PublicKeyWithSignature> getUserRepoKeyPublicKeys(UUID serverRepositoryId) {
        ArrayList<UserRepoKey.PublicKeyWithSignature> result = new ArrayList();
        for (UserRepoKey.PublicKeyWithSignature publicKey : this.getUserRepoKeyPublicKeys()) {
            if (serverRepositoryId != null && !serverRepositoryId.equals(publicKey.getServerRepositoryId())) continue;
            result.add(publicKey);
        }
        result = Collections.unmodifiableList(result);
        return result;
    }

    @Override
    public Date getChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(Date changed) {
        AssertUtil.assertNotNull((String)"changed", (Object)changed);
        this.setPropertyValue(User.PropertyEnum.changed, changed);
    }

    protected void updateChanged() {
        this.setChanged(new Date());
    }

    public String toString() {
        return String.format("%s[%s, %s, %s, %s, %s]", this.getClass().getSimpleName(), this.userId, this.firstName, this.lastName, this.emails, this.pgpKeyIds);
    }

    @Override
    public UserImpl clone() {
        UserImpl clone = (UserImpl)super.clone();
        if (clone.emails != null) {
            clone.emails = null;
            clone.getEmails().addAll(this.getEmails());
        }
        if (clone.userRepoKeyRing != null) {
            clone.userRepoKeyRing = this.userRepoKeyRing.clone();
        }
        if (clone.pgpKeyIds != null) {
            clone.pgpKeyIds = null;
            clone.getPgpKeyIds().addAll(this.getPgpKeyIds());
        }
        if (clone.userRepoKeyPublicKeys != null) {
            clone.userRepoKeyPublicKeys = null;
            clone.getUserRepoKeyPublicKeys().addAll(this.getUserRepoKeyPublicKeys());
        }
        return clone;
    }

    private class PreventUserRepoKeyRingAndPublicKeysCollisionListener
    implements StandardPreModificationListener {
        private PreventUserRepoKeyRingAndPublicKeysCollisionListener() {
        }

        @Override
        public void modificationOccurring(StandardPreModificationEvent event) {
            if ((0x3F & event.getType()) != 0 && !event.getChangeCollection().isEmpty() && UserImpl.this.getUserRepoKeyRing() != null) {
                throw new IllegalStateException(String.format("%s already has a userRepoKeyRing! Cannot add public keys! Either there is a userRepoKeyRing or there are public keys! There cannot be both! userRepoKeyRing=%s, userRepoKeyPublicKeys=%s, event.changeCollection=%s", UserImpl.this, UserImpl.this.getUserRepoKeyRing(), UserImpl.this.getUserRepoKeyPublicKeys(), event.getChangeCollection()));
            }
        }
    }

    private class UserRepoKeyRingChangeListener
    implements PropertyChangeListener {
        private UserRepoKeyRingChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            UserImpl.this.firePropertyChange(User.PropertyEnum.userRepoKeyRing, null, UserImpl.this.userRepoKeyRing);
        }
    }

    private class PostModificationListener
    implements StandardPostModificationListener {
        private final User.Property property;

        public PostModificationListener(User.Property property) {
            this.property = (User.Property)AssertUtil.assertNotNull((String)"property", (Object)property);
        }

        @Override
        public void modificationOccurred(StandardPostModificationEvent event) {
            UserImpl.this.firePropertyChange(this.property, null, event.getObservedCollection());
            UserImpl.this.updateChanged();
        }
    }
}

