/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.auth;

import co.codewizards.cloudstore.core.auth.SignedAuthToken;
import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.io.ByteArrayOutputStream;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class SignedAuthTokenIO {
    public byte[] serialise(SignedAuthToken signedAuthToken) {
        AssertUtil.assertNotNull("signedAuthToken", signedAuthToken);
        try {
            JAXBContext context = this.createContext();
            Marshaller marshaller = context.createMarshaller();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            marshaller.marshal((Object)signedAuthToken, (OutputStream)os);
            return os.toByteArray();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public SignedAuthToken deserialise(byte[] signedAuthTokenData) {
        AssertUtil.assertNotNull("signedAuthTokenData", signedAuthTokenData);
        try {
            JAXBContext context = this.createContext();
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object object = unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(signedAuthTokenData));
            return (SignedAuthToken)object;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private JAXBContext createContext() throws JAXBException {
        return JAXBContext.newInstance((Class[])new Class[]{SignedAuthToken.class});
    }
}

