/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.repo.local;

import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransactionListener;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;

public class LocalRepoTransactionListenerRegistry {
    private final LocalRepoTransaction transaction;
    private final List<LocalRepoTransactionListener> listeners;
    private static List<Class<? extends LocalRepoTransactionListener>> listenerClasses;

    public LocalRepoTransactionListenerRegistry(LocalRepoTransaction transaction) {
        this.transaction = AssertUtil.assertNotNull("transaction", transaction);
        this.listeners = this.createListeners();
        for (LocalRepoTransactionListener listener : this.listeners) {
            transaction.setContextObject(listener);
        }
    }

    public LocalRepoTransaction getTransaction() {
        return this.transaction;
    }

    public void onBegin() {
        for (LocalRepoTransactionListener listener : this.listeners) {
            listener.onBegin();
        }
    }

    public void onCommit() {
        this.transaction.flush();
        for (LocalRepoTransactionListener listener : this.listeners) {
            listener.onCommit();
            this.transaction.flush();
        }
    }

    public void onRollback() {
        for (LocalRepoTransactionListener listener : this.listeners) {
            listener.onRollback();
        }
    }

    private List<LocalRepoTransactionListener> createListeners() {
        if (listenerClasses == null) {
            LinkedList<LocalRepoTransactionListener> listeners = new LinkedList<LocalRepoTransactionListener>();
            for (LocalRepoTransactionListener listener : ServiceLoader.load(LocalRepoTransactionListener.class)) {
                listener.setTransaction(this.transaction);
                listeners.add(listener);
            }
            this.sortListeners(listeners);
            ArrayList<Class<? extends LocalRepoTransactionListener>> lcl = new ArrayList<Class<? extends LocalRepoTransactionListener>>(listeners.size());
            for (LocalRepoTransactionListener listener : listeners) {
                lcl.add(listener.getClass());
            }
            listenerClasses = lcl;
            return listeners;
        }
        ArrayList<LocalRepoTransactionListener> listeners = new ArrayList<LocalRepoTransactionListener>(listenerClasses.size());
        for (Class<? extends LocalRepoTransactionListener> lc : listenerClasses) {
            LocalRepoTransactionListener listener = LocalRepoTransactionListenerRegistry.createInstance(lc);
            listener.setTransaction(this.transaction);
            listeners.add(listener);
        }
        return listeners;
    }

    private void sortListeners(List<LocalRepoTransactionListener> listeners) {
        Collections.sort(listeners, new Comparator<LocalRepoTransactionListener>(){

            @Override
            public int compare(LocalRepoTransactionListener o1, LocalRepoTransactionListener o2) {
                int result = -1 * Integer.compare(o1.getPriority(), o2.getPriority());
                if (result != 0) {
                    return result;
                }
                return o1.getClass().getName().compareTo(o2.getClass().getName());
            }
        });
    }

    private static <T> T createInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

