/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.repo.local.AbstractLocalRepoTransactionListener;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.ContextWithPersistenceManager;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import co.codewizards.cloudstore.local.persistence.RepoFileDao;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jdo.PersistenceManager;
import javax.jdo.listener.InstanceLifecycleEvent;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.listener.StoreLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.local.DuplicateCryptoRepoFileHandler;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.CryptoRepoFileDao;
import org.subshare.local.persistence.HistoCryptoRepoFile;

public class AssignCryptoRepoFileRepoFileListener
extends AbstractLocalRepoTransactionListener
implements StoreLifecycleListener {
    private static final Logger logger = LoggerFactory.getLogger(AssignCryptoRepoFileRepoFileListener.class);
    private final Map<String, RepoFile> repoFileName2RepoFile = new HashMap<String, RepoFile>();
    private boolean cryptoRepoFilePersisted;
    private boolean histoCryptoRepoFilePersisted;

    public void onBegin() {
        LocalRepoTransaction tx = this.getTransactionOrFail();
        PersistenceManager pm = ((ContextWithPersistenceManager)tx).getPersistenceManager();
        pm.addInstanceLifecycleListener((InstanceLifecycleListener)this, new Class[]{RepoFile.class, CryptoRepoFile.class, HistoCryptoRepoFile.class});
    }

    public void preStore(InstanceLifecycleEvent event) {
    }

    public void postStore(InstanceLifecycleEvent event) {
        Object persistable = AssertUtil.assertNotNull((String)"event.persistentInstance", (Object)event.getPersistentInstance());
        if (persistable instanceof RepoFile) {
            RepoFile repoFile = (RepoFile)persistable;
            this.repoFileName2RepoFile.put((String)AssertUtil.assertNotNull((String)"repoFile.name", (Object)repoFile.getName()), repoFile);
        } else if (persistable instanceof CryptoRepoFile) {
            this.cryptoRepoFilePersisted = true;
        } else if (persistable instanceof HistoCryptoRepoFile) {
            this.histoCryptoRepoFilePersisted = true;
        }
    }

    public void onCommit() {
        if (this.repoFileName2RepoFile.isEmpty() && !this.cryptoRepoFilePersisted && !this.histoCryptoRepoFilePersisted) {
            return;
        }
        LocalRepoTransaction tx = this.getTransactionOrFail();
        CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)tx.getDao(CryptoRepoFileDao.class));
        Collection<CryptoRepoFile> cryptoRepoFiles = cryptoRepoFileDao.getCryptoRepoFilesWithoutRepoFileAndNotDeleted();
        for (CryptoRepoFile cryptoRepoFile : cryptoRepoFiles) {
            RepoFile repoFile;
            if (cryptoRepoFile.getLocalName() != null) {
                repoFile = this.associateRepoFileViaCryptoRepoFileLocalName(cryptoRepoFile);
                continue;
            }
            repoFile = this.repoFileName2RepoFile.get(cryptoRepoFile.getCryptoRepoFileId().toString());
            if (repoFile == null) continue;
            cryptoRepoFile.setRepoFile(repoFile);
            tx.flush();
        }
        this.repoFileName2RepoFile.clear();
        this.cryptoRepoFilePersisted = false;
        this.histoCryptoRepoFilePersisted = false;
    }

    private RepoFile associateRepoFileViaCryptoRepoFileLocalName(CryptoRepoFile cryptoRepoFile) {
        AssertUtil.assertNotNull((String)"cryptoRepoFile", (Object)((Object)cryptoRepoFile));
        RepoFile repoFile = cryptoRepoFile.getRepoFile();
        if (repoFile == null) {
            String localName;
            CryptoRepoFile parentCryptoRepoFile = cryptoRepoFile.getParent();
            LocalRepoTransaction tx = this.getTransactionOrFail();
            if (parentCryptoRepoFile != null && (localName = cryptoRepoFile.getLocalName()) != null) {
                RepoFile parentRepoFile = this.associateRepoFileViaCryptoRepoFileLocalName(parentCryptoRepoFile);
                if (parentRepoFile == null) {
                    return null;
                }
                repoFile = ((RepoFileDao)tx.getDao(RepoFileDao.class)).getChildRepoFile(parentRepoFile, localName);
            }
            if (repoFile != null) {
                DuplicateCryptoRepoFileHandler.createInstance(tx).associateCryptoRepoFileWithRepoFile(repoFile, cryptoRepoFile);
                tx.flush();
            }
        }
        return repoFile;
    }
}

