/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.Dao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.dto.CryptoKeyPart;
import org.subshare.core.dto.CryptoKeyRole;
import org.subshare.local.persistence.CryptoKey;
import org.subshare.local.persistence.CryptoLink;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.UserRepoKeyPublicKey;

public class CryptoLinkDao
extends Dao<CryptoLink, CryptoLinkDao> {
    private static final Logger logger = LoggerFactory.getLogger(CryptoLinkDao.class);

    public CryptoLink getCryptoLinkOrFail(Uid cryptoLinkId) {
        CryptoLink cryptoLink = this.getCryptoLink(cryptoLinkId);
        if (cryptoLink == null) {
            throw new IllegalArgumentException("There is no CryptoLink with this cryptoLinkId: " + cryptoLinkId);
        }
        return cryptoLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CryptoLink getCryptoLink(Uid cryptoLinkId) {
        AssertUtil.assertNotNull((String)"cryptoLinkId", (Object)cryptoLinkId);
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCryptoLink_cryptoLinkId");
        try {
            CryptoLink cryptoLink;
            CryptoLink cryptoLink2 = cryptoLink = (CryptoLink)((Object)query.execute((Object)cryptoLinkId.toString()));
            return cryptoLink2;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CryptoLink> getCryptoLinksChangedAfterExclLastSyncFromRepositoryId(long localRevision, UUID exclLastSyncFromRepositoryId) {
        AssertUtil.assertNotNull((String)"exclLastSyncFromRepositoryId", (Object)exclLastSyncFromRepositoryId);
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCryptoLinksChangedAfter_localRevision_exclLastSyncFromRepositoryId");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection cryptoLinks = (Collection)query.execute((Object)localRevision, (Object)exclLastSyncFromRepositoryId.toString());
            logger.debug("getCryptoLinksChangedAfter: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            cryptoLinks = this.load(cryptoLinks);
            logger.debug("getCryptoLinksChangedAfter: Loading result-set with {} elements took {} ms.", (Object)cryptoLinks.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = cryptoLinks;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CryptoLink> getActiveCryptoLinks(CryptoRepoFile toCryptoRepoFile, CryptoKeyRole toCryptoKeyRole, CryptoKeyPart toCryptoKeyPart) {
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getActiveCryptoLinks_toCryptoRepoFile_toCryptoKeyRole_toCryptoKeyPart");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection cryptoLinks = (Collection)query.execute((Object)toCryptoRepoFile, (Object)toCryptoKeyRole, (Object)toCryptoKeyPart);
            logger.debug("getActiveCryptoLinks: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            cryptoLinks = this.load(cryptoLinks);
            logger.debug("getActiveCryptoLinks: Loading result-set with {} elements took {} ms.", (Object)cryptoLinks.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = cryptoLinks;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    public Collection<CryptoLink> getActiveCryptoLinks(CryptoRepoFile toCryptoRepoFile, CryptoKeyRole toCryptoKeyRole, CryptoKeyPart toCryptoKeyPart, UserRepoKeyPublicKey fromUserRepoKeyPublicKey) {
        ArrayList<CryptoLink> result = new ArrayList<CryptoLink>();
        for (CryptoLink cryptoLink : this.getActiveCryptoLinks(toCryptoRepoFile, toCryptoKeyRole, toCryptoKeyPart)) {
            if (!Util.equal((Object)((Object)fromUserRepoKeyPublicKey), (Object)((Object)cryptoLink.getFromUserRepoKeyPublicKey()))) continue;
            result.add(cryptoLink);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CryptoLink> getCryptoLinks(UserRepoKeyPublicKey fromUserRepoKeyPublicKey) {
        AssertUtil.assertNotNull((String)"fromUserRepoKeyPublicKey", (Object)((Object)fromUserRepoKeyPublicKey));
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCryptoLinks_fromUserRepoKeyPublicKey");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection cryptoLinks = (Collection)query.execute((Object)fromUserRepoKeyPublicKey);
            logger.debug("getCryptoLinks: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            cryptoLinks = this.load(cryptoLinks);
            logger.debug("getCryptoLinks: Loading result-set with {} elements took {} ms.", (Object)cryptoLinks.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = cryptoLinks;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CryptoLink> getCryptoLinksFrom(CryptoKey fromCryptoKey) {
        AssertUtil.assertNotNull((String)"fromCryptoKey", (Object)((Object)fromCryptoKey));
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCryptoLinksFrom_fromCryptoKey");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection cryptoLinks = (Collection)query.execute((Object)fromCryptoKey);
            logger.debug("getCryptoLinks: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            cryptoLinks = this.load(cryptoLinks);
            logger.debug("getCryptoLinks: Loading result-set with {} elements took {} ms.", (Object)cryptoLinks.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = cryptoLinks;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CryptoLink> getCryptoLinksTo(CryptoKey toCryptoKey) {
        AssertUtil.assertNotNull((String)"toCryptoKey", (Object)((Object)toCryptoKey));
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCryptoLinksTo_toCryptoKey");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection cryptoLinks = (Collection)query.execute((Object)toCryptoKey);
            logger.debug("getCryptoLinks: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            cryptoLinks = this.load(cryptoLinks);
            logger.debug("getCryptoLinks: Loading result-set with {} elements took {} ms.", (Object)cryptoLinks.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = cryptoLinks;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CryptoLink> getCryptoLinksSignedBy(Uid signingUserRepoKeyId) {
        AssertUtil.assertNotNull((String)"signingUserRepoKeyId", (Object)signingUserRepoKeyId);
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCryptoLinks_signingUserRepoKeyId");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection cryptoLinks = (Collection)query.execute((Object)signingUserRepoKeyId.toString());
            logger.debug("getCryptoLinksSignedBy: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            cryptoLinks = this.load(cryptoLinks);
            logger.debug("getCryptoLinksSignedBy: Loading result-set with {} elements took {} ms.", (Object)cryptoLinks.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = cryptoLinks;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }
}

