/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.repo.listener;

import co.codewizards.cloudstore.core.util.AssertUtil;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.UUID;
import org.subshare.core.repo.listener.LocalRepoCommitEvent;
import org.subshare.core.repo.listener.LocalRepoCommitEventListener;
import org.subshare.core.repo.listener.LocalRepoCommitEventManager;

public class WeakLocalRepoCommitEventListener
implements LocalRepoCommitEventListener {
    private static ReferenceQueue<LocalRepoCommitEventListener> listenerRefQueue = new ReferenceQueue();
    private static Map<Reference<LocalRepoCommitEventListener>, WeakLocalRepoCommitEventListener> listenerRef2WeakPropertyChangeListener = Collections.synchronizedMap(new IdentityHashMap());
    private final LocalRepoCommitEventManager manager;
    private final UUID localRepositoryId;
    private final WeakReference<LocalRepoCommitEventListener> listenerRef;
    private boolean registered;

    public WeakLocalRepoCommitEventListener(LocalRepoCommitEventManager manager, LocalRepoCommitEventListener listener) {
        this(manager, null, listener);
    }

    public WeakLocalRepoCommitEventListener(LocalRepoCommitEventManager manager, UUID localRepositoryId, LocalRepoCommitEventListener listener) {
        WeakLocalRepoCommitEventListener.expunge();
        this.manager = (LocalRepoCommitEventManager)AssertUtil.assertNotNull((String)"manager", (Object)manager);
        this.localRepositoryId = localRepositoryId;
        this.listenerRef = new WeakReference<LocalRepoCommitEventListener>(listener, listenerRefQueue);
        listenerRef2WeakPropertyChangeListener.put(this.listenerRef, this);
    }

    @Override
    public void postCommit(LocalRepoCommitEvent event) {
        WeakLocalRepoCommitEventListener.expunge();
        LocalRepoCommitEventListener listener = (LocalRepoCommitEventListener)this.listenerRef.get();
        if (listener != null) {
            listener.postCommit(event);
        }
    }

    private static void expunge() {
        Reference<LocalRepoCommitEventListener> ref;
        while ((ref = listenerRefQueue.poll()) != null) {
            WeakLocalRepoCommitEventListener weakLocalRepoCommitEventListener = listenerRef2WeakPropertyChangeListener.remove(ref);
            if (weakLocalRepoCommitEventListener == null) continue;
            weakLocalRepoCommitEventListener.removeLocalRepoCommitEventListener();
        }
    }

    public synchronized WeakLocalRepoCommitEventListener addLocalRepoCommitEventListener() {
        if (!this.registered) {
            this.manager.addLocalRepoCommitEventListener(this.localRepositoryId, this);
            this.registered = true;
        }
        return this;
    }

    public synchronized WeakLocalRepoCommitEventListener removeLocalRepoCommitEventListener() {
        if (this.registered) {
            this.manager.removeLocalRepoCommitEventListener(this.localRepositoryId, this);
            this.registered = false;
        }
        return this;
    }
}

