/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.filetree;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import org.subshare.gui.filetree.FileTreePane;
import org.subshare.gui.filetree.RefreshListener;

public class FileTreeItem<T>
extends TreeItem<FileTreeItem<?>> {
    private T valueObject;
    private boolean childrenLoaded;
    private FileTreePane fileTreePane;
    private final StringProperty sizeProperty = new SimpleStringProperty((Object)this, "size");
    private final StringProperty lastModifiedProperty = new SimpleStringProperty((Object)this, "lastModified");
    private final RefreshListener refreshListener = event -> this.refresh();

    public FileTreeItem(T valueObject) {
        this(valueObject, null);
        this.parentProperty().addListener((observable, oldValue, newValue) -> {
            FileTreePane newFileTreePane;
            if (newValue != null) {
                this.fileTreePane = ((FileTreeItem)((Object)((Object)newValue.getValue()))).getFileTreePane();
            }
            FileTreePane oldFileTreePane = oldValue == null ? null : ((FileTreeItem)((Object)((Object)oldValue.getValue()))).getFileTreePane();
            FileTreePane fileTreePane = newFileTreePane = newValue == null ? null : ((FileTreeItem)((Object)((Object)newValue.getValue()))).getFileTreePane();
            if (oldFileTreePane != newFileTreePane) {
                if (oldFileTreePane != null) {
                    oldFileTreePane.removeRefreshListener(this.refreshListener);
                }
                if (newFileTreePane != null) {
                    newFileTreePane.addRefreshListener(this.refreshListener);
                    this.refresh();
                }
            }
        });
    }

    protected void refresh() {
    }

    public FileTreeItem(T valueObject, Node graphic) {
        this.setValue((Object)this);
        this.valueObject = valueObject;
        this.setGraphic(graphic);
    }

    protected T getValueObject() {
        return this.valueObject;
    }

    public String getName() {
        return this.getValueObject().toString();
    }

    public StringProperty sizeProperty() {
        return this.sizeProperty;
    }

    public StringProperty lastModifiedProperty() {
        return this.lastModifiedProperty;
    }

    protected FileTreePane getFileTreePane() {
        if (this.fileTreePane != null) {
            return this.fileTreePane;
        }
        FileTreeItem parent = (FileTreeItem)this.getParent();
        AssertUtil.assertNotNull((String)"parent", (Object)((Object)parent));
        return parent.getFileTreePane();
    }

    public ObservableList<TreeItem<FileTreeItem<?>>> getChildren() {
        ObservableList children = super.getChildren();
        if (!this.childrenLoaded) {
            this.childrenLoaded = true;
            List<FileTreeItem<?>> c = this.loadChildren();
            if (!children.isEmpty()) {
                children.clear();
            }
            if (c != null) {
                children.addAll(c);
            }
        }
        return children;
    }

    protected boolean isChildrenLoaded() {
        return this.childrenLoaded;
    }

    protected void reloadChildren() {
        if (this.childrenLoaded) {
            this.childrenLoaded = false;
        }
        this.getChildren();
    }

    protected List<FileTreeItem<?>> loadChildren() {
        return null;
    }

    public boolean isLeaf() {
        return false;
    }

    public String toString() {
        return String.format("%s[%s]", ((Object)((Object)this)).getClass().getName(), this.valueObject);
    }

    public FileTreeItem<?> findFirst(File file) {
        AssertUtil.assertNotNull((String)"file", (Object)file);
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("file not absolute!");
        }
        for (TreeItem child : this.getChildren()) {
            FileTreeItem<?> treeItem = ((FileTreeItem)((Object)child.getValue())).findFirst(file);
            if (treeItem == null) continue;
            return treeItem;
        }
        return null;
    }

    public List<FileTreeItem<?>> findAll(File file) {
        AssertUtil.assertNotNull((String)"file", (Object)file);
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("file not absolute!");
        }
        ArrayList result = new ArrayList();
        for (TreeItem child : this.getChildren()) {
            List<FileTreeItem<?>> childFound = ((FileTreeItem)((Object)child.getValue())).findAll(file);
            result.addAll((Collection)AssertUtil.assertNotNull((String)"FileTreeItem.findAll(...)", childFound));
        }
        return result;
    }
}

