/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.imp.fromserver;

import co.codewizards.cloudstore.core.util.AssertUtil;
import javafx.beans.property.Property;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import org.subshare.core.pgp.PgpSignatureType;
import org.subshare.gui.pgp.certify.CertifyPgpKeyData;

public class CertifyPgpKeyPane
extends org.subshare.gui.pgp.certify.CertifyPgpKeyPane {
    private RadioButton skipRadioButton;

    public CertifyPgpKeyPane(CertifyPgpKeyData certifyPgpKeyData) {
        super(certifyPgpKeyData);
        if (CertifyPgpKeyPane.class == this.getClass()) {
            this.init();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initSkipRadioButton();
        this.updateToggleGroup();
    }

    @Override
    protected void updateToggleGroup() {
        if (this.skipRadioButton == null) {
            return;
        }
        super.updateToggleGroup();
    }

    private void initSkipRadioButton() {
        for (Node child : this.getChildren()) {
            Integer rowIndex = CertifyPgpKeyPane.getRowIndex((Node)child);
            AssertUtil.assertNotNull((String)("rowIndex[" + child + "]"), (Object)rowIndex);
            CertifyPgpKeyPane.setRowIndex((Node)child, (Integer)(rowIndex + 1));
        }
        this.skipRadioButton = new RadioButton();
        this.skipRadioButton.setText("Do NOT certify this key, now. Skip signing it!");
        this.skipRadioButton.setToggleGroup(this.toggleGroup);
        CertifyPgpKeyPane.setMargin((Node)this.skipRadioButton, (Insets)new Insets(0.0, 0.0, 8.0, 0.0));
        this.add((Node)this.skipRadioButton, 0, 0, 2, 1);
        this.skipRadioButton.selectedProperty().bindBidirectional((Property)this.certifyPgpKeyData.skipProperty());
    }

    @Override
    protected RadioButton getRadioButtonForCertificationLevel() {
        if (this.certifyPgpKeyData.isSkip()) {
            return this.skipRadioButton;
        }
        return super.getRadioButtonForCertificationLevel();
    }

    @Override
    protected PgpSignatureType getCertificationLevelForRadioButton(RadioButton radioButton) {
        if (this.certifyPgpKeyData.isSkip()) {
            return this.certifyPgpKeyData.getCertificationLevel();
        }
        return super.getCertificationLevelForRadioButton(radioButton);
    }
}

