/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.welcome;

import co.codewizards.cloudstore.core.util.AssertUtil;
import javafx.application.Platform;
import javafx.stage.Window;
import org.subshare.gui.util.PlatformUtil;
import org.subshare.gui.welcome.IdentityWizard;
import org.subshare.gui.welcome.ServerWizard;
import org.subshare.gui.wizard.WizardDialog;
import org.subshare.gui.wizard.WizardState;

public class Welcome {
    private final Window owner;
    private IdentityWizard identityWizard;
    private volatile boolean identityWizardNeeded;
    private ServerWizard serverWizard;
    private volatile boolean serverWizardNeeded;
    private volatile boolean serverWizardCompleted;

    public Welcome(Window owner) {
        this.owner = (Window)AssertUtil.assertNotNull((String)"owner", (Object)owner);
    }

    private void init() {
        PlatformUtil.runAndWait(() -> {
            this.identityWizard = new IdentityWizard();
            this.identityWizardNeeded = this.identityWizard.isNeeded();
            boolean showFirstPage = !this.identityWizardNeeded;
            boolean syncLocker = !this.identityWizardNeeded;
            this.serverWizard = new ServerWizard(showFirstPage, syncLocker);
            this.serverWizardNeeded = this.serverWizard.isNeeded();
            if (this.identityWizardNeeded && this.serverWizardNeeded) {
                this.identityWizard.stateProperty().addListener(observable -> {
                    if (WizardState.FINISHING == this.identityWizard.getState()) {
                        if (this.identityWizard.getIdentityData().importBackupProperty().get()) {
                            this.serverWizardNeeded = false;
                            return;
                        }
                        Platform.runLater(() -> {
                            WizardDialog dialog = new WizardDialog(this.owner, this.serverWizard);
                            dialog.show();
                        });
                    }
                });
            }
        });
    }

    public boolean welcome() {
        this.init();
        boolean[] result = new boolean[1];
        PlatformUtil.runAndWait(() -> {
            if (this.identityWizardNeeded) {
                WizardDialog dialog = new WizardDialog(this.owner, this.identityWizard);
                dialog.showAndWait();
                if (WizardState.FINISHED != this.identityWizard.getState()) {
                    this.serverWizardNeeded = false;
                }
                this.determineServerWizardCompleted();
            } else if (this.serverWizardNeeded) {
                WizardDialog dialog = new WizardDialog(this.owner, this.serverWizard);
                dialog.showAndWait();
            }
        });
        if (this.identityWizardNeeded && this.serverWizardNeeded) {
            while (!this.serverWizardCompleted) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return false;
                }
                this.determineServerWizardCompleted();
            }
        }
        PlatformUtil.runAndWait(() -> {
            result[0] = this.identityWizardNeeded ? WizardState.FINISHED == this.identityWizard.getState() : true;
        });
        return result[0];
    }

    private void determineServerWizardCompleted() {
        if (!this.serverWizardNeeded) {
            return;
        }
        PlatformUtil.runAndWait(() -> {
            this.serverWizardCompleted = WizardState.CANCELLED == this.serverWizard.getState() || WizardState.FINISHED == this.serverWizard.getState();
        });
    }
}

