/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.core;

import co.codewizards.cloudstore.core.config.ConfigImpl;

public class LsConfig {
    public static final String CONFIG_KEY_LOCAL_SERVER_ENABLED = "localServer.enabled";
    public static final boolean DEFAULT_LOCAL_SERVER_ENABLED = true;
    public static final String CONFIG_KEY_LOCAL_SERVER_PROCESS_ENABLED = "localServerProcess.enabled";
    public static final boolean DEFAULT_LOCAL_SERVER_PROCESS_ENABLED = true;
    public static final String CONFIG_KEY_LOCAL_SERVER_PROCESS_START_TIMEOUT = "localServerProcess.startTimeout";
    public static final long DEFAULT_LOCAL_SERVER_PROCESS_START_TIMEOUT = 120000L;

    private LsConfig() {
    }

    public static boolean isLocalServerEnabled() {
        return ConfigImpl.getInstance().getPropertyAsBoolean(CONFIG_KEY_LOCAL_SERVER_ENABLED, true);
    }

    public static boolean isLocalServerProcessEnabled() {
        return ConfigImpl.getInstance().getPropertyAsBoolean(CONFIG_KEY_LOCAL_SERVER_PROCESS_ENABLED, true);
    }

    public static long getLocalServerProcessStartTimeout() {
        long timeoutMs = ConfigImpl.getInstance().getPropertyAsPositiveOrZeroLong(CONFIG_KEY_LOCAL_SERVER_PROCESS_START_TIMEOUT, 120000L);
        return timeoutMs;
    }
}

