/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot.internal;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import org.bouncycastle.openpgp.wot.internal.Util;

public final class Mutex {
    private static final WeakHashMap<String, WeakReference<Mutex>> pgpDir2MutexRef = new WeakHashMap();
    private final String pgpDir;

    private Mutex(String pgpDir) {
        this.pgpDir = Util.assertNotNull("pgpDir", pgpDir);
    }

    public static synchronized Mutex forPubringFile(File pubringFile) {
        Util.assertNotNull("pubringFile", pubringFile);
        return Mutex.forPgpDir(pubringFile.getParentFile());
    }

    public static synchronized Mutex forPgpDir(File dir) {
        Mutex mutex;
        String pgpDir;
        Util.assertNotNull("dir", dir);
        try {
            pgpDir = dir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        WeakReference<Mutex> ref = pgpDir2MutexRef.get(pgpDir);
        Mutex mutex2 = mutex = ref == null ? null : (Mutex)ref.get();
        if (mutex == null) {
            mutex = new Mutex(pgpDir);
            pgpDir2MutexRef.put(pgpDir, new WeakReference<Mutex>(mutex));
        }
        return mutex;
    }

    public String toString() {
        return String.format("Mutex['%s']", this.pgpDir);
    }
}

