/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.repo.metaonly;

import co.codewizards.cloudstore.core.Severity;
import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.dto.Error;
import co.codewizards.cloudstore.core.dto.RepoFileDto;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.progress.LoggerProgressMonitor;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.repo.local.LocalRepoHelper;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.repo.sync.RepoToRepoSync;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.UrlUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.dto.CryptoRepoFileDto;
import org.subshare.core.repo.ServerRepo;
import org.subshare.core.repo.ServerRepoManagerImpl;
import org.subshare.core.repo.ServerRepoRegistry;
import org.subshare.core.repo.ServerRepoRegistryImpl;
import org.subshare.core.repo.local.SsLocalRepoMetaData;
import org.subshare.core.repo.metaonly.MetaOnlyRepoManager;
import org.subshare.core.repo.metaonly.ServerRepoFile;
import org.subshare.core.repo.metaonly.ServerRepoFileImpl;
import org.subshare.core.server.Server;
import org.subshare.core.server.ServerRegistry;
import org.subshare.core.server.ServerRegistryImpl;
import org.subshare.core.sync.RepoSyncState;

public class MetaOnlyRepoManagerImpl
implements MetaOnlyRepoManager {
    private static final Logger logger = LoggerFactory.getLogger(MetaOnlyRepoManagerImpl.class);
    private static final UUID NULL_UUID = new UUID(0L, 0L);
    private final Map<File, UUID> localRoot2LocalRepositoryId = Collections.synchronizedMap(new HashMap());
    private static final int REPO_FILE_DTO_DEPTH = 0;

    protected MetaOnlyRepoManagerImpl() {
    }

    public static MetaOnlyRepoManager getInstance() {
        return Holder.instance;
    }

    @Override
    public List<RepoSyncState> sync() {
        ServerRegistry serverRegistry = ServerRegistryImpl.getInstance();
        ServerRepoRegistry serverRepoRegistry = ServerRepoRegistryImpl.getInstance();
        List<ServerRepo> serverRepos = serverRepoRegistry.getServerRepos();
        ArrayList<RepoSyncState> repoSyncStates = new ArrayList<RepoSyncState>(serverRepos.size());
        for (ServerRepo serverRepo : serverRepos) {
            Server server = serverRegistry.getServer(serverRepo.getServerId());
            if (server == null) {
                logger.warn("sync: serverRegistry does not know server with serverId={}!", (Object)serverRepo.getServerId());
                continue;
            }
            File localRoot = this.getLocalRoot(serverRepo);
            URL remoteRoot = MetaOnlyRepoManagerImpl.getRemoteRoot(server, serverRepo);
            Date syncStarted = new Date();
            try {
                this.sync(server, serverRepo);
                long durationMs = System.currentTimeMillis() - syncStarted.getTime();
                repoSyncStates.add(new RepoSyncState(this.getLocalRepositoryId(localRoot, NULL_UUID), serverRepo, server, localRoot, remoteRoot, Severity.INFO, String.format("Sync took %s ms.", durationMs), null, syncStarted, new Date()));
            }
            catch (Exception x) {
                logger.warn("sync: " + x, (Throwable)x);
                repoSyncStates.add(new RepoSyncState(this.getLocalRepositoryId(localRoot, NULL_UUID), serverRepo, server, localRoot, remoteRoot, Severity.ERROR, x.getMessage(), new Error((Throwable)x), syncStarted, new Date()));
            }
        }
        return repoSyncStates;
    }

    private UUID getLocalRepositoryId(File localRoot, UUID fallbackRepositoryId) {
        AssertUtil.assertNotNull((String)"localRoot", (Object)localRoot);
        UUID result = this.localRoot2LocalRepositoryId.get(localRoot);
        if (result == null) {
            return fallbackRepositoryId;
        }
        return result;
    }

    private void sync(Server server, ServerRepo serverRepo) {
        AssertUtil.assertNotNull((String)"server", (Object)server);
        AssertUtil.assertNotNull((String)"serverRepo", (Object)serverRepo);
        ArrayList<URL> remoteRoots = new ArrayList<URL>();
        LocalRepoManager localRepoManager = this.createLocalRepoManager(serverRepo);
        Object object = null;
        try {
            this.connectLocalRepositoryWithServerRepositoryIfNeeded(localRepoManager, server, serverRepo);
            for (URL url : localRepoManager.getRemoteRepositoryId2RemoteRootMap().values()) {
                remoteRoots.add(url);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (localRepoManager != null) {
                if (object != null) {
                    try {
                        localRepoManager.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    localRepoManager.close();
                }
            }
        }
        File localRoot = this.getLocalRoot(serverRepo);
        for (URL remoteRoot : remoteRoots) {
            RepoToRepoSync repoToRepoSync = RepoToRepoSync.create((File)localRoot, (URL)remoteRoot);
            Throwable throwable = null;
            try {
                repoToRepoSync.sync((ProgressMonitor)new LoggerProgressMonitor(logger));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (repoToRepoSync == null) continue;
                if (throwable != null) {
                    try {
                        repoToRepoSync.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                repoToRepoSync.close();
            }
        }
    }

    private void connectLocalRepositoryWithServerRepositoryIfNeeded(LocalRepoManager localRepoManager, Server server, ServerRepo serverRepo) {
        if (localRepoManager.getRemoteRepositoryId2RemoteRootMap().isEmpty()) {
            URL remoteRoot = MetaOnlyRepoManagerImpl.getRemoteRoot(server, serverRepo);
            ServerRepoManagerImpl.connectLocalRepositoryWithServerRepository(localRepoManager, serverRepo.getRepositoryId(), remoteRoot);
            SsLocalRepoMetaData localRepoMetaData = (SsLocalRepoMetaData)localRepoManager.getLocalRepoMetaData();
            localRepoMetaData.makeMetaOnly();
        }
    }

    private static URL getRemoteRoot(Server server, ServerRepo serverRepo) {
        URL remoteRoot = UrlUtil.appendNonEncodedPath((URL)server.getUrl(), (String)serverRepo.getRepositoryId().toString());
        return remoteRoot;
    }

    @Override
    public File getBaseDir() {
        return OioFileFactory.createFile((File)ConfigDir.getInstance().getFile(), (String[])new String[]{"metaOnlyRepo"});
    }

    private File getLocalRoot(ServerRepo serverRepo) {
        return OioFileFactory.createFile((File)this.getBaseDir(), (String[])new String[]{serverRepo.getServerId().toString(), serverRepo.getRepositoryId().toString()});
    }

    public LocalRepoManager createLocalRepoManager(ServerRepo serverRepo) {
        File localRoot = this.getLocalRoot(serverRepo);
        if (!localRoot.isDirectory()) {
            localRoot.mkdirs();
        }
        if (!localRoot.isDirectory()) {
            throw new IllegalStateException(new IOException("Could not create directory: " + localRoot.getAbsolutePath()));
        }
        LocalRepoManager localRepoManager = LocalRepoHelper.getLocalRootContainingFile((File)localRoot) == null ? LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForNewRepository(localRoot) : LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(localRoot);
        this.localRoot2LocalRepositoryId.put(localRoot, localRepoManager.getRepositoryId());
        return localRepoManager;
    }

    public ServerRepoFile getServerRepoFile(ServerRepo serverRepo, long repoFileId) {
        AssertUtil.assertNotNull((String)"serverRepo", (Object)serverRepo);
        Server server = ServerRegistryImpl.getInstance().getServer(serverRepo.getServerId());
        AssertUtil.assertNotNull((String)("serverRegistry.getServer(" + serverRepo.getServerId() + ")"), (Object)server);
        try (LocalRepoManager localRepoManager = this.createLocalRepoManager(serverRepo);){
            SsLocalRepoMetaData localRepoMetaData = (SsLocalRepoMetaData)localRepoManager.getLocalRepoMetaData();
            RepoFileDto repoFileDto = localRepoMetaData.getRepoFileDto(repoFileId, 0);
            if (repoFileDto == null) {
                ServerRepoFile serverRepoFile = null;
                return serverRepoFile;
            }
            CryptoRepoFileDto cryptoRepoFileDto = localRepoMetaData.getCryptoRepoFileDto(repoFileDto.getId());
            if (cryptoRepoFileDto == null) {
                ServerRepoFile serverRepoFile = null;
                return serverRepoFile;
            }
            UUID localRepositoryId = localRepoManager.getRepositoryId();
            ServerRepoFileImpl serverRepoFileImpl = new ServerRepoFileImpl(server, serverRepo, localRepositoryId, cryptoRepoFileDto, repoFileDto);
            return serverRepoFileImpl;
        }
    }

    @Override
    public ServerRepoFile getRootServerRepoFile(ServerRepo serverRepo) {
        AssertUtil.assertNotNull((String)"serverRepo", (Object)serverRepo);
        Server server = ServerRegistryImpl.getInstance().getServer(serverRepo.getServerId());
        AssertUtil.assertNotNull((String)("serverRegistry.getServer(" + serverRepo.getServerId() + ")"), (Object)server);
        try (LocalRepoManager localRepoManager = this.createLocalRepoManager(serverRepo);){
            SsLocalRepoMetaData localRepoMetaData = (SsLocalRepoMetaData)localRepoManager.getLocalRepoMetaData();
            RepoFileDto repoFileDto = localRepoMetaData.getRepoFileDto("", 0);
            if (repoFileDto == null) {
                ServerRepoFile serverRepoFile = null;
                return serverRepoFile;
            }
            CryptoRepoFileDto cryptoRepoFileDto = localRepoMetaData.getCryptoRepoFileDto(repoFileDto.getId());
            if (cryptoRepoFileDto == null) {
                ServerRepoFile serverRepoFile = null;
                return serverRepoFile;
            }
            UUID localRepositoryId = localRepoManager.getRepositoryId();
            ServerRepoFileImpl serverRepoFileImpl = new ServerRepoFileImpl(server, serverRepo, localRepositoryId, cryptoRepoFileDto, repoFileDto);
            return serverRepoFileImpl;
        }
    }

    protected List<ServerRepoFile> getChildServerRepoFiles(ServerRepoFileImpl serverRepoFile) {
        AssertUtil.assertNotNull((String)"serverRepoFile", (Object)serverRepoFile);
        ServerRepo serverRepo = serverRepoFile.getServerRepo();
        long repoFileId = serverRepoFile.getRepoFileId();
        try (LocalRepoManager localRepoManager = this.createLocalRepoManager(serverRepo);){
            SsLocalRepoMetaData localRepoMetaData = (SsLocalRepoMetaData)localRepoManager.getLocalRepoMetaData();
            List childRepoFileDtos = localRepoMetaData.getChildRepoFileDtos(repoFileId, 0);
            if (childRepoFileDtos == null) {
                List<ServerRepoFile> list = null;
                return list;
            }
            ArrayList<Long> repoFileIds = new ArrayList<Long>(childRepoFileDtos.size());
            for (RepoFileDto repoFileDto : childRepoFileDtos) {
                repoFileIds.add(repoFileDto.getId());
            }
            Map<Long, CryptoRepoFileDto> repoFileId2CryptoRepoFileDto = localRepoMetaData.getCryptoRepoFileDtos(repoFileIds);
            ArrayList<ServerRepoFileImpl> result = new ArrayList<ServerRepoFileImpl>(repoFileId2CryptoRepoFileDto.size());
            for (RepoFileDto repoFileDto : childRepoFileDtos) {
                CryptoRepoFileDto cryptoRepoFileDto = repoFileId2CryptoRepoFileDto.get(repoFileDto.getId());
                if (cryptoRepoFileDto == null) continue;
                result.add(new ServerRepoFileImpl(serverRepoFile, cryptoRepoFileDto, repoFileDto));
            }
            ArrayList<ServerRepoFileImpl> arrayList = result;
            return arrayList;
        }
    }

    private static final class Holder {
        public static final MetaOnlyRepoManager instance = new MetaOnlyRepoManagerImpl();

        private Holder() {
        }
    }
}

