/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.AutoTrackLocalRevision;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.Index;
import javax.jdo.annotations.Indices;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import javax.jdo.annotations.Uniques;
import javax.jdo.listener.StoreCallback;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.state.StateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signature;
import org.subshare.core.sign.WriteProtected;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.HistoCryptoRepoFile;
import org.subshare.local.persistence.SignatureImpl;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@Uniques(value={@Unique(name="UK_CurrentHistoCryptoRepoFile_cryptoRepoFile", members={"cryptoRepoFile"})})
@Indices(value={@Index(name="CurrentHistoCryptoRepoFile_localRevision", members={"localRevision"}), @Index(name="CurrentHistoCryptoRepoFile_cryptoRepoFile", members={"cryptoRepoFile"})})
@Queries(value={@Query(name="getCurrentHistoCryptoRepoFile_cryptoRepoFile", value="SELECT UNIQUE WHERE this.cryptoRepoFile == :cryptoRepoFile"), @Query(name="getCurrentHistoCryptoRepoFilesChangedAfter_localRevision_exclLastSyncFromRepositoryId", value="SELECT WHERE this.localRevision > :localRevision && (this.lastSyncFromRepositoryId == null || this.lastSyncFromRepositoryId != :lastSyncFromRepositoryId)")})
public class CurrentHistoCryptoRepoFile
extends Entity
implements WriteProtected,
AutoTrackLocalRevision,
StoreCallback,
Persistable {
    private static final Logger logger = LoggerFactory.getLogger(CurrentHistoCryptoRepoFile.class);
    @Persistent(nullValue=NullValue.EXCEPTION)
    private CryptoRepoFile cryptoRepoFile;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private HistoCryptoRepoFile histoCryptoRepoFile;
    private long localRevision;
    private String lastSyncFromRepositoryId;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Embedded(nullIndicatorColumn="signatureCreated")
    private SignatureImpl signature;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public CryptoRepoFile getCryptoRepoFile() {
        return CurrentHistoCryptoRepoFile.dnGetcryptoRepoFile(this);
    }

    public void setCryptoRepoFile(CryptoRepoFile cryptoRepoFile) {
        if (Util.equal((Object)((Object)CurrentHistoCryptoRepoFile.dnGetcryptoRepoFile(this)), (Object)((Object)cryptoRepoFile))) {
            return;
        }
        if (CurrentHistoCryptoRepoFile.dnGetcryptoRepoFile(this) != null) {
            throw new IllegalStateException("this.cryptoRepoFile already assigned! Cannot re-assign!");
        }
        CurrentHistoCryptoRepoFile.dnSetcryptoRepoFile(this, cryptoRepoFile);
    }

    public HistoCryptoRepoFile getHistoCryptoRepoFile() {
        return CurrentHistoCryptoRepoFile.dnGethistoCryptoRepoFile(this);
    }

    public void setHistoCryptoRepoFile(HistoCryptoRepoFile histoCryptoRepoFile) {
        CurrentHistoCryptoRepoFile.dnSethistoCryptoRepoFile(this, histoCryptoRepoFile);
    }

    public long getLocalRevision() {
        return CurrentHistoCryptoRepoFile.dnGetlocalRevision(this);
    }

    public void setLocalRevision(long localRevision) {
        if (!Util.equal((long)CurrentHistoCryptoRepoFile.dnGetlocalRevision(this), (long)localRevision)) {
            CurrentHistoCryptoRepoFile.dnSetlocalRevision(this, localRevision);
        }
    }

    public void jdoPreStore() {
        logger.debug("jdoPreStore: {} {}", (Object)CurrentHistoCryptoRepoFile.dnGetcryptoRepoFile(this), (Object)CurrentHistoCryptoRepoFile.dnGethistoCryptoRepoFile(this));
        Uid cryptoRepoFileId = ((CryptoRepoFile)((Object)AssertUtil.assertNotNull((String)"cryptoRepoFile", (Object)((Object)CurrentHistoCryptoRepoFile.dnGetcryptoRepoFile(this))))).getCryptoRepoFileId();
        CryptoRepoFile crf = ((HistoCryptoRepoFile)((Object)AssertUtil.assertNotNull((String)"histoCryptoRepoFile", (Object)((Object)CurrentHistoCryptoRepoFile.dnGethistoCryptoRepoFile(this))))).getCryptoRepoFile();
        AssertUtil.assertNotNull((String)"histoCryptoRepoFile.cryptoRepoFile", (Object)((Object)crf));
        if (!cryptoRepoFileId.equals((Object)crf.getCryptoRepoFileId())) {
            throw new IllegalStateException(String.format("cryptoRepoFile.cryptoRepoFileId != histoCryptoRepoFile.cryptoRepoFile.cryptoRepoFileId :: %s != %s", cryptoRepoFileId, crf.getCryptoRepoFileId()));
        }
    }

    public String getSignedDataType() {
        return "CurrentHistoCryptoRepoFile";
    }

    public int getSignedDataVersion() {
        return 0;
    }

    public InputStream getSignedData(int signedDataVersion) {
        try {
            Uid cryptoRepoFileId = ((CryptoRepoFile)((Object)AssertUtil.assertNotNull((String)"cryptoRepoFile", (Object)((Object)CurrentHistoCryptoRepoFile.dnGetcryptoRepoFile(this))))).getCryptoRepoFileId();
            Uid histoCryptoRepoFileId = ((HistoCryptoRepoFile)((Object)AssertUtil.assertNotNull((String)"histoCryptoRepoFile", (Object)((Object)CurrentHistoCryptoRepoFile.dnGethistoCryptoRepoFile(this))))).getHistoCryptoRepoFileId();
            AssertUtil.assertNotNull((String)"cryptoRepoFileId", (Object)cryptoRepoFileId);
            AssertUtil.assertNotNull((String)"histoCryptoRepoFileId", (Object)histoCryptoRepoFileId);
            byte separatorIndex = 0;
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[3];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource((Uid)cryptoRepoFileId);
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource((Uid)histoCryptoRepoFileId);
            return new MultiInputStream(inputStreamSourceArray);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public Signature getSignature() {
        return CurrentHistoCryptoRepoFile.dnGetsignature(this);
    }

    public void setSignature(Signature signature) {
        if (!Util.equal((Object)CurrentHistoCryptoRepoFile.dnGetsignature(this), (Object)signature)) {
            CurrentHistoCryptoRepoFile.dnSetsignature(this, SignatureImpl.copy(signature));
        }
    }

    public UUID getLastSyncFromRepositoryId() {
        return CurrentHistoCryptoRepoFile.dnGetlastSyncFromRepositoryId(this) == null ? null : UUID.fromString(CurrentHistoCryptoRepoFile.dnGetlastSyncFromRepositoryId(this));
    }

    public void setLastSyncFromRepositoryId(UUID repositoryId) {
        if (!Util.equal((Object)this.getLastSyncFromRepositoryId(), (Object)repositoryId)) {
            CurrentHistoCryptoRepoFile.dnSetlastSyncFromRepositoryId(this, repositoryId == null ? null : repositoryId.toString());
        }
    }

    public Uid getCryptoRepoFileIdControllingPermissions() {
        return (Uid)AssertUtil.assertNotNull((String)"cryptoRepoFileId", (Object)((CryptoRepoFile)((Object)AssertUtil.assertNotNull((String)"cryptoRepoFile", (Object)((Object)CurrentHistoCryptoRepoFile.dnGetcryptoRepoFile(this))))).getCryptoRepoFileId());
    }

    public PermissionType getPermissionTypeRequiredForWrite() {
        return PermissionType.write;
    }

    static {
        dnFieldNames = CurrentHistoCryptoRepoFile.__dnFieldNamesInit();
        dnFieldTypes = CurrentHistoCryptoRepoFile.__dnFieldTypesInit();
        dnFieldFlags = CurrentHistoCryptoRepoFile.__dnFieldFlagsInit();
        dnInheritedFieldCount = CurrentHistoCryptoRepoFile.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = CurrentHistoCryptoRepoFile.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)CurrentHistoCryptoRepoFile.___dn$loadClass("org.subshare.local.persistence.CurrentHistoCryptoRepoFile"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new CurrentHistoCryptoRepoFile());
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        CurrentHistoCryptoRepoFile result = new CurrentHistoCryptoRepoFile();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        CurrentHistoCryptoRepoFile result = new CurrentHistoCryptoRepoFile();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.cryptoRepoFile = (CryptoRepoFile)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 1: {
                this.histoCryptoRepoFile = (HistoCryptoRepoFile)((Object)this.dnStateManager.replacingObjectField((Persistable)this, index));
                break;
            }
            case 2: {
                this.lastSyncFromRepositoryId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 3: {
                this.localRevision = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 4: {
                this.signature = (SignatureImpl)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.cryptoRepoFile);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.histoCryptoRepoFile);
                break;
            }
            case 2: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.lastSyncFromRepositoryId);
                break;
            }
            case 3: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.localRevision);
                break;
            }
            case 4: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.signature);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(CurrentHistoCryptoRepoFile obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.cryptoRepoFile = obj.cryptoRepoFile;
                break;
            }
            case 1: {
                this.histoCryptoRepoFile = obj.histoCryptoRepoFile;
                break;
            }
            case 2: {
                this.lastSyncFromRepositoryId = obj.lastSyncFromRepositoryId;
                break;
            }
            case 3: {
                this.localRevision = obj.localRevision;
                break;
            }
            case 4: {
                this.signature = obj.signature;
                break;
            }
            default: {
                super.dnCopyField((Entity)obj, index);
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof CurrentHistoCryptoRepoFile)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.CurrentHistoCryptoRepoFile");
        }
        CurrentHistoCryptoRepoFile other = (CurrentHistoCryptoRepoFile)((Object)obj);
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"cryptoRepoFile", "histoCryptoRepoFile", "lastSyncFromRepositoryId", "localRevision", "signature"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{CurrentHistoCryptoRepoFile.___dn$loadClass("org.subshare.local.persistence.CryptoRepoFile"), CurrentHistoCryptoRepoFile.___dn$loadClass("org.subshare.local.persistence.HistoCryptoRepoFile"), CurrentHistoCryptoRepoFile.___dn$loadClass("java.lang.String"), Long.TYPE, CurrentHistoCryptoRepoFile.___dn$loadClass("org.subshare.local.persistence.SignatureImpl")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{10, 10, 21, 21, 10};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 5 + Entity.dnGetManagedFieldCount();
    }

    private static Class __dnPersistableSuperclassInit() {
        return CurrentHistoCryptoRepoFile.___dn$loadClass("co.codewizards.cloudstore.local.persistence.Entity");
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        CurrentHistoCryptoRepoFile o = (CurrentHistoCryptoRepoFile)((Object)super.clone());
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static CryptoRepoFile dnGetcryptoRepoFile(CurrentHistoCryptoRepoFile objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return (CryptoRepoFile)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.cryptoRepoFile));
        }
        return objPC.cryptoRepoFile;
    }

    private static void dnSetcryptoRepoFile(CurrentHistoCryptoRepoFile objPC, CryptoRepoFile val) {
        if (objPC.dnStateManager == null) {
            objPC.cryptoRepoFile = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.cryptoRepoFile, (Object)val);
        }
    }

    private static HistoCryptoRepoFile dnGethistoCryptoRepoFile(CurrentHistoCryptoRepoFile objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return (HistoCryptoRepoFile)((Object)objPC.dnStateManager.getObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.histoCryptoRepoFile));
        }
        return objPC.histoCryptoRepoFile;
    }

    private static void dnSethistoCryptoRepoFile(CurrentHistoCryptoRepoFile objPC, HistoCryptoRepoFile val) {
        if (objPC.dnStateManager == null) {
            objPC.histoCryptoRepoFile = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.histoCryptoRepoFile, (Object)val);
        }
    }

    private static String dnGetlastSyncFromRepositoryId(CurrentHistoCryptoRepoFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.lastSyncFromRepositoryId);
        }
        return objPC.lastSyncFromRepositoryId;
    }

    private static void dnSetlastSyncFromRepositoryId(CurrentHistoCryptoRepoFile objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.lastSyncFromRepositoryId, val);
        } else {
            objPC.lastSyncFromRepositoryId = val;
        }
    }

    private static long dnGetlocalRevision(CurrentHistoCryptoRepoFile objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.localRevision);
        }
        return objPC.localRevision;
    }

    private static void dnSetlocalRevision(CurrentHistoCryptoRepoFile objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.localRevision, val);
        } else {
            objPC.localRevision = val;
        }
    }

    private static SignatureImpl dnGetsignature(CurrentHistoCryptoRepoFile objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4 + dnInheritedFieldCount)) {
            return (SignatureImpl)objPC.dnStateManager.getObjectField((Persistable)objPC, 4 + dnInheritedFieldCount, (Object)objPC.signature);
        }
        return objPC.signature;
    }

    private static void dnSetsignature(CurrentHistoCryptoRepoFile objPC, SignatureImpl val) {
        if (objPC.dnStateManager == null) {
            objPC.signature = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 4 + dnInheritedFieldCount, (Object)objPC.signature, (Object)val);
        }
    }
}

