/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.repo.local.AbstractLocalRepoTransactionListener;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.local.ContextWithPersistenceManager;
import co.codewizards.cloudstore.local.persistence.NormalFile;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import java.util.Collection;
import javax.jdo.PersistenceManager;
import javax.jdo.listener.DeleteLifecycleListener;
import javax.jdo.listener.InstanceLifecycleEvent;
import javax.jdo.listener.InstanceLifecycleListener;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.CryptoRepoFileDao;
import org.subshare.local.persistence.TempFileChunk;
import org.subshare.local.persistence.TempFileChunkDao;

public class DeleteRepoFileListener
extends AbstractLocalRepoTransactionListener
implements DeleteLifecycleListener {
    public void onBegin() {
        LocalRepoTransaction tx = this.getTransactionOrFail();
        PersistenceManager pm = ((ContextWithPersistenceManager)tx).getPersistenceManager();
        pm.addInstanceLifecycleListener((InstanceLifecycleListener)this, new Class[]{RepoFile.class});
    }

    public void preDelete(InstanceLifecycleEvent event) {
        CryptoRepoFileDao cryptoRepoFileDao;
        CryptoRepoFile cryptoRepoFile;
        RepoFile repoFile = (RepoFile)event.getPersistentInstance();
        LocalRepoTransaction tx = this.getTransactionOrFail();
        if (repoFile instanceof NormalFile) {
            NormalFile normalFile = (NormalFile)repoFile;
            TempFileChunkDao tempFileChunkDao = (TempFileChunkDao)((Object)tx.getDao(TempFileChunkDao.class));
            Collection<TempFileChunk> tempFileChunks = tempFileChunkDao.getTempFileChunks(normalFile);
            tempFileChunkDao.deletePersistentAll(tempFileChunks);
            tx.flush();
        }
        if ((cryptoRepoFile = (cryptoRepoFileDao = (CryptoRepoFileDao)((Object)tx.getDao(CryptoRepoFileDao.class))).getCryptoRepoFile(repoFile)) != null) {
            cryptoRepoFile.setRepoFile(null);
        }
    }

    public void postDelete(InstanceLifecycleEvent event) {
    }
}

