/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.local.persistence.UserIdentity;
import org.subshare.local.persistence.UserIdentityDao;
import org.subshare.local.persistence.UserIdentityLink;
import org.subshare.local.persistence.UserRepoKeyPublicKey;

public class UserIdentityLinkDao
extends Dao<UserIdentityLink, UserIdentityLinkDao> {
    private static final Logger logger = LoggerFactory.getLogger(UserIdentityLinkDao.class);

    public UserIdentityLink getUserIdentityLinkOrFail(Uid userIdentityLinkId) {
        UserIdentityLink userIdentityLink = this.getUserIdentityLink(userIdentityLinkId);
        if (userIdentityLink == null) {
            throw new IllegalArgumentException("There is no UserIdentityLink with this userIdentityLinkId: " + userIdentityLinkId);
        }
        return userIdentityLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserIdentityLink getUserIdentityLink(Uid userIdentityLinkId) {
        AssertUtil.assertNotNull((String)"userIdentityLinkId", (Object)userIdentityLinkId);
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getUserIdentityLink_userIdentityLinkId");
        try {
            UserIdentityLink userIdentityLink;
            UserIdentityLink userIdentityLink2 = userIdentityLink = (UserIdentityLink)((Object)query.execute((Object)userIdentityLinkId.toString()));
            return userIdentityLink2;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<UserIdentityLink> getUserIdentityLinksOf(UserRepoKeyPublicKey ofUserRepoKeyPublicKey) {
        AssertUtil.assertNotNull((String)"ofUserRepoKeyPublicKey", (Object)((Object)ofUserRepoKeyPublicKey));
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getUserIdentityLinks_ofUserRepoKeyPublicKey");
        try {
            HashMap<String, UserRepoKeyPublicKey> params = new HashMap<String, UserRepoKeyPublicKey>(1);
            params.put("ofUserRepoKeyPublicKey", ofUserRepoKeyPublicKey);
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.executeWithMap(params);
            logger.debug("getUserIdentityLinksOf: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getUserIdentityLinksOf: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<UserIdentityLink> getUserIdentityLinksOf(UserIdentity userIdentity) {
        AssertUtil.assertNotNull((String)"userIdentity", (Object)((Object)userIdentity));
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getUserIdentityLinks_userIdentity");
        try {
            HashMap<String, UserIdentity> params = new HashMap<String, UserIdentity>(1);
            params.put("userIdentity", userIdentity);
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.executeWithMap(params);
            logger.debug("getUserIdentityLinksOf: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getUserIdentityLinksOf: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<UserIdentityLink> getUserIdentityLinksFor(UserRepoKeyPublicKey forUserRepoKeyPublicKey) {
        AssertUtil.assertNotNull((String)"forUserRepoKeyPublicKey", (Object)((Object)forUserRepoKeyPublicKey));
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getUserIdentityLinks_forUserRepoKeyPublicKey");
        try {
            HashMap<String, UserRepoKeyPublicKey> params = new HashMap<String, UserRepoKeyPublicKey>(1);
            params.put("forUserRepoKeyPublicKey", forUserRepoKeyPublicKey);
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.executeWithMap(params);
            logger.debug("getUserIdentityLinksFor: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getUserIdentityLinksFor: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<UserIdentityLink> getUserIdentityLinks(UserRepoKeyPublicKey ofUserRepoKeyPublicKey, UserRepoKeyPublicKey forUserRepoKeyPublicKey) {
        AssertUtil.assertNotNull((String)"ofUserRepoKeyPublicKey", (Object)((Object)ofUserRepoKeyPublicKey));
        AssertUtil.assertNotNull((String)"forUserRepoKeyPublicKey", (Object)((Object)forUserRepoKeyPublicKey));
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getUserIdentityLinks_ofUserRepoKeyPublicKey_forUserRepoKeyPublicKey");
        try {
            HashMap<String, UserRepoKeyPublicKey> params = new HashMap<String, UserRepoKeyPublicKey>(2);
            params.put("ofUserRepoKeyPublicKey", ofUserRepoKeyPublicKey);
            params.put("forUserRepoKeyPublicKey", forUserRepoKeyPublicKey);
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.executeWithMap(params);
            logger.debug("getUserIdentities: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getUserIdentities: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<UserIdentityLink> getUserIdentityLinksChangedAfter(long localRevision) {
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getUserIdentityLinksChangedAfter_localRevision");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.execute((Object)localRevision);
            logger.debug("getUserIdentityLinksChangedAfter: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getUserIdentityLinksChangedAfter: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    public void deletePersistent(UserIdentityLink entity) {
        UserIdentity userIdentity = entity.getUserIdentity();
        super.deletePersistent((Entity)entity);
        this.pm().flush();
        this.deleteIfOrphan(userIdentity);
    }

    public void deletePersistentAll(Collection<? extends UserIdentityLink> entities) {
        HashSet<UserIdentity> userIdentities = new HashSet<UserIdentity>();
        for (UserIdentityLink userIdentityLink : entities) {
            userIdentities.add(userIdentityLink.getUserIdentity());
        }
        super.deletePersistentAll(entities);
        this.pm().flush();
        this.deleteIfOrphan(userIdentities);
    }

    private void deleteIfOrphan(Set<UserIdentity> userIdentities) {
        for (UserIdentity userIdentity : userIdentities) {
            this.deleteIfOrphan(userIdentity);
        }
    }

    private void deleteIfOrphan(UserIdentity userIdentity) {
        Collection<UserIdentityLink> userIdentityLinks = this.getUserIdentityLinksOf(userIdentity);
        if (userIdentityLinks.isEmpty()) {
            ((UserIdentityDao)this.getDao(UserIdentityDao.class)).deletePersistent(userIdentity);
        }
    }
}

