/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.io;

import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.io.LockFile;
import co.codewizards.cloudstore.core.io.LockFileImpl;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LockFileProxy
implements LockFile {
    private static final Logger logger = LoggerFactory.getLogger(LockFileProxy.class);
    private final LockFileImpl lockFileImpl;
    private final AtomicBoolean released = new AtomicBoolean(false);

    public LockFileProxy(LockFileImpl lockFileImpl) {
        this.lockFileImpl = AssertUtil.assertNotNull("lockFileImpl", lockFileImpl);
    }

    @Override
    public File getFile() {
        return this.lockFileImpl.getFile();
    }

    @Override
    public void release() {
        if (!this.released.compareAndSet(false, true)) {
            IllegalStateException x = new IllegalStateException("Multiple invocations of release() should be avoided!");
            logger.warn(x.toString(), (Throwable)x);
            return;
        }
        this.lockFileImpl.release();
    }

    @Override
    public final void close() {
        this.release();
    }

    public LockFileImpl getLockFileImpl() {
        return this.lockFileImpl;
    }

    @Override
    public Lock getLock() {
        return this.lockFileImpl.getLock();
    }

    @Override
    public IInputStream createInputStream() throws IOException {
        return this.lockFileImpl.createInputStream();
    }

    @Override
    public IOutputStream createOutputStream() throws IOException {
        return this.lockFileImpl.createOutputStream();
    }
}

