/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.rest.server.service;

import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.subshare.core.dto.LongDto;
import org.subshare.core.pgp.PgpKeyIdList;
import org.subshare.core.pgp.transport.PgpTransport;
import org.subshare.core.pgp.transport.PgpTransportFactory;
import org.subshare.core.pgp.transport.PgpTransportFactoryRegistryImpl;
import org.subshare.core.pgp.transport.local.LocalPgpTransportFactory;

@Path(value="_PgpPublicKey")
public class PgpPublicKeyService {
    @GET
    @Path(value="_localRevision")
    public LongDto getLocalRevision() {
        try (PgpTransport localPgpTransport = this.createLocalPgpTransport();){
            LongDto longDto = new LongDto(localPgpTransport.getLocalRevision());
            return longDto;
        }
    }

    @GET
    @Path(value="_search/{queryString}")
    @Produces(value={"application/octet-stream"})
    public Response searchPgpPublicKeys(final @PathParam(value="queryString") String queryString) {
        AssertUtil.assertNotNull((String)"queryString", (Object)queryString);
        StreamingOutput result = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                try (PgpTransport localPgpTransport = PgpPublicKeyService.this.createLocalPgpTransport();){
                    localPgpTransport.exportPublicKeysMatchingQuery(queryString, StreamUtil.castStream((OutputStream)output));
                    output.flush();
                }
            }
        };
        return Response.ok((Object)result).build();
    }

    @GET
    @Produces(value={"application/octet-stream"})
    public Response getPgpPublicKeys(@QueryParam(value="changedAfterLocalRevision") @DefaultValue(value="-1") long changedAfterLocalRevision) {
        return this.getPgpPublicKeys(new PgpKeyIdList(), changedAfterLocalRevision);
    }

    @GET
    @Path(value="{pgpKeyIdList}")
    @Produces(value={"application/octet-stream"})
    public Response getPgpPublicKeys(final @PathParam(value="pgpKeyIdList") PgpKeyIdList pgpKeyIdList, final @QueryParam(value="changedAfterLocalRevision") @DefaultValue(value="-1") long changedAfterLocalRevision) {
        AssertUtil.assertNotNull((String)"pgpKeyIdList", (Object)pgpKeyIdList);
        StreamingOutput result = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                try (PgpTransport localPgpTransport = PgpPublicKeyService.this.createLocalPgpTransport();){
                    localPgpTransport.exportPublicKeys(new HashSet(pgpKeyIdList), changedAfterLocalRevision, StreamUtil.castStream((OutputStream)output));
                    output.flush();
                }
            }
        };
        return Response.ok((Object)result).build();
    }

    @PUT
    @Consumes(value={"application/octet-stream"})
    public void putPgpPublicKeys(InputStream in) {
        AssertUtil.assertNotNull((String)"in", (Object)in);
        try (PgpTransport localPgpTransport = this.createLocalPgpTransport();){
            localPgpTransport.importKeys(StreamUtil.castStream((InputStream)in));
        }
    }

    private PgpTransport createLocalPgpTransport() {
        PgpTransportFactory localPgpTransportFactory = PgpTransportFactoryRegistryImpl.getInstance().getPgpTransportFactoryOrFail(LocalPgpTransportFactory.class);
        return localPgpTransportFactory.createPgpTransport(LocalPgpTransportFactory.LOCAL_URL);
    }
}

