/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server.ldap;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.rest.server.auth.Auth;
import co.codewizards.cloudstore.rest.server.auth.NotAuthorizedException;
import co.codewizards.cloudstore.rest.server.ldap.LdapClient;
import co.codewizards.cloudstore.rest.server.ldap.LdapConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class QueryLdapClient
implements LdapClient {
    private static final String TEMPLATE_VARIABLE = "login";
    private final String query;
    private final String queryDn;
    private final String url;
    private final String adminDn;
    private final char[] adminPassword;

    public QueryLdapClient(String query, String queryDn, String url, String bindDn, char[] password) {
        this.query = (String)AssertUtil.assertNotNull((String)"query", (Object)query);
        this.queryDn = (String)AssertUtil.assertNotNull((String)"queryDn", (Object)queryDn);
        this.url = (String)AssertUtil.assertNotNull((String)"url", (Object)url);
        this.adminDn = (String)AssertUtil.assertNotNull((String)"bindDn", (Object)bindDn);
        this.adminPassword = (char[])AssertUtil.assertNotNull((String)"password", (Object)password);
    }

    @Override
    public String authenticate(Auth auth) {
        try {
            LdapConfig config = new LdapConfig(this.url, this.adminDn, this.adminPassword);
            InitialDirContext context = new InitialDirContext(config);
            List<String> usersDns = this.findAllUsersThatMatchQuery(context, auth);
            for (String userDn : usersDns) {
                if (!this.tryAuthenticate(context, userDn, auth.getPassword())) continue;
                return auth.getUserName();
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        throw new NotAuthorizedException();
    }

    private List<String> findAllUsersThatMatchQuery(DirContext context, Auth auth) throws NamingException {
        NamingEnumeration<SearchResult> results = this.findUsersWithQuery(context, auth.getUserName());
        ArrayList<String> usersDns = new ArrayList<String>();
        while (results.hasMore()) {
            usersDns.add(results.next().getNameInNamespace());
        }
        return usersDns;
    }

    private NamingEnumeration<SearchResult> findUsersWithQuery(DirContext context, String userName) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String replacedQuery = this.convertTemplate(this.query, userName);
        return context.search(this.queryDn, replacedQuery, searchControls);
    }

    private boolean tryAuthenticate(DirContext context, String userName, char[] password) throws NamingException {
        try {
            context.addToEnvironment("java.naming.security.principal", userName);
            context.addToEnvironment("java.naming.security.credentials", password);
            context.lookup(userName);
            return true;
        }
        catch (AuthenticationException e) {
            return false;
        }
    }

    private String convertTemplate(String template, String username) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(TEMPLATE_VARIABLE, username);
        return IOUtil.replaceTemplateVariables((String)template, map);
    }
}

