/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.core.invoke;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.ls.core.invoke.Invoker;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRef;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteObjectProxyInvocationHandler
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(RemoteObjectProxyInvocationHandler.class);
    protected final Uid refId = new Uid();
    protected final Invoker invoker;
    protected final ObjectRef objectRef;
    protected final boolean equalsOverridden;

    public RemoteObjectProxyInvocationHandler(Invoker invoker, ObjectRef objectRef) {
        this.invoker = (Invoker)AssertUtil.assertNotNull((String)"invoker", (Object)invoker);
        this.objectRef = (ObjectRef)AssertUtil.assertNotNull((String)"objectRef", (Object)objectRef);
        if (logger.isDebugEnabled()) {
            logger.debug("[{}]<init>: {} refId={}", new Object[]{this.getThisId(), objectRef, this.refId});
        }
        this.equalsOverridden = invoker.getClassInfoMap().getClassInfoOrFail(objectRef.getClassId()).isEqualsOverridden();
        invoker.incRefCount(objectRef, this.refId);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("getObjectRef".equals(method.getName()) && method.getParameterTypes().length == 0) {
            return this.objectRef;
        }
        if (!this.equalsOverridden) {
            if ("equals".equals(method.getName()) && method.getParameterTypes().length == 1) {
                return this._equals(proxy, method, args[0]);
            }
            if ("hashCode".equals(method.getName()) && method.getParameterTypes().length == 0) {
                return this._hashCode(proxy, method);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[{}]invoke: method='{}'", (Object)this.getThisId(), (Object)method);
        }
        return this.invoker.invoke((Object)this.objectRef, method.getName(), method.getParameterTypes(), args);
    }

    protected void finalize() throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("[{}]finalize: {}", (Object)this.getThisId(), (Object)this.objectRef);
        }
        this.invoker.decRefCount(this.objectRef, this.refId);
        super.finalize();
    }

    private Object _equals(Object proxy, Method method, Object other) {
        if (proxy == other) {
            return true;
        }
        if (null == other) {
            return false;
        }
        if (proxy.getClass() != other.getClass()) {
            return false;
        }
        RemoteObjectProxyInvocationHandler otherHandler = (RemoteObjectProxyInvocationHandler)Proxy.getInvocationHandler(other);
        return this.objectRef.equals(otherHandler.objectRef);
    }

    private int _hashCode(Object proxy, Method method) {
        return 31 * this.objectRef.hashCode();
    }

    protected String getThisId() {
        return Integer.toHexString(System.identityHashCode(this));
    }
}

