/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.file;

import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.IOException;
import java.io.InputStream;
import org.subshare.core.file.DataFile;

public class EncryptedDataFile
extends DataFile {
    public static final String CONTENT_TYPE_VALUE = "application/vnd.subshare.encrypted";
    public static final String ENTRY_NAME_DEFAULT_DATA = "default.gpg";
    public static final String ENTRY_NAME_SIGNING_KEY_DATA = "signingKey.gpg";

    public EncryptedDataFile(byte[] in) throws IOException {
        this((InputStream)new ByteArrayInputStream((byte[])AssertUtil.assertNotNull((String)"in", (Object)in)));
    }

    public EncryptedDataFile(InputStream in) throws IOException {
        super(in);
    }

    public EncryptedDataFile() {
    }

    public void putSigningKeyData(byte[] data) {
        this.putData(ENTRY_NAME_SIGNING_KEY_DATA, data);
    }

    public byte[] getSigningKeyData() {
        return this.getData(ENTRY_NAME_SIGNING_KEY_DATA);
    }

    public void putDefaultData(byte[] data) {
        this.putData(ENTRY_NAME_DEFAULT_DATA, data);
    }

    public byte[] getDefaultData() {
        return this.getData(ENTRY_NAME_DEFAULT_DATA);
    }

    @Override
    protected String getContentTypeValue() {
        return CONTENT_TYPE_VALUE;
    }
}

