/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp;

import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.HashSet;
import java.util.Set;
import org.subshare.core.pgp.CompressionAlgorithm;
import org.subshare.core.pgp.HashAlgorithm;
import org.subshare.core.pgp.PgpAuthenticationCallback;
import org.subshare.core.pgp.PgpEncoder;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpRegistry;
import org.subshare.core.pgp.SymmetricEncryptionAlgorithm;

public abstract class AbstractPgpEncoder
implements PgpEncoder {
    private IInputStream inputStream;
    private IOutputStream outputStream;
    private IOutputStream signOutputStream;
    private final Set<PgpKey> encryptPgpKeys = new HashSet<PgpKey>(0);
    private PgpKey signPgpKey;
    private String fileName = "";
    private boolean withIntegrityCheck;
    private SymmetricEncryptionAlgorithm symmetricEncryptionAlgorithm = SymmetricEncryptionAlgorithm.TWOFISH;
    private CompressionAlgorithm compressionAlgorithm = CompressionAlgorithm.ZIP;
    private HashAlgorithm hashAlgorithm = HashAlgorithm.SHA256;

    @Override
    public IInputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void setInputStream(IInputStream inputStream) {
        this.inputStream = inputStream;
    }

    protected IInputStream getInputStreamOrFail() {
        IInputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            throw new IllegalStateException("inputStream == null");
        }
        return inputStream;
    }

    @Override
    public IOutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void setOutputStream(IOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    protected IOutputStream getOutputStreamOrFail() {
        IOutputStream outputStream = this.getOutputStream();
        if (outputStream == null) {
            throw new IllegalStateException("outputStream == null");
        }
        return outputStream;
    }

    @Override
    public IOutputStream getSignOutputStream() {
        return this.signOutputStream;
    }

    @Override
    public void setSignOutputStream(IOutputStream signOutputStream) {
        this.signOutputStream = signOutputStream;
    }

    @Override
    public boolean isWithIntegrityCheck() {
        return this.withIntegrityCheck;
    }

    @Override
    public void setWithIntegrityCheck(boolean withIntegrityCheck) {
        this.withIntegrityCheck = withIntegrityCheck;
    }

    @Override
    public SymmetricEncryptionAlgorithm getSymmetricEncryptionAlgorithm() {
        return this.symmetricEncryptionAlgorithm;
    }

    @Override
    public void setSymmetricEncryptionAlgorithm(SymmetricEncryptionAlgorithm symmetricEncryptionAlgorithm) {
        this.symmetricEncryptionAlgorithm = (SymmetricEncryptionAlgorithm)((Object)AssertUtil.assertNotNull((String)"symmetricEncryptionAlgorithm", (Object)((Object)symmetricEncryptionAlgorithm)));
    }

    @Override
    public CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    @Override
    public void setCompressionAlgorithm(CompressionAlgorithm compressionAlgorithm) {
        this.compressionAlgorithm = (CompressionAlgorithm)((Object)AssertUtil.assertNotNull((String)"compressionAlgorithm", (Object)((Object)compressionAlgorithm)));
    }

    @Override
    public HashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    @Override
    public void setHashAlgorithm(HashAlgorithm hashAlgorithm) {
        this.hashAlgorithm = (HashAlgorithm)((Object)AssertUtil.assertNotNull((String)"hashAlgorithm", (Object)((Object)hashAlgorithm)));
    }

    @Override
    public Set<PgpKey> getEncryptPgpKeys() {
        return this.encryptPgpKeys;
    }

    @Override
    public PgpKey getSignPgpKey() {
        return this.signPgpKey;
    }

    @Override
    public void setSignPgpKey(PgpKey signPgpKey) {
        if (signPgpKey != null && !signPgpKey.isSecretKeyAvailable()) {
            throw new IllegalArgumentException("signPgpKey.privateKeyAvailable == false :: A private key is required for signing!");
        }
        this.signPgpKey = signPgpKey;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = (String)AssertUtil.assertNotNull((String)"fileName", (Object)fileName);
    }

    protected PgpAuthenticationCallback getPgpAuthenticationCallback() {
        PgpAuthenticationCallback pgpAuthenticationCallback = PgpRegistry.getInstance().getPgpAuthenticationCallback();
        return pgpAuthenticationCallback;
    }

    protected PgpAuthenticationCallback getPgpAuthenticationCallbackOrFail() {
        PgpAuthenticationCallback pgpAuthenticationCallback = this.getPgpAuthenticationCallback();
        if (pgpAuthenticationCallback == null) {
            throw new IllegalStateException("There is no PgpAuthenticationCallback assigned!");
        }
        return pgpAuthenticationCallback;
    }
}

