/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp.gnupg;

import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.subshare.core.pgp.AbstractPgpEncoder;
import org.subshare.core.pgp.PgpAuthenticationCallback;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.gnupg.BcPgpKey;
import org.subshare.core.pgp.gnupg.BcWithLocalGnuPgPgp;

public class BcPgpEncoder
extends AbstractPgpEncoder {
    private final BcWithLocalGnuPgPgp pgp;

    public BcPgpEncoder(BcWithLocalGnuPgPgp pgp) {
        this.pgp = (BcWithLocalGnuPgPgp)AssertUtil.assertNotNull((String)"pgp", (Object)pgp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode() throws IOException {
        int BUFFER_SIZE = 32768;
        InputStream in = StreamUtil.castStream((IInputStream)this.getInputStreamOrFail());
        OutputStream signOut = StreamUtil.castStream((IOutputStream)this.getSignOutputStream());
        OutputStream out = StreamUtil.castStream((IOutputStream)this.getOutputStreamOrFail());
        try (PGPEncryptedDataGenerator edGenerator = this.getEncryptPgpKeys().isEmpty() ? null : this.createEncryptedDataGenerator();){
            for (PgpKey encryptPgpKey : this.getEncryptPgpKeys()) {
                if (signOut != null) {
                    throw new IllegalStateException("Signature cannot be detached when encryption is used!");
                }
                PgpKey actualEncryptPgpKey = encryptPgpKey.getPgpKeyForEncryptionOrFail();
                BcPgpKey bcPgpKey = this.pgp.getBcPgpKey(actualEncryptPgpKey);
                edGenerator.addMethod((PGPKeyEncryptionMethodGenerator)new BcPublicKeyKeyEncryptionMethodGenerator(bcPgpKey.getPublicKey()));
            }
            try (OutputStream encryptedOut = edGenerator == null ? null : edGenerator.open(out, new byte[32768]);){
                if (encryptedOut != null) {
                    out = encryptedOut;
                }
                boolean unmodifiedOutput = encryptedOut == null && signOut != null;
                try (PGPCompressedDataGenerator cdGenerator = unmodifiedOutput ? null : this.createCompressedDataGenerator();
                     OutputStream compressedOut = cdGenerator == null ? null : cdGenerator.open(out);){
                    PGPSignatureGenerator signatureGenerator;
                    if (compressedOut != null) {
                        out = compressedOut;
                    }
                    PGPSignatureGenerator pGPSignatureGenerator = signatureGenerator = this.getSignPgpKey() == null ? null : this.createSignatureGenerator();
                    if (signatureGenerator != null) {
                        signatureGenerator.generateOnePassVersion(false).encode(signOut != null ? signOut : out);
                    }
                    try (PGPLiteralDataGenerator ldGenerator = unmodifiedOutput ? null : new PGPLiteralDataGenerator();
                         OutputStream lOut = ldGenerator == null ? null : ldGenerator.open(out, 'b', this.getFileName(), new Date(), new byte[32768]);){
                        int bytesRead;
                        byte[] buf = new byte[32768];
                        while ((bytesRead = in.read(buf, 0, buf.length)) >= 0) {
                            if (bytesRead <= 0) continue;
                            if (lOut != null) {
                                lOut.write(buf, 0, bytesRead);
                            } else {
                                out.write(buf, 0, bytesRead);
                            }
                            if (signatureGenerator == null) continue;
                            signatureGenerator.update(buf, 0, bytesRead);
                        }
                    }
                    if (signatureGenerator != null) {
                        signatureGenerator.generate().encode(signOut != null ? signOut : out);
                    }
                }
            }
        }
        catch (PGPException x) {
            throw new IOException(x);
        }
    }

    private PGPSignatureGenerator createSignatureGenerator() throws PGPException {
        PgpKey signPgpKey = (PgpKey)AssertUtil.assertNotNull((String)"signPgpKey", (Object)this.getSignPgpKey());
        PgpKey actualSignPgpKey = signPgpKey.getPgpKeyForSignatureOrFail();
        PGPSecretKey signSecretKey = this.getPgpSecretKeyOrFail(actualSignPgpKey);
        char[] signPassphrase = this.getPassphrase(actualSignPgpKey);
        PGPPrivateKey pgpPrivKey = signSecretKey.extractPrivateKey(new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(signPassphrase));
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new BcPGPContentSignerBuilder(signSecretKey.getPublicKey().getAlgorithm(), this.getHashAlgorithm().getHashAlgorithmTag()));
        signatureGenerator.init(0, pgpPrivKey);
        Iterator it = signSecretKey.getPublicKey().getUserIDs();
        if (it.hasNext()) {
            PGPSignatureSubpacketGenerator spGen = new PGPSignatureSubpacketGenerator();
            spGen.setSignerUserID(false, (String)it.next());
            signatureGenerator.setHashedSubpackets(spGen.generate());
        }
        return signatureGenerator;
    }

    private PGPEncryptedDataGenerator createEncryptedDataGenerator() {
        return new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)new BcPGPDataEncryptorBuilder(this.getSymmetricEncryptionAlgorithm().getSymmetricKeyAlgorithmTag()).setWithIntegrityPacket(this.isWithIntegrityCheck()).setSecureRandom(new SecureRandom()));
    }

    private PGPCompressedDataGenerator createCompressedDataGenerator() {
        return new PGPCompressedDataGenerator(this.getCompressionAlgorithm().getCompressionAlgorithmTag());
    }

    private char[] getPassphrase(PgpKey pgpKey) {
        PGPSecretKey secretKey = this.getPgpSecretKeyOrFail(pgpKey);
        if (secretKey.getKeyEncryptionAlgorithm() != 0) {
            PgpAuthenticationCallback callback = this.getPgpAuthenticationCallbackOrFail();
            return callback.getPassphrase(pgpKey);
        }
        return null;
    }

    private PGPSecretKey getPgpSecretKeyOrFail(PgpKey pgpKey) {
        AssertUtil.assertNotNull((String)"pgpKey", (Object)pgpKey);
        PGPSecretKey secretKey = this.pgp.getBcPgpKeyOrFail(pgpKey).getSecretKey();
        if (secretKey == null) {
            throw new IllegalStateException(String.format("The PGP key %s does not have a secret key attached (it is a public key only)!", pgpKey.getPgpKeyId()));
        }
        return secretKey;
    }
}

