/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.sign;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.auth.SignatureException;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Signer;
import org.subshare.core.sign.SignerTransformation;
import org.subshare.core.user.UserRepoKey;
import org.subshare.core.user.UserRepoKeyPublicKeyLookup;
import org.subshare.crypto.CryptoRegistry;

public class VerifierInputStream
extends FilterInputStream {
    public static final int MAGIC_BYTE = 204;
    public static final int HEADER_LENGTH = 28;
    protected static int MAX_FOOTER_LENGTH = 4096;
    private boolean closed;
    private boolean closeUnderlyingStream = true;
    private final Header header;
    private Footer footer;
    private long offset;
    private final Signer signer;
    private final UserRepoKey.PublicKey signingUserRepoKeyPublicKey;
    private static final int MAX_SKIP_BUFFER_SIZE = 2048;

    public VerifierInputStream(InputStream in, UserRepoKeyPublicKeyLookup lookup) throws IOException {
        super(new BufferedInputStream(in));
        AssertUtil.assertNotNull((String)"lookup", (Object)lookup);
        this.header = this.readHeader();
        try {
            this.signer = CryptoRegistry.getInstance().createSigner(this.header.signerTransformation.getTransformation());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.signingUserRepoKeyPublicKey = lookup.getUserRepoKeyPublicKey(this.header.signingUserRepoKeyId);
        if (this.signingUserRepoKeyPublicKey == null) {
            throw new SignatureException(String.format("No public key found for signingUserRepoKeyId=%s!", this.header.signingUserRepoKeyId));
        }
        this.signer.init(false, (CipherParameters)this.signingUserRepoKeyPublicKey.getPublicKey());
        byte[] signatureCreatedBytes = IOUtil.longToBytes((long)this.header.signatureCreated.getTime());
        this.signer.update(signatureCreatedBytes, 0, signatureCreatedBytes.length);
    }

    private Header readHeader() throws IOException {
        int magicByte = this.in.read();
        if (204 != magicByte) {
            throw new IOException(String.format("First byte from input does not match expected magic number! expected=%s found=%s", 204, magicByte));
        }
        int version = this.in.read();
        if (version != 1) {
            throw new IOException("version != 1 :: version == " + version);
        }
        int signerTransformationNumeric = IOUtil.readOrFail((InputStream)this.in) + (IOUtil.readOrFail((InputStream)this.in) << 8);
        if (signerTransformationNumeric > SignerTransformation.values().length) {
            throw new IOException(String.format("signerTransformationNumeric > SignerTransformation.values().length :: %s > %s", signerTransformationNumeric, SignerTransformation.values().length));
        }
        SignerTransformation signerTransformation = SignerTransformation.values()[signerTransformationNumeric];
        byte[] signingUserRepoKeyIdBytes = new byte[16];
        IOUtil.readOrFail((InputStream)this.in, (byte[])signingUserRepoKeyIdBytes, (int)0, (int)signingUserRepoKeyIdBytes.length);
        Uid signingUserRepoKeyId = new Uid(signingUserRepoKeyIdBytes);
        byte[] signatureCreatedBytes = new byte[8];
        IOUtil.readOrFail((InputStream)this.in, (byte[])signatureCreatedBytes, (int)0, (int)signatureCreatedBytes.length);
        Date signatureCreated = new Date(IOUtil.bytesToLong((byte[])signatureCreatedBytes));
        return new Header(version, signerTransformation, signingUserRepoKeyId, signatureCreated);
    }

    public UserRepoKey.PublicKey getSigningUserRepoKeyPublicKey() {
        return this.signingUserRepoKeyPublicKey;
    }

    public Date getSignatureCreated() {
        return this.header.signatureCreated;
    }

    @Override
    public int read() throws IOException {
        this.assertNotClosed();
        if (this.readFooterIfNearAhead(1) < 1) {
            return -1;
        }
        int read = this.in.read();
        if (read >= 0) {
            ++this.offset;
            this.signer.update((byte)read);
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.assertNotClosed();
        int l = this.readFooterIfNearAhead(len);
        if (l < 1) {
            return -1;
        }
        int read = this.in.read(b, off, l);
        if (read > 0) {
            this.offset += (long)read;
            this.signer.update(b, 0, read);
        }
        return read;
    }

    private int readFooterIfNearAhead(int bytesToReadExcludingFooter) throws IOException {
        if (this.footer == null) {
            int bytesToSkipRemaining;
            int bytesToSkipTotal = MAX_FOOTER_LENGTH + bytesToReadExcludingFooter;
            this.in.mark(bytesToSkipTotal);
            int bytesSkippedTotal = 0;
            int bytesSkipped = 0;
            do {
                if (bytesSkipped <= 0) continue;
                bytesSkippedTotal += bytesSkipped;
            } while ((bytesToSkipRemaining = bytesToSkipTotal - bytesSkippedTotal - 1) > 0 && 0 < (bytesSkipped = (int)this.in.skip(bytesToSkipRemaining)));
            if (bytesToSkipRemaining > 0) {
                for (int i = 0; i < bytesToSkipRemaining && this.in.read() >= 0; ++i) {
                    ++bytesSkippedTotal;
                }
            }
            if (this.in.read() >= 0) {
                this.in.reset();
                return bytesToReadExcludingFooter;
            }
            this.in.reset();
            this.in.mark(bytesToSkipTotal);
            int signatureLengthOffset = bytesSkippedTotal - 4;
            this._skipOrFail(signatureLengthOffset);
            int signatureBytesLength = IOUtil.readOrFail((InputStream)this.in) + (IOUtil.readOrFail((InputStream)this.in) << 8) + (IOUtil.readOrFail((InputStream)this.in) << 16) + (IOUtil.readOrFail((InputStream)this.in) << 24);
            if (this.in.read() >= 0) {
                throw new IllegalStateException("Not at end-of-stream!");
            }
            this.in.reset();
            this.in.mark(bytesToSkipTotal);
            int signatureBytesOffset = signatureLengthOffset - signatureBytesLength;
            this._skipOrFail(signatureBytesOffset);
            byte[] signatureBytes = new byte[signatureBytesLength];
            IOUtil.readOrFail((InputStream)this.in, (byte[])signatureBytes, (int)0, (int)signatureBytesLength);
            this.footer = new Footer(this.offset + (long)signatureBytesOffset, signatureBytes);
            this.in.reset();
        }
        return Math.min(bytesToReadExcludingFooter, (int)(this.footer.signatureBytesOffset - this.offset));
    }

    private void _skipOrFail(int bytesToSkip) throws IOException {
        int bytesToSkipRemaining;
        int bytesSkipped = 0;
        int bytesSkippedTotal = 0;
        do {
            if (bytesSkipped <= 0) continue;
            bytesSkippedTotal += bytesSkipped;
        } while ((bytesToSkipRemaining = bytesToSkip - bytesSkippedTotal) > 0 && 0 < (bytesSkipped = (int)this.in.skip(bytesToSkipRemaining)));
        if (bytesToSkipRemaining > 0) {
            for (int i = 0; i < bytesToSkipRemaining; ++i) {
                IOUtil.readOrFail((InputStream)this.in);
            }
        }
        if (bytesSkippedTotal != bytesToSkip) {
            throw new IllegalStateException(String.format("bytesSkippedTotal != bytesToSkip :: %s != %s", bytesSkippedTotal, bytesToSkip));
        }
    }

    @Override
    public long skip(long n) throws IOException {
        int nr;
        long remaining;
        this.assertNotClosed();
        if (n <= 0L) {
            return 0L;
        }
        int size = (int)Math.min(2048L, remaining);
        byte[] skipBuffer = new byte[size];
        for (remaining = n; remaining > 0L && (nr = this.read(skipBuffer, 0, (int)Math.min((long)size, remaining))) >= 0; remaining -= (long)nr) {
        }
        return n - remaining;
    }

    @Override
    public int available() throws IOException {
        this.assertNotClosed();
        int available = this.in.available();
        return this.readFooterIfNearAhead(Math.min(available, 16384));
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.isCloseUnderlyingStream()) {
                this.in.close();
            }
            this.verify();
        }
    }

    private void verify() {
        if (this.footer == null) {
            throw new IllegalStateException("Stream not completely read! Did not even encounter footer, yet!");
        }
        if (this.offset != this.footer.signatureBytesOffset) {
            throw new IllegalStateException("Stream not completely read! offset != footer.signatureBytesOffset");
        }
        if (!this.signer.verifySignature(this.footer.signatureBytes)) {
            throw new SignatureException("Signature not valid!");
        }
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public boolean isCloseUnderlyingStream() {
        return this.closeUnderlyingStream;
    }

    public void setCloseUnderlyingStream(boolean closeUnderlyingStream) {
        this.closeUnderlyingStream = closeUnderlyingStream;
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("SignerOutputStream already closed!");
        }
    }

    protected static class Footer {
        public final long signatureBytesOffset;
        public final byte[] signatureBytes;

        public Footer(long signatureBytesOffset, byte[] signatureBytes) {
            this.signatureBytesOffset = signatureBytesOffset;
            this.signatureBytes = (byte[])AssertUtil.assertNotNull((String)"signatureBytes", (Object)signatureBytes);
        }
    }

    protected static class Header {
        public final int version;
        public final SignerTransformation signerTransformation;
        public final Uid signingUserRepoKeyId;
        public final Date signatureCreated;

        public Header(int version, SignerTransformation signerTransformation, Uid signingUserRepoKeyId, Date signatureCreated) {
            this.version = version;
            this.signerTransformation = (SignerTransformation)((Object)AssertUtil.assertNotNull((String)"signerTransformation", (Object)((Object)signerTransformation)));
            this.signingUserRepoKeyId = (Uid)AssertUtil.assertNotNull((String)"signingUserRepoKeyId", (Object)signingUserRepoKeyId);
            this.signatureCreated = (Date)AssertUtil.assertNotNull((String)"signatureCreated", (Object)signatureCreated);
        }
    }
}

