/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.oio.nio;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.IoFile;
import co.codewizards.cloudstore.core.oio.nio.NioFileUtil;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.childprocess.DumpStreamThread;
import java.io.ByteArrayOutputStream;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioFile
extends IoFile
implements File {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(NioFile.class);

    protected NioFile(String pathname) {
        super(pathname);
    }

    protected NioFile(File parent, String child) {
        super(parent, child);
    }

    protected NioFile(String parent, String child) {
        super(parent, child);
    }

    protected NioFile(URI uri) {
        super(uri);
    }

    protected NioFile(java.io.File ioFile) {
        super(ioFile);
    }

    public File getParentFile() {
        java.io.File parentFile = this.ioFile.getParentFile();
        return parentFile != null ? new NioFile(parentFile) : null;
    }

    public File[] listFiles() {
        java.io.File[] ioFilesListFiles = this.ioFile.listFiles();
        return NioFileUtil.convert(ioFilesListFiles);
    }

    public File[] listFiles(FileFilter fileFilter) {
        java.io.File[] ioFilesListFiles = this.ioFile.listFiles(fileFilter);
        return NioFileUtil.convert(ioFilesListFiles);
    }

    public File[] listFiles(FilenameFilter fileFilter) {
        java.io.File[] ioFilesListFiles = this.ioFile.listFiles(fileFilter);
        return NioFileUtil.convert(ioFilesListFiles);
    }

    public File getAbsoluteFile() {
        return new NioFile(this.ioFile.getAbsoluteFile());
    }

    public boolean existsNoFollow() {
        return Files.exists(this.ioFile.toPath(), LinkOption.NOFOLLOW_LINKS);
    }

    public int compareTo(File otherFile) {
        return this.ioFile.compareTo(otherFile.getIoFile());
    }

    public File getCanonicalFile() throws IOException {
        return new NioFile(this.ioFile.getCanonicalFile());
    }

    public boolean isRegularFileNoFollowLinks() {
        return Files.isRegularFile(this.ioFile.toPath(), LinkOption.NOFOLLOW_LINKS);
    }

    public boolean isRegularFileFollowLinks() {
        return Files.isRegularFile(this.ioFile.toPath(), new LinkOption[0]);
    }

    public boolean isDirectoryNoFollowSymLinks() {
        return Files.isDirectory(this.ioFile.toPath(), LinkOption.NOFOLLOW_LINKS);
    }

    public boolean isDirectoryFollowSymLinks() {
        return Files.isDirectory(this.ioFile.toPath(), new LinkOption[0]);
    }

    public boolean isSymbolicLink() {
        return Files.isSymbolicLink(this.ioFile.toPath());
    }

    public String readSymbolicLinkToPathString() throws IOException {
        Path symlinkPath = this.ioFile.toPath();
        Path currentTargetPath = Files.readSymbolicLink(symlinkPath);
        String currentTarget = NioFile.toPathString(currentTargetPath);
        return currentTarget;
    }

    public long lastModified() {
        try {
            BasicFileAttributes attributes = Files.readAttributes(this.ioFile.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return attributes.lastModifiedTime().toMillis();
        }
        catch (NoSuchFileException x) {
            return 0L;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getLastModifiedNoFollow() {
        try {
            BasicFileAttributes attributes = Files.readAttributes(this.ioFile.toPath(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            return attributes.lastModifiedTime().toMillis();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String toPathString(Path path) {
        AssertUtil.assertNotNull((String)"path", (Object)path);
        return path.toString().replace(java.io.File.separatorChar, '/');
    }

    public boolean renameTo(File dest) {
        return this.ioFile.renameTo(dest.getIoFile());
    }

    public void createSymbolicLink(String targetPath) throws IOException {
        Files.createSymbolicLink(this.ioFile.toPath(), Paths.get(targetPath, new String[0]), new FileAttribute[0]).toString();
    }

    public void move(File toFile) throws IOException {
        Files.move(this.ioFile.toPath(), toFile.getIoFile().toPath(), new CopyOption[0]);
    }

    public void copyToCopyAttributes(File toFile) throws IOException {
        Files.copy(this.ioFile.toPath(), toFile.getIoFile().toPath(), StandardCopyOption.COPY_ATTRIBUTES);
    }

    public boolean setLastModified(long lastModified) {
        FileTime lastModifiedTime = FileTime.fromMillis(lastModified);
        try {
            Files.getFileAttributeView(this.ioFile.toPath(), BasicFileAttributeView.class, new LinkOption[0]).setTimes(lastModifiedTime, null, null);
        }
        catch (IOException e) {
            logger.error("Setting the lastModified timestamp of '" + this.ioFile + "' failed with the following error: " + e, (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastModifiedNoFollow(long lastModified) {
        Path path = this.ioFile.toPath().toAbsolutePath();
        ArrayList<Exception> errors = new ArrayList<Exception>();
        FileTime lastModifiedTime = FileTime.fromMillis(lastModified);
        try {
            Files.getFileAttributeView(path, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).setTimes(lastModifiedTime, null, null);
            return;
        }
        catch (IOException e) {
            errors.add(e);
            String timestamp = new SimpleDateFormat("YYYYMMddHHmm.ss").format(new Date(lastModified));
            ProcessBuilder processBuilder = new ProcessBuilder("touch", "-c", "-h", "-m", "-t", timestamp, path.toString());
            processBuilder.redirectErrorStream(true);
            try {
                int processExitCode;
                Process process = processBuilder.start();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DumpStreamThread dumpInputStreamThread = new DumpStreamThread(process.getInputStream(), (OutputStream)byteArrayOutputStream, logger);
                try {
                    dumpInputStreamThread.start();
                    processExitCode = process.waitFor();
                }
                finally {
                    dumpInputStreamThread.flushBuffer();
                    dumpInputStreamThread.interrupt();
                }
                if (processExitCode != 0) {
                    String stdOutString = new String(byteArrayOutputStream.toByteArray());
                    throw new IOException(String.format("Command 'touch' failed with exitCode=%s and the following message: %s", processExitCode, stdOutString));
                }
                return;
            }
            catch (IOException | InterruptedException e2) {
                errors.add(e2);
                if (!errors.isEmpty()) {
                    logger.error("Setting the lastModified timestamp of '{}' failed with the following errors:", (Object)path);
                    for (Throwable throwable : errors) {
                        logger.error("" + throwable, throwable);
                    }
                }
                return;
            }
        }
    }

    public String relativize(File target) {
        return this.ioFile.getAbsoluteFile().toPath().relativize(target.getIoFile().getAbsoluteFile().toPath()).toString();
    }
}

