/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.core.invoke;

import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.ls.core.invoke.ClassInfo;
import java.io.Serializable;

public class ObjectRef
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String VIRTUAL_METHOD_NAME_INC_REF_COUNT = "*objectRef_incRefCount*";
    public static final String VIRTUAL_METHOD_NAME_DEC_REF_COUNT = "*objectRef_decRefCount*";
    public static final String VIRTUAL_METHOD_CLOSE_OBJECT_MANAGER = "*objectManager_close*";
    private final Uid clientId;
    private final int classId;
    private final long objectId;
    private ClassInfo classInfo;

    public ObjectRef(Uid clientId, int classId, long objectId) {
        this.clientId = (Uid)AssertUtil.assertNotNull((String)"clientId", (Object)clientId);
        this.classId = classId;
        this.objectId = objectId;
    }

    public Uid getClientId() {
        return this.clientId;
    }

    public int getClassId() {
        return this.classId;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public void setClassInfo(ClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.clientId.hashCode();
        result = 31 * result + (int)(this.objectId ^ this.objectId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectRef other = (ObjectRef)obj;
        return this.objectId == other.objectId && this.clientId.equals((Object)other.clientId);
    }

    public String toString() {
        return String.format("%s[%s, %s, %s]", this.getClass().getSimpleName(), this.clientId, this.classId, this.objectId);
    }
}

