/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.client;

import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.ExceptionUtil;
import co.codewizards.cloudstore.core.util.ReflectionUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.ls.client.ObjectRefConverterFactoryImpl;
import co.codewizards.cloudstore.ls.client.handler.InverseServiceRequestHandlerThread;
import co.codewizards.cloudstore.ls.core.LsConfig;
import co.codewizards.cloudstore.ls.core.invoke.ClassInfo;
import co.codewizards.cloudstore.ls.core.invoke.ClassInfoMap;
import co.codewizards.cloudstore.ls.core.invoke.ClassManager;
import co.codewizards.cloudstore.ls.core.invoke.DelayedMethodInvocationResponse;
import co.codewizards.cloudstore.ls.core.invoke.IncDecRefCountQueue;
import co.codewizards.cloudstore.ls.core.invoke.Invoker;
import co.codewizards.cloudstore.ls.core.invoke.MethodInvocationRequest;
import co.codewizards.cloudstore.ls.core.invoke.MethodInvocationResponse;
import co.codewizards.cloudstore.ls.core.invoke.ObjectManager;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRef;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRefConverterFactory;
import co.codewizards.cloudstore.ls.core.invoke.RemoteObjectProxy;
import co.codewizards.cloudstore.ls.core.invoke.RemoteObjectProxyFactory;
import co.codewizards.cloudstore.ls.core.invoke.RemoteObjectProxyInvocationHandler;
import co.codewizards.cloudstore.ls.core.provider.JavaNativeWithObjectRefMessageBodyReader;
import co.codewizards.cloudstore.ls.core.provider.JavaNativeWithObjectRefMessageBodyWriter;
import co.codewizards.cloudstore.ls.rest.client.LocalServerRestClient;
import co.codewizards.cloudstore.ls.rest.client.request.GetDelayedMethodInvocationResponse;
import co.codewizards.cloudstore.ls.rest.client.request.InvokeMethod;
import co.codewizards.cloudstore.ls.rest.client.request.Request;
import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalServerClient
implements Invoker,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(LocalServerClient.class);
    private volatile InverseServiceRequestHandlerThread inverseServiceRequestHandlerThread;
    private LocalServerRestClient localServerRestClient;
    private final ObjectManager objectManager = ObjectManager.getInstance((Uid)new Uid());
    private final ClassInfoMap classInfoMap;
    private final IncDecRefCountQueue incDecRefCountQueue;

    public ClassInfoMap getClassInfoMap() {
        return this.classInfoMap;
    }

    public static LocalServerClient getInstance() {
        return Holder.instance;
    }

    public final synchronized LocalServerRestClient getLocalServerRestClient() {
        if (this.localServerRestClient == null) {
            this.localServerRestClient = this._getLocalServerRestClient();
            ObjectRefConverterFactoryImpl objectRefConverterFactory = new ObjectRefConverterFactoryImpl(this);
            this.localServerRestClient.registerRestComponent((Object)new JavaNativeWithObjectRefMessageBodyReader((ObjectRefConverterFactory)objectRefConverterFactory));
            this.localServerRestClient.registerRestComponent((Object)new JavaNativeWithObjectRefMessageBodyWriter((ObjectRefConverterFactory)objectRefConverterFactory));
        }
        return this.localServerRestClient;
    }

    protected LocalServerRestClient _getLocalServerRestClient() {
        return LocalServerRestClient.getInstance();
    }

    protected LocalServerClient() {
        this.objectManager.setNeverEvict(true);
        this.classInfoMap = new ClassInfoMap();
        this.incDecRefCountQueue = new IncDecRefCountQueue((Invoker)this);
        if (LsConfig.isLocalServerEnabled()) {
            this.inverseServiceRequestHandlerThread = new InverseServiceRequestHandlerThread(this);
            this.inverseServiceRequestHandlerThread.start();
        }
    }

    public ObjectManager getObjectManager() {
        return this.objectManager;
    }

    public <T> T invokeStatic(Class<?> clazz, String methodName, Object ... arguments) {
        AssertUtil.assertNotNull((String)"clazz", clazz);
        AssertUtil.assertNotNull((String)"methodName", (Object)methodName);
        if (!LsConfig.isLocalServerEnabled()) {
            return (T)ReflectionUtil.invokeStatic(clazz, (String)methodName, (Object[])arguments);
        }
        return this.invokeStatic(clazz.getName(), methodName, (String[])null, arguments);
    }

    public <T> T invokeStatic(String className, String methodName, Object ... arguments) {
        AssertUtil.assertNotNull((String)"className", (Object)className);
        AssertUtil.assertNotNull((String)"methodName", (Object)methodName);
        if (!LsConfig.isLocalServerEnabled()) {
            return (T)ReflectionUtil.invokeStatic(this.getClassOrFail(className), (String)methodName, (Object[])arguments);
        }
        return this.invokeStatic(className, methodName, (String[])null, arguments);
    }

    public <T> T invokeStatic(Class<?> clazz, String methodName, Class<?>[] argumentTypes, Object ... arguments) {
        AssertUtil.assertNotNull((String)"clazz", clazz);
        AssertUtil.assertNotNull((String)"methodName", (Object)methodName);
        if (!LsConfig.isLocalServerEnabled()) {
            return (T)ReflectionUtil.invokeStatic(clazz, (String)methodName, (Class[])argumentTypes, (Object[])arguments);
        }
        return this.invokeStatic(clazz.getName(), methodName, this.toClassNames(argumentTypes), arguments);
    }

    public <T> T invokeStatic(String className, String methodName, String[] argumentTypeNames, Object ... arguments) {
        AssertUtil.assertNotNull((String)"className", (Object)className);
        AssertUtil.assertNotNull((String)"methodName", (Object)methodName);
        if (!LsConfig.isLocalServerEnabled()) {
            return (T)ReflectionUtil.invokeStatic(this.getClassOrFail(className), (String)methodName, (Class[])this.getClassesOrFail(argumentTypeNames), (Object[])arguments);
        }
        MethodInvocationRequest methodInvocationRequest = MethodInvocationRequest.forStaticInvocation((String)className, (String)methodName, (String[])argumentTypeNames, (Object[])arguments);
        return this.invoke(methodInvocationRequest);
    }

    public <T> T invokeConstructor(Class<T> clazz, Object ... arguments) {
        AssertUtil.assertNotNull((String)"clazz", clazz);
        if (!LsConfig.isLocalServerEnabled()) {
            return (T)ReflectionUtil.invokeConstructor(clazz, (Object[])arguments);
        }
        return this.invokeConstructor(clazz.getName(), (String[])null, arguments);
    }

    public <T> T invokeConstructor(String className, Object ... arguments) {
        AssertUtil.assertNotNull((String)"className", (Object)className);
        if (!LsConfig.isLocalServerEnabled()) {
            return (T)Util.cast((Object)ReflectionUtil.invokeConstructor(this.getClassOrFail(className), (Object[])arguments));
        }
        return this.invokeConstructor(className, (String[])null, arguments);
    }

    public <T> T invokeConstructor(Class<T> clazz, Class<?>[] argumentTypes, Object ... arguments) {
        AssertUtil.assertNotNull((String)"clazz", clazz);
        if (!LsConfig.isLocalServerEnabled()) {
            return (T)ReflectionUtil.invokeConstructor(clazz, (Class[])argumentTypes, (Object[])arguments);
        }
        return this.invokeConstructor(clazz.getName(), this.toClassNames(argumentTypes), arguments);
    }

    public <T> T invokeConstructor(String className, String[] argumentTypeNames, Object ... arguments) {
        AssertUtil.assertNotNull((String)"className", (Object)className);
        if (!LsConfig.isLocalServerEnabled()) {
            return (T)Util.cast((Object)ReflectionUtil.invokeConstructor(this.getClassOrFail(className), (Class[])this.getClassesOrFail(argumentTypeNames), (Object[])arguments));
        }
        MethodInvocationRequest methodInvocationRequest = MethodInvocationRequest.forConstructorInvocation((String)className, (String[])argumentTypeNames, (Object[])arguments);
        return this.invoke(methodInvocationRequest);
    }

    public <T> T invoke(Object object, String methodName, Object ... arguments) {
        AssertUtil.assertNotNull((String)"object", (Object)object);
        AssertUtil.assertNotNull((String)"methodName", (Object)methodName);
        if (!LsConfig.isLocalServerEnabled()) {
            return (T)Util.cast((Object)ReflectionUtil.invoke((Object)object, (String)methodName, (Object[])arguments));
        }
        if (!(object instanceof RemoteObjectProxy)) {
            throw new IllegalArgumentException("object is not an instance of RemoteObjectProxy!");
        }
        return this.invoke(object, methodName, (Class[])null, arguments);
    }

    public <T> T invoke(Object object, String methodName, Class<?>[] argumentTypes, Object ... arguments) {
        AssertUtil.assertNotNull((String)"object", (Object)object);
        AssertUtil.assertNotNull((String)"methodName", (Object)methodName);
        if (!LsConfig.isLocalServerEnabled()) {
            return (T)Util.cast((Object)ReflectionUtil.invoke((Object)object, (String)methodName, (Class[])argumentTypes, (Object[])arguments));
        }
        return this.invoke(object, methodName, this.toClassNames(argumentTypes), arguments);
    }

    public <T> T invoke(Object object, String methodName, String[] argumentTypeNames, Object ... arguments) {
        AssertUtil.assertNotNull((String)"object", (Object)object);
        AssertUtil.assertNotNull((String)"methodName", (Object)methodName);
        if (!LsConfig.isLocalServerEnabled()) {
            return (T)Util.cast((Object)ReflectionUtil.invoke((Object)object, (String)methodName, (Class[])this.getClassesOrFail(argumentTypeNames), (Object[])arguments));
        }
        MethodInvocationRequest methodInvocationRequest = MethodInvocationRequest.forObjectInvocation((Object)object, (String)methodName, (String[])argumentTypeNames, (Object[])arguments);
        return this.invoke(methodInvocationRequest);
    }

    private Class<?>[] getClassesOrFail(String[] classNames) {
        AssertUtil.assertNotNull((String)"classNames", (Object)classNames);
        Class[] result = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            result[i] = this.getClassOrFail(classNames[i]);
        }
        return result;
    }

    private Class<?> getClassOrFail(String className) {
        AssertUtil.assertNotNull((String)"className", (Object)className);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        try {
            return Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private String[] toClassNames(Class<?> ... classes) {
        String[] classNames;
        if (classes == null) {
            classNames = null;
        } else {
            classNames = new String[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                classNames[i] = classes[i].getName();
            }
        }
        return classNames;
    }

    private <T> T invoke(MethodInvocationRequest methodInvocationRequest) {
        AssertUtil.assertNotNull((String)"methodInvocationRequest", (Object)methodInvocationRequest);
        MethodInvocationResponse methodInvocationResponse = (MethodInvocationResponse)this.getLocalServerRestClient().execute((Request)new InvokeMethod(methodInvocationRequest));
        while (methodInvocationResponse instanceof DelayedMethodInvocationResponse) {
            DelayedMethodInvocationResponse dmir = (DelayedMethodInvocationResponse)methodInvocationResponse;
            Uid delayedResponseId = dmir.getDelayedResponseId();
            methodInvocationResponse = (MethodInvocationResponse)this.getLocalServerRestClient().execute((Request)new GetDelayedMethodInvocationResponse(delayedResponseId));
        }
        Object result = methodInvocationResponse.getResult();
        return (T)Util.cast((Object)result);
    }

    private RemoteObjectProxy _createRemoteObjectProxy(ObjectRef objectRef, Class<?>[] interfaces) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return (RemoteObjectProxy)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new RemoteObjectProxyInvocationHandler((Invoker)this, objectRef));
    }

    private Class<?>[] getInterfaces(ObjectRef objectRef) {
        ClassInfo classInfo = this.classInfoMap.getClassInfo(objectRef.getClassId());
        if (classInfo == null) {
            classInfo = objectRef.getClassInfo();
            if (classInfo == null) {
                throw new IllegalStateException("There is no ClassInfo in the ClassInfoMap and neither in the ObjectRef! " + objectRef);
            }
            this.classInfoMap.putClassInfo(classInfo);
            objectRef.setClassInfo(null);
        }
        ClassManager classManager = this.objectManager.getClassManager();
        Set interfaceNames = classInfo.getInterfaceNames();
        ArrayList<Class<RemoteObjectProxy>> interfaces = new ArrayList<Class<RemoteObjectProxy>>(interfaceNames.size() + 1);
        for (String interfaceName : interfaceNames) {
            Class iface;
            block5: {
                iface = null;
                try {
                    iface = classManager.getClassOrFail(interfaceName);
                }
                catch (RuntimeException x) {
                    if (ExceptionUtil.getCause((Throwable)x, ClassNotFoundException.class) != null) break block5;
                    throw x;
                }
            }
            if (iface == null) continue;
            interfaces.add(iface);
        }
        interfaces.add(RemoteObjectProxy.class);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public void incRefCount(ObjectRef objectRef, Uid refId) {
        this.incDecRefCountQueue.incRefCount(objectRef, refId);
    }

    public void decRefCount(ObjectRef objectRef, Uid refId) {
        this.incDecRefCountQueue.decRefCount(objectRef, refId);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() {
        InverseServiceRequestHandlerThread thread = this.inverseServiceRequestHandlerThread;
        if (thread != null) {
            this.inverseServiceRequestHandlerThread = null;
            ((Thread)thread).interrupt();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Util.doNothing();
            }
        }
        this.objectManager.setNeverEvict(false);
        if (LsConfig.isLocalServerEnabled()) {
            try {
                this.invokeStatic(ObjectRef.class, "*objectManager_close*", (Class[])null, (Object[])null);
            }
            catch (Exception x) {
                logger.error("close: " + x, (Throwable)x);
            }
        }
    }

    public Object getRemoteObjectProxyOrCreate(ObjectRef objectRef) {
        return this.objectManager.getRemoteObjectProxyManager().getRemoteObjectProxyOrCreate(objectRef, new RemoteObjectProxyFactory(){

            public RemoteObjectProxy createRemoteObjectProxy(ObjectRef objectRef) {
                Class[] interfaces = LocalServerClient.this.getInterfaces(objectRef);
                return LocalServerClient.this._createRemoteObjectProxy(objectRef, interfaces);
            }
        });
    }

    private static final class Holder {
        public static final LocalServerClient instance = new LocalServerClient();

        private Holder() {
        }
    }
}

