/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.client.handler;

import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.ls.client.handler.AbstractInverseServiceRequestHandler;
import co.codewizards.cloudstore.ls.core.invoke.ClassManager;
import co.codewizards.cloudstore.ls.core.invoke.InverseMethodInvocationRequest;
import co.codewizards.cloudstore.ls.core.invoke.InverseMethodInvocationResponse;
import co.codewizards.cloudstore.ls.core.invoke.InvokeMethodExecutor;
import co.codewizards.cloudstore.ls.core.invoke.MethodInvocationRequest;
import co.codewizards.cloudstore.ls.core.invoke.MethodInvocationResponse;
import co.codewizards.cloudstore.ls.core.invoke.ObjectManager;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRefWithRefId;
import co.codewizards.cloudstore.ls.core.invoke.filter.ExtMethodInvocationRequest;

public class InverseMethodInvocationRequestHandler
extends AbstractInverseServiceRequestHandler<InverseMethodInvocationRequest, InverseMethodInvocationResponse> {
    private static final InvokeMethodExecutor invokeMethodExecutor = new InvokeMethodExecutor();

    @Override
    public InverseMethodInvocationResponse handle(InverseMethodInvocationRequest request) throws Exception {
        AssertUtil.assertNotNull((String)"request", (Object)request);
        MethodInvocationRequest methodInvocationRequest = request.getMethodInvocationRequest();
        if (methodInvocationRequest != null) {
            MethodInvocationResponse response = this.performMethodInvocation(methodInvocationRequest);
            return new InverseMethodInvocationResponse(request, response);
        }
        Uid delayedResponseId = request.getDelayedResponseId();
        if (delayedResponseId != null) {
            MethodInvocationResponse response = this.getDelayedMethodInvocationResponse(delayedResponseId);
            return new InverseMethodInvocationResponse(request, response);
        }
        throw new IllegalArgumentException("request.methodInvocationRequest and request.delayedResponseId are both null!");
    }

    private MethodInvocationResponse performMethodInvocation(MethodInvocationRequest methodInvocationRequest) throws Exception {
        AssertUtil.assertNotNull((String)"methodInvocationRequest", (Object)methodInvocationRequest);
        ObjectManager objectManager = this.getLocalServerClient().getObjectManager();
        ClassManager classManager = objectManager.getClassManager();
        String className = methodInvocationRequest.getClassName();
        Class clazz = className == null ? null : classManager.getClassOrFail(className);
        String methodName = methodInvocationRequest.getMethodName();
        if ("*objectRef_incRefCount*".equals(methodName)) {
            ObjectRefWithRefId[] objectRefWithRefIds;
            for (ObjectRefWithRefId objectRefWithRefId : objectRefWithRefIds = (ObjectRefWithRefId[])Util.cast((Object)methodInvocationRequest.getArguments()[0])) {
                objectManager.incRefCount(objectRefWithRefId.object, objectRefWithRefId.refId);
            }
            return MethodInvocationResponse.forInvocation(null);
        }
        if ("*objectRef_decRefCount*".equals(methodName)) {
            ObjectRefWithRefId[] objectRefWithRefIds;
            for (ObjectRefWithRefId objectRefWithRefId : objectRefWithRefIds = (ObjectRefWithRefId[])Util.cast((Object)methodInvocationRequest.getArguments()[0])) {
                objectManager.decRefCount(objectRefWithRefId.object, objectRefWithRefId.refId);
            }
            return MethodInvocationResponse.forInvocation(null);
        }
        ExtMethodInvocationRequest extMethodInvocationRequest = new ExtMethodInvocationRequest(objectManager, methodInvocationRequest, clazz);
        MethodInvocationResponse response = invokeMethodExecutor.execute(extMethodInvocationRequest);
        return response;
    }

    private MethodInvocationResponse getDelayedMethodInvocationResponse(Uid delayedResponseId) throws Exception {
        AssertUtil.assertNotNull((String)"delayedResponseId", (Object)delayedResponseId);
        return invokeMethodExecutor.getDelayedResponse(delayedResponseId);
    }
}

