/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.checkout;

import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncDaemon;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.File;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import org.subshare.core.repo.ServerRepo;
import org.subshare.core.repo.metaonly.ServerRepoFile;
import org.subshare.core.server.Server;
import org.subshare.gui.ls.RepoSyncDaemonLs;
import org.subshare.gui.ls.ServerRepoManagerLs;

public class CheckOutWizard {
    private final Server server;
    private final ServerRepo serverRepo;
    private final ServerRepoFile serverRepoFile;

    public CheckOutWizard(Server server, ServerRepo serverRepo) {
        this.server = (Server)AssertUtil.assertNotNull((String)"server", (Object)server);
        this.serverRepo = (ServerRepo)AssertUtil.assertNotNull((String)"serverRepo", (Object)serverRepo);
        this.serverRepoFile = null;
    }

    public CheckOutWizard(ServerRepoFile serverRepoFile) {
        this.server = serverRepoFile.getServer();
        this.serverRepo = serverRepoFile.getServerRepo();
        this.serverRepoFile = serverRepoFile;
    }

    public void checkOut(Window owner) {
        co.codewizards.cloudstore.core.oio.File directory = this.selectLocalDirectory(owner, "Select local directory for check-out (download).");
        if (directory == null) {
            return;
        }
        String serverPath = this.serverRepoFile == null ? "" : this.serverRepoFile.getServerPath();
        ServerRepoManagerLs.getServerRepoManager().checkOutRepository(this.server, this.serverRepo, serverPath, directory);
        RepoSyncDaemon repoSyncDaemon = RepoSyncDaemonLs.getRepoSyncDaemon();
        repoSyncDaemon.startSync(directory);
    }

    private co.codewizards.cloudstore.core.oio.File selectLocalDirectory(Window owner, String title) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle(title);
        File directory = directoryChooser.showDialog(owner);
        return directory == null ? null : OioFileFactory.createFile((File)directory).getAbsoluteFile();
    }
}

