/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.invitation.accept;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncDaemon;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.util.io.Streams;
import org.subshare.core.user.UserRepoInvitationToken;
import org.subshare.gui.invitation.accept.AcceptInvitationData;
import org.subshare.gui.ls.LockerSyncDaemonLs;
import org.subshare.gui.ls.PgpSyncDaemonLs;
import org.subshare.gui.ls.RepoSyncDaemonLs;
import org.subshare.gui.ls.ServerRepoManagerLs;

public class AcceptInvitationManager {
    public void acceptInvitation(AcceptInvitationData acceptInvitationData) {
        AssertUtil.assertNotNull((String)"acceptInvitationData", (Object)acceptInvitationData);
        File invitationFile = (File)AssertUtil.assertNotNull((String)"acceptInvitationData.invitationFile", (Object)acceptInvitationData.getInvitationFile());
        UserRepoInvitationToken userRepoInvitationToken = this.readUserRepoInvitationToken(invitationFile);
        File directory = (File)AssertUtil.assertNotNull((String)"acceptInvitationData.checkOutDirectory", (Object)acceptInvitationData.getCheckOutDirectory());
        ServerRepoManagerLs.getServerRepoManager().checkOutRepository(directory, userRepoInvitationToken);
        RepoSyncDaemon repoSyncDaemon = RepoSyncDaemonLs.getRepoSyncDaemon();
        repoSyncDaemon.startSync(directory);
        PgpSyncDaemonLs.getPgpSyncDaemon().sync();
        LockerSyncDaemonLs.getLockerSyncDaemon().sync();
    }

    private UserRepoInvitationToken readUserRepoInvitationToken(File file) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream((int)file.length());
            try (InputStream in = file.createInputStream();){
                Streams.pipeAll((InputStream)in, (OutputStream)bout);
            }
            UserRepoInvitationToken result = new UserRepoInvitationToken(bout.toByteArray());
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

