/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot.key;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.wot.internal.Mutex;
import org.bouncycastle.openpgp.wot.internal.Util;
import org.bouncycastle.openpgp.wot.key.PgpKey;
import org.bouncycastle.openpgp.wot.key.PgpKeyFingerprint;
import org.bouncycastle.openpgp.wot.key.PgpKeyId;
import org.bouncycastle.openpgp.wot.key.PgpKeyRegistry;
import org.bouncycastle.openpgp.wot.key.PgpUserId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpKeyRegistryImpl
implements PgpKeyRegistry {
    private static final Logger logger = LoggerFactory.getLogger(PgpKeyRegistryImpl.class);
    private final File pubringFile;
    private final File secringFile;
    private final Mutex mutex;
    private long pubringFileLastModified = Long.MIN_VALUE;
    private long secringFileLastModified = Long.MIN_VALUE;
    private Map<PgpKeyFingerprint, PgpKey> pgpKeyFingerprint2pgpKey;
    private Map<PgpKeyId, PgpKey> pgpKeyId2pgpKey;
    private Map<PgpKeyId, PgpKey> pgpKeyId2masterKey;
    private Map<PgpKeyId, Set<PgpKeyId>> signingKeyId2signedKeyIds;

    public PgpKeyRegistryImpl(File pubringFile, File secringFile) {
        this.pubringFile = Util.assertNotNull("pubringFile", pubringFile);
        this.secringFile = Util.assertNotNull("secringFile", secringFile);
        this.mutex = Mutex.forPubringFile(pubringFile);
    }

    @Override
    public File getPubringFile() {
        return this.pubringFile;
    }

    @Override
    public File getSecringFile() {
        return this.secringFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PgpKey getPgpKeyOrFail(PgpKeyId pgpKeyId) throws IllegalArgumentException {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            PgpKey pgpKey = this.getPgpKey(pgpKeyId);
            if (pgpKey == null) {
                throw new IllegalArgumentException("No PGP key found for this keyId: " + pgpKeyId);
            }
            return pgpKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PgpKey getPgpKey(PgpKeyId pgpKeyId) throws IllegalArgumentException {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            Util.assertNotNull("pgpKeyId", pgpKeyId);
            this.loadIfNeeded();
            PgpKey pgpKey = this.pgpKeyId2pgpKey.get(pgpKeyId);
            return pgpKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PgpKey getPgpKeyOrFail(PgpKeyFingerprint pgpKeyFingerprint) throws IllegalArgumentException {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            PgpKey pgpKey = this.getPgpKey(pgpKeyFingerprint);
            if (pgpKey == null) {
                throw new IllegalArgumentException("No PGP key found for this fingerprint: " + pgpKeyFingerprint);
            }
            return pgpKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PgpKey getPgpKey(PgpKeyFingerprint pgpKeyFingerprint) throws IllegalArgumentException {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            Util.assertNotNull("pgpKeyFingerprint", pgpKeyFingerprint);
            this.loadIfNeeded();
            PgpKey pgpKey = this.pgpKeyFingerprint2pgpKey.get(pgpKeyFingerprint);
            return pgpKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PgpKey> getMasterKeys() {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            this.loadIfNeeded();
            return Collections.unmodifiableCollection(this.pgpKeyId2masterKey.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markStale() {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            this.pubringFileLastModified = Long.MIN_VALUE;
            this.secringFileLastModified = Long.MIN_VALUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadIfNeeded() {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            if (this.pgpKeyId2pgpKey == null || this.getPubringFile().lastModified() != this.pubringFileLastModified || this.getSecringFile().lastModified() != this.secringFileLastModified) {
                logger.debug("loadIfNeeded: invoking load().");
                this.load();
            } else {
                logger.trace("loadIfNeeded: *not* invoking load().");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            long pubringFileLastModified;
            long secringFileLastModified;
            HashMap<PgpKeyId, PgpKey> pgpKeyId2masterKey;
            HashMap<PgpKeyId, PgpKey> pgpKeyId2pgpKey;
            HashMap<PgpKeyFingerprint, PgpKey> pgpKeyFingerprint2pgpKey;
            block39: {
                pgpKeyFingerprint2pgpKey = new HashMap<PgpKeyFingerprint, PgpKey>();
                pgpKeyId2pgpKey = new HashMap<PgpKeyId, PgpKey>();
                pgpKeyId2masterKey = new HashMap<PgpKeyId, PgpKey>();
                try {
                    PGPPublicKeyRingCollection pgpPublicKeyRingCollection;
                    Object masterKey;
                    File secringFile = this.getSecringFile();
                    logger.debug("load: secringFile='{}'", (Object)secringFile);
                    secringFileLastModified = secringFile.lastModified();
                    if (secringFile.isFile()) {
                        PGPSecretKeyRingCollection pgpSecretKeyRingCollection;
                        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(secringFile));){
                            pgpSecretKeyRingCollection = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)in), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                        }
                        Iterator it1 = pgpSecretKeyRingCollection.getKeyRings();
                        while (it1.hasNext()) {
                            PGPSecretKeyRing keyRing = (PGPSecretKeyRing)it1.next();
                            masterKey = null;
                            Iterator it2 = keyRing.getPublicKeys();
                            while (it2.hasNext()) {
                                PGPPublicKey publicKey = (PGPPublicKey)it2.next();
                                masterKey = this.enlistPublicKey(pgpKeyFingerprint2pgpKey, pgpKeyId2pgpKey, pgpKeyId2masterKey, (PgpKey)masterKey, (PGPKeyRing)keyRing, publicKey);
                            }
                            Iterator it3 = keyRing.getSecretKeys();
                            while (it3.hasNext()) {
                                PGPSecretKey secretKey = (PGPSecretKey)it3.next();
                                PgpKeyId pgpKeyId = new PgpKeyId(secretKey.getKeyID());
                                PgpKey pgpKey = (PgpKey)pgpKeyId2pgpKey.get(pgpKeyId);
                                if (pgpKey == null) {
                                    throw new IllegalStateException("Secret key does not have corresponding public key in secret key ring! pgpKeyId=" + pgpKeyId);
                                }
                                pgpKey.setSecretKey(secretKey);
                                logger.debug("load: read secretKey with pgpKeyId={}", (Object)pgpKeyId);
                            }
                        }
                    }
                    File pubringFile = this.getPubringFile();
                    logger.debug("load: pubringFile='{}'", (Object)pubringFile);
                    pubringFileLastModified = pubringFile.lastModified();
                    if (!pubringFile.isFile()) break block39;
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(pubringFile));
                    masterKey = null;
                    try {
                        pgpPublicKeyRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)in), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                    }
                    catch (Throwable it3) {
                        masterKey = it3;
                        throw it3;
                    }
                    finally {
                        if (in != null) {
                            if (masterKey != null) {
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (Throwable it3) {
                                    ((Throwable)masterKey).addSuppressed(it3);
                                }
                            } else {
                                ((InputStream)in).close();
                            }
                        }
                    }
                    Iterator it1 = pgpPublicKeyRingCollection.getKeyRings();
                    while (it1.hasNext()) {
                        PGPPublicKeyRing keyRing = (PGPPublicKeyRing)it1.next();
                        PgpKey masterKey2 = null;
                        Iterator it2 = keyRing.getPublicKeys();
                        while (it2.hasNext()) {
                            PGPPublicKey publicKey = (PGPPublicKey)it2.next();
                            masterKey2 = this.enlistPublicKey(pgpKeyFingerprint2pgpKey, pgpKeyId2pgpKey, pgpKeyId2masterKey, masterKey2, (PGPKeyRing)keyRing, publicKey);
                        }
                    }
                }
                catch (IOException | PGPException x) {
                    throw new RuntimeException(x);
                }
            }
            for (PgpKey pgpKey : pgpKeyId2pgpKey.values()) {
                if (pgpKey.getPublicKey() == null) {
                    throw new IllegalStateException("pgpKey.publicKey == null :: keyId = " + pgpKey.getPgpKeyId());
                }
                if (pgpKey.getPublicKeyRing() != null) continue;
                throw new IllegalStateException("pgpKey.publicKeyRing == null :: keyId = " + pgpKey.getPgpKeyId());
            }
            this.secringFileLastModified = secringFileLastModified;
            this.pubringFileLastModified = pubringFileLastModified;
            this.pgpKeyFingerprint2pgpKey = Collections.unmodifiableMap(pgpKeyFingerprint2pgpKey);
            this.pgpKeyId2pgpKey = Collections.unmodifiableMap(pgpKeyId2pgpKey);
            this.pgpKeyId2masterKey = Collections.unmodifiableMap(pgpKeyId2masterKey);
            this.signingKeyId2signedKeyIds = null;
            this.assignSubKeys();
        }
    }

    private void assignSubKeys() {
        for (PgpKey masterKey : this.pgpKeyId2masterKey.values()) {
            Set<PgpKeyId> subKeyIds = masterKey.getSubKeyIds();
            ArrayList<PgpKey> subKeys = new ArrayList<PgpKey>(subKeyIds.size());
            for (PgpKeyId subKeyId : subKeyIds) {
                PgpKey subKey = this.getPgpKeyOrFail(subKeyId);
                subKeys.add(subKey);
            }
            masterKey.setSubKeys(Collections.unmodifiableList(subKeys));
            masterKey.setSubKeyIds(Collections.unmodifiableSet(subKeyIds));
        }
    }

    private PgpKey enlistPublicKey(Map<PgpKeyFingerprint, PgpKey> pgpKeyFingerprint2pgpKey, Map<PgpKeyId, PgpKey> pgpKeyId2PgpKey, Map<PgpKeyId, PgpKey> pgpKeyId2masterKey, PgpKey masterKey, PGPKeyRing keyRing, PGPPublicKey publicKey) {
        PgpKeyId pgpKeyId = new PgpKeyId(publicKey.getKeyID());
        PgpKeyFingerprint pgpKeyFingerprint = new PgpKeyFingerprint(publicKey.getFingerprint());
        PgpKey pgpKey = pgpKeyFingerprint2pgpKey.get(pgpKeyFingerprint);
        if (pgpKey == null) {
            pgpKey = new PgpKey(pgpKeyId, pgpKeyFingerprint);
            pgpKeyFingerprint2pgpKey.put(pgpKeyFingerprint, pgpKey);
            PgpKey old = pgpKeyId2PgpKey.put(pgpKeyId, pgpKey);
            if (old != null) {
                throw new IllegalStateException(String.format("PGP-key-ID collision! Two keys with different fingerprints have the same key-ID! keyId=%s fingerprint1=%s fingerprint2=%s", pgpKeyId, old.getPgpKeyFingerprint(), pgpKey.getPgpKeyFingerprint()));
            }
        }
        if (keyRing instanceof PGPSecretKeyRing) {
            pgpKey.setSecretKeyRing((PGPSecretKeyRing)keyRing);
        } else if (keyRing instanceof PGPPublicKeyRing) {
            pgpKey.setPublicKeyRing((PGPPublicKeyRing)keyRing);
        } else {
            throw new IllegalArgumentException("keyRing is neither an instance of PGPSecretKeyRing nor PGPPublicKeyRing!");
        }
        pgpKey.setPublicKey(publicKey);
        if (publicKey.isMasterKey()) {
            masterKey = pgpKey;
            pgpKeyId2masterKey.put(pgpKey.getPgpKeyId(), pgpKey);
        } else {
            if (masterKey == null) {
                throw new IllegalStateException("First key is a non-master key!");
            }
            pgpKey.setMasterKey(masterKey);
            masterKey.getSubKeyIds().add(pgpKey.getPgpKeyId());
        }
        return masterKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PgpKeyFingerprint> getPgpKeyFingerprintsSignedBy(PgpKeyFingerprint signingPgpKeyFingerprint) {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            Util.assertNotNull("signingPgpKeyFingerprint", signingPgpKeyFingerprint);
            PgpKey signingPgpKey = this.getPgpKey(signingPgpKeyFingerprint);
            if (signingPgpKey == null) {
                return Collections.emptySet();
            }
            Set<PgpKeyId> pgpKeyIds = this.getSigningKeyId2signedKeyIds().get(signingPgpKey.getPgpKeyId());
            if (pgpKeyIds == null) {
                return Collections.emptySet();
            }
            HashSet<PgpKeyFingerprint> result = new HashSet<PgpKeyFingerprint>(pgpKeyIds.size());
            for (PgpKeyId pgpKeyId : pgpKeyIds) {
                PgpKey pgpKey = this.getPgpKeyOrFail(pgpKeyId);
                result.add(pgpKey.getPgpKeyFingerprint());
            }
            return Collections.unmodifiableSet(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PgpKeyId> getPgpKeyIdsSignedBy(PgpKeyId signingPgpKeyId) {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            Set<PgpKeyId> pgpKeyIds = this.getSigningKeyId2signedKeyIds().get(signingPgpKeyId);
            if (pgpKeyIds == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(pgpKeyIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<PgpKeyId, Set<PgpKeyId>> getSigningKeyId2signedKeyIds() {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            this.loadIfNeeded();
            if (this.signingKeyId2signedKeyIds == null) {
                HashMap<PgpKeyId, Set<PgpKeyId>> m = new HashMap<PgpKeyId, Set<PgpKeyId>>();
                for (PgpKey pgpKey : this.pgpKeyId2pgpKey.values()) {
                    PGPPublicKey publicKey = pgpKey.getPublicKey();
                    for (PgpUserId pgpUserId : pgpKey.getPgpUserIds()) {
                        PGPSignature pgpSignature;
                        Iterator it;
                        if (pgpUserId.getUserId() != null) {
                            it = Util.nullToEmpty(publicKey.getSignaturesForID(pgpUserId.getUserId()));
                            while (it.hasNext()) {
                                pgpSignature = (PGPSignature)it.next();
                                if (!this.isCertification(pgpSignature)) continue;
                                this.enlistInSigningKey2signedKeyIds(m, pgpKey, pgpSignature);
                            }
                            continue;
                        }
                        if (pgpUserId.getUserAttribute() != null) {
                            it = Util.nullToEmpty(publicKey.getSignaturesForUserAttribute(pgpUserId.getUserAttribute()));
                            while (it.hasNext()) {
                                pgpSignature = (PGPSignature)it.next();
                                if (!this.isCertification(pgpSignature)) continue;
                                this.enlistInSigningKey2signedKeyIds(m, pgpKey, pgpSignature);
                            }
                            continue;
                        }
                        throw new IllegalStateException("WTF?!");
                    }
                    Iterator it = Util.nullToEmpty(publicKey.getKeySignatures());
                    while (it.hasNext()) {
                        PGPSignature pgpSignature = (PGPSignature)it.next();
                        if (!this.isCertification(pgpSignature)) continue;
                        this.enlistInSigningKey2signedKeyIds(m, pgpKey, pgpSignature);
                    }
                }
                this.signingKeyId2signedKeyIds = Collections.unmodifiableMap(m);
            }
            return this.signingKeyId2signedKeyIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PGPSignature> getSignatures(PgpUserId pgpUserId) {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            PGPSignature pgpSignature;
            Iterator it;
            Util.assertNotNull("pgpUserId", pgpUserId);
            PGPPublicKey publicKey = pgpUserId.getPgpKey().getPublicKey();
            IdentityHashMap<PGPSignature, PGPSignature> pgpSignatures = new IdentityHashMap<PGPSignature, PGPSignature>();
            ArrayList<PGPSignature> result = new ArrayList<PGPSignature>();
            if (pgpUserId.getUserId() != null) {
                it = Util.nullToEmpty(publicKey.getSignaturesForID(pgpUserId.getUserId()));
                while (it.hasNext()) {
                    pgpSignature = (PGPSignature)it.next();
                    if (pgpSignatures.containsKey(pgpSignature) || !this.isCertification(pgpSignature)) continue;
                    pgpSignatures.put(pgpSignature, pgpSignature);
                    result.add(pgpSignature);
                }
            } else if (pgpUserId.getUserAttribute() != null) {
                it = Util.nullToEmpty(publicKey.getSignaturesForUserAttribute(pgpUserId.getUserAttribute()));
                while (it.hasNext()) {
                    pgpSignature = (PGPSignature)it.next();
                    if (pgpSignatures.containsKey(pgpSignature) || !this.isCertification(pgpSignature)) continue;
                    pgpSignatures.put(pgpSignature, pgpSignature);
                    result.add(pgpSignature);
                }
            } else {
                throw new IllegalStateException("WTF?!");
            }
            it = Util.nullToEmpty(publicKey.getKeySignatures());
            while (it.hasNext()) {
                pgpSignature = (PGPSignature)it.next();
                if (pgpSignatures.containsKey(pgpSignature) || !this.isCertification(pgpSignature)) continue;
                pgpSignatures.put(pgpSignature, pgpSignature);
                result.add(pgpSignature);
            }
            return result;
        }
    }

    private void enlistInSigningKey2signedKeyIds(Map<PgpKeyId, Set<PgpKeyId>> signingKeyId2signedKeyIds, PgpKey pgpKey, PGPSignature pgpSignature) {
        PgpKeyId signingPgpKeyId = new PgpKeyId(pgpSignature.getKeyID());
        Set<PgpKeyId> signedKeyIds = signingKeyId2signedKeyIds.get(signingPgpKeyId);
        if (signedKeyIds == null) {
            signedKeyIds = new HashSet<PgpKeyId>();
            signingKeyId2signedKeyIds.put(signingPgpKeyId, signedKeyIds);
        }
        signedKeyIds.add(pgpKey.getPgpKeyId());
    }

    @Override
    public boolean isCertification(PGPSignature pgpSignature) {
        Util.assertNotNull("pgpSignature", pgpSignature);
        return this.isCertification(pgpSignature.getSignatureType());
    }

    @Override
    public boolean isCertification(int pgpSignatureType) {
        return 16 == pgpSignatureType || 17 == pgpSignatureType || 18 == pgpSignatureType || 19 == pgpSignatureType;
    }
}

