/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.dto;

import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.subshare.core.sign.Signature;

public class SignatureDto
implements Signature,
Serializable {
    private Date signatureCreated;
    private Uid signingUserRepoKeyId;
    private byte[] signatureData;

    public SignatureDto() {
    }

    public SignatureDto(Date signatureCreated, Uid signingUserRepoKeyId, byte[] signatureData) {
        this.setSignatureCreated(signatureCreated);
        this.setSigningUserRepoKeyId(signingUserRepoKeyId);
        this.setSignatureData(signatureData);
    }

    @Override
    public Date getSignatureCreated() {
        return this.signatureCreated;
    }

    public void setSignatureCreated(Date signatureCreated) {
        if (this.signatureCreated != null && !this.signatureCreated.equals(signatureCreated)) {
            throw new IllegalStateException("this.signatureCreated already assigned to a different value! Cannot modify!");
        }
        this.signatureCreated = signatureCreated;
    }

    @Override
    public Uid getSigningUserRepoKeyId() {
        return this.signingUserRepoKeyId;
    }

    public void setSigningUserRepoKeyId(Uid signingUserRepoKeyId) {
        if (this.signingUserRepoKeyId != null && !this.signingUserRepoKeyId.equals((Object)signingUserRepoKeyId)) {
            throw new IllegalStateException("this.signingUserRepoKeyId already assigned to a different value! Cannot modify!");
        }
        this.signingUserRepoKeyId = signingUserRepoKeyId;
    }

    @Override
    public byte[] getSignatureData() {
        return this.signatureData;
    }

    public void setSignatureData(byte[] signatureData) {
        if (this.signatureData != null && !Arrays.equals(this.signatureData, signatureData)) {
            throw new IllegalStateException("this.signatureData already assigned to a different value! Cannot modify!");
        }
        this.signatureData = signatureData;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.signatureCreated == null ? 0 : this.signatureCreated.hashCode());
        result = 31 * result + (this.signingUserRepoKeyId == null ? 0 : this.signingUserRepoKeyId.hashCode());
        result = 31 * result + Arrays.hashCode(this.signatureData);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Signature)) {
            return false;
        }
        Signature other = (Signature)obj;
        return Util.equal((Object)this.signatureCreated, (Object)other.getSignatureCreated()) && Util.equal((Object)this.signingUserRepoKeyId, (Object)other.getSigningUserRepoKeyId()) && Util.equal((byte[])this.signatureData, (byte[])other.getSignatureData());
    }

    public static SignatureDto copyIfNeeded(Signature signature) {
        if (signature == null) {
            return null;
        }
        if (signature instanceof SignatureDto) {
            return (SignatureDto)signature;
        }
        AssertUtil.assertNotNull((String)"signature.signatureCreated", (Object)signature.getSignatureCreated());
        AssertUtil.assertNotNull((String)"signature.signingUserRepoKeyId", (Object)signature.getSigningUserRepoKeyId());
        AssertUtil.assertNotNull((String)"signature.signatureData", (Object)signature.getSignatureData());
        return new SignatureDto(signature.getSignatureCreated(), signature.getSigningUserRepoKeyId(), signature.getSignatureData());
    }
}

