/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.locker.sync;

import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.io.LockFile;
import co.codewizards.cloudstore.core.io.LockFileFactory;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.locker.LockerContent;
import org.subshare.core.locker.LockerEncryptedDataFile;
import org.subshare.core.locker.sync.Messages;
import org.subshare.core.locker.transport.LockerTransport;
import org.subshare.core.locker.transport.LockerTransportFactory;
import org.subshare.core.locker.transport.LockerTransportFactoryRegistry;
import org.subshare.core.locker.transport.local.LocalLockerTransportFactory;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.PgpRegistry;
import org.subshare.core.pgp.man.PgpPrivateKeyPassphraseStoreImpl;
import org.subshare.core.server.Server;
import org.subshare.core.sync.Sync;

public class LockerSync
implements Sync {
    private static final Logger logger = LoggerFactory.getLogger(LockerSync.class);
    private final Uid serverId;
    private final Server server;
    private final URL serverUrl;
    private LockerTransport localLockerTransport;
    private LockerTransport serverLockerTransport;
    private File lockerSyncPropertiesFile;
    private Properties lockerSyncProperties;
    private PgpKey pgpKey;
    private LockerContent lockerContent;

    public LockerSync(Server server) {
        this.server = (Server)AssertUtil.assertNotNull((String)"server", (Object)server);
        this.serverId = (Uid)AssertUtil.assertNotNull((String)"server.serverId", (Object)this.server.getServerId());
        this.serverUrl = (URL)AssertUtil.assertNotNull((String)"server.url", (Object)this.server.getUrl());
    }

    public Server getServer() {
        return this.server;
    }

    public Uid getServerId() {
        return this.serverId;
    }

    public URL getServerUrl() {
        return this.serverUrl;
    }

    @Override
    public String getName() {
        return Messages.getString("LockerSync.name");
    }

    @Override
    public void sync() {
        logger.info("sync: serverId='{}' serverName='{}'", (Object)this.server.getServerId(), (Object)this.server.getName());
        this.lockerContent = null;
        this.pgpKey = null;
        Set<PgpKeyId> pgpKeyIds = PgpPrivateKeyPassphraseStoreImpl.getInstance().getPgpKeyIdsHavingPassphrase();
        Pgp pgp = PgpRegistry.getInstance().getPgpOrFail();
        Iterator<LockerContent> iterator = this.getLockerContents().iterator();
        while (iterator.hasNext()) {
            LockerContent lockerContent;
            this.lockerContent = lockerContent = iterator.next();
            this.getLocalLockerTransport().setLockerContent(lockerContent);
            this.getServerLockerTransport().setLockerContent(lockerContent);
            for (PgpKeyId pgpKeyId : pgpKeyIds) {
                this.pgpKey = pgp.getPgpKey(pgpKeyId);
                if (this.pgpKey == null) {
                    throw new IllegalStateException("PgpKey not found: " + pgpKeyId);
                }
                this.getLocalLockerTransport().setPgpKey(this.pgpKey);
                this.getServerLockerTransport().setPgpKey(this.pgpKey);
                List<Uid> localVersions = this.getLocalLockerTransport().getVersions();
                if (localVersions.size() != 1) {
                    throw new IllegalStateException("localVersions.size() != 1");
                }
                Uid localVersion = localVersions.get(0);
                Uid lastSyncLocalVersion = this.getLastSyncLocalVersion();
                boolean syncDownDone = false;
                boolean syncUpNeeded = false;
                List<Uid> serverVersions = this.getServerLockerTransport().getVersions();
                if (serverVersions.size() > 1) {
                    syncUpNeeded = true;
                    serverVersions = this.syncDown();
                    syncDownDone = true;
                } else if (serverVersions.isEmpty()) {
                    syncUpNeeded = true;
                } else {
                    HashSet<Uid> serverVersionsSet = new HashSet<Uid>(serverVersions);
                    HashSet<Uid> lastSyncServerVersions = new HashSet<Uid>(this.getLastSyncServerVersions());
                    if (!serverVersionsSet.equals(lastSyncServerVersions)) {
                        serverVersions = this.syncDown();
                        syncDownDone = true;
                    }
                    if (!syncUpNeeded) {
                        boolean bl = syncUpNeeded = !localVersion.equals((Object)lastSyncLocalVersion);
                    }
                }
                if (!syncUpNeeded) continue;
                if (!syncDownDone) {
                    this.getLocalLockerTransport().addMergedVersions(serverVersions);
                }
                this.syncUp();
            }
        }
        this.pgpKey = null;
        this.lockerContent = null;
    }

    public String getLastSyncServerVersionsPropertyKey() {
        PgpKeyId pgpKeyId = ((PgpKey)AssertUtil.assertNotNull((String)"pgpKey", (Object)this.pgpKey)).getPgpKeyId();
        String lockerContentName = ((LockerContent)AssertUtil.assertNotNull((String)"lockerContent", (Object)this.lockerContent)).getName();
        return String.format("server[%s].pgpKey[%s].lockerContent[%s].lastSyncServerVersions", this.serverId, pgpKeyId, lockerContentName);
    }

    public String getLastSyncLocalVersionPropertyKey() {
        PgpKeyId pgpKeyId = ((PgpKey)AssertUtil.assertNotNull((String)"pgpKey", (Object)this.pgpKey)).getPgpKeyId();
        String lockerContentName = ((LockerContent)AssertUtil.assertNotNull((String)"lockerContent", (Object)this.lockerContent)).getName();
        return String.format("server[%s].pgpKey[%s].lockerContent[%s].lastSyncLocalVersion", this.serverId, pgpKeyId, lockerContentName);
    }

    private Uid getLastSyncLocalVersion() {
        String value = this.getLockerSyncProperties().getProperty(this.getLastSyncLocalVersionPropertyKey());
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        Uid result = new Uid(value);
        return result;
    }

    private void setLastSyncLocalVersion(Uid version) {
        this.getLockerSyncProperties().setProperty(this.getLastSyncLocalVersionPropertyKey(), version.toString());
        this.writeLockerSyncProperties();
    }

    private List<Uid> getLastSyncServerVersions() {
        String[] strings;
        String value = this.getLockerSyncProperties().getProperty(this.getLastSyncServerVersionsPropertyKey());
        if (StringUtil.isEmpty((String)value)) {
            return Collections.emptyList();
        }
        ArrayList<Uid> result = new ArrayList<Uid>();
        for (String string : strings = value.split(",")) {
            if (StringUtil.isEmpty((String)string)) continue;
            result.add(new Uid(string));
        }
        return Collections.unmodifiableList(result);
    }

    private void setLastSyncServerVersions(List<Uid> serverVersions) {
        AssertUtil.assertNotNull((String)"serverVersions", serverVersions);
        StringBuilder sb = new StringBuilder();
        for (Uid serverVersion : serverVersions) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(serverVersion);
        }
        this.getLockerSyncProperties().setProperty(this.getLastSyncServerVersionsPropertyKey(), sb.toString());
        this.writeLockerSyncProperties();
    }

    private List<Uid> syncDown() {
        logger.info("syncDown: serverId='{}' serverName='{}' pgpKeyId={} lockerContentName='{}'", new Object[]{this.server.getServerId(), this.server.getName(), this.pgpKey.getPgpKeyId(), this.lockerContent.getName()});
        return this.sync(this.getServerLockerTransport(), this.getLocalLockerTransport());
    }

    private void syncUp() {
        logger.info("syncUp: serverId='{}' serverName='{}' pgpKeyId={} lockerContentName='{}'", new Object[]{this.server.getServerId(), this.server.getName(), this.pgpKey.getPgpKeyId(), this.lockerContent.getName()});
        List<Uid> localVersions = this.getLocalLockerTransport().getVersions();
        this.sync(this.getLocalLockerTransport(), this.getServerLockerTransport());
        if (localVersions.size() != 1) {
            throw new IllegalStateException("localVersions.size() != 1");
        }
        this.setLastSyncLocalVersion(localVersions.get(0));
    }

    private List<Uid> sync(LockerTransport fromLockerTransport, LockerTransport toLockerTransport) {
        List<LockerEncryptedDataFile> encryptedDataFiles = fromLockerTransport.getEncryptedDataFiles();
        ArrayList<Uid> serverVersions = new ArrayList<Uid>(encryptedDataFiles.size());
        for (LockerEncryptedDataFile encryptedDataFile : encryptedDataFiles) {
            Uid serverVersion = encryptedDataFile.getContentVersion();
            AssertUtil.assertNotNull((String)"encryptedDataFile.contentVersion", (Object)serverVersion);
            serverVersions.add(serverVersion);
            toLockerTransport.putEncryptedDataFile(encryptedDataFile);
        }
        this.setLastSyncServerVersions(serverVersions);
        return serverVersions;
    }

    private List<LockerContent> getLockerContents() {
        ArrayList<LockerContent> result = new ArrayList<LockerContent>();
        Iterator<LockerContent> iterator = ServiceLoader.load(LockerContent.class).iterator();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    private LockerTransport getLocalLockerTransport() {
        if (this.localLockerTransport == null) {
            LockerTransportFactoryRegistry lockerTransportFactoryRegistry = LockerTransportFactoryRegistry.getInstance();
            LockerTransportFactory lockerTransportFactory = lockerTransportFactoryRegistry.getLockerTransportFactoryOrFail(LocalLockerTransportFactory.LOCAL_URL);
            this.localLockerTransport = lockerTransportFactory.createLockerTransport(LocalLockerTransportFactory.LOCAL_URL);
        }
        return this.localLockerTransport;
    }

    public LockerTransport getServerLockerTransport() {
        if (this.serverLockerTransport == null) {
            LockerTransportFactoryRegistry lockerTransportFactoryRegistry = LockerTransportFactoryRegistry.getInstance();
            LockerTransportFactory lockerTransportFactory = lockerTransportFactoryRegistry.getLockerTransportFactoryOrFail(this.serverUrl);
            this.serverLockerTransport = lockerTransportFactory.createLockerTransport(this.serverUrl);
        }
        return this.serverLockerTransport;
    }

    private File getLockerSyncPropertiesFile() {
        if (this.lockerSyncPropertiesFile == null) {
            this.lockerSyncPropertiesFile = OioFileFactory.createFile((File)ConfigDir.getInstance().getFile(), (String[])new String[]{"lockerSync.properties"});
        }
        return this.lockerSyncPropertiesFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getLockerSyncProperties() {
        block30: {
            if (this.lockerSyncProperties == null) {
                try (LockFile lockFile = LockFileFactory.getInstance().acquire(this.getLockerSyncPropertiesFile(), 30000L);){
                    Lock lock = lockFile.getLock();
                    lock.lock();
                    try {
                        if (this.lockerSyncProperties != null) break block30;
                        Properties p = new Properties();
                        try (InputStream in = lockFile.createInputStream();){
                            p.load(in);
                        }
                        this.lockerSyncProperties = p;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                catch (IOException x) {
                    throw new RuntimeException(x);
                }
            }
        }
        return this.lockerSyncProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLockerSyncProperties() {
        Properties lockerSyncProperties;
        Properties properties = lockerSyncProperties = this.getLockerSyncProperties();
        synchronized (properties) {
            try (LockFile lockFile = LockFileFactory.getInstance().acquire(this.getLockerSyncPropertiesFile(), 30000L);
                 OutputStream out = lockFile.createOutputStream();){
                lockerSyncProperties.store(out, null);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
    }

    @Override
    public void close() {
        LockerTransport llt = this.localLockerTransport;
        this.localLockerTransport = null;
        if (llt != null) {
            llt.close();
        }
        LockerTransport slt = this.serverLockerTransport;
        this.serverLockerTransport = null;
        if (slt != null) {
            slt.close();
        }
    }
}

