/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.dto.CryptoKeyRole;
import org.subshare.local.persistence.CryptoKey;
import org.subshare.local.persistence.CryptoLink;
import org.subshare.local.persistence.CryptoLinkDao;
import org.subshare.local.persistence.CryptoRepoFile;

public class CryptoKeyDao
extends Dao<CryptoKey, CryptoKeyDao> {
    private static final Logger logger = LoggerFactory.getLogger(CryptoKeyDao.class);

    public CryptoKey getCryptoKeyOrFail(Uid cryptoKeyId) {
        CryptoKey cryptoKey = this.getCryptoKey(cryptoKeyId);
        if (cryptoKey == null) {
            throw new IllegalArgumentException("There is no CryptoKey with this cryptoKeyId: " + cryptoKeyId);
        }
        return cryptoKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CryptoKey getCryptoKey(Uid cryptoKeyId) {
        AssertUtil.assertNotNull((String)"cryptoKeyId", (Object)cryptoKeyId);
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCryptoKey_cryptoKeyId");
        try {
            CryptoKey cryptoKey;
            CryptoKey cryptoKey2 = cryptoKey = (CryptoKey)((Object)query.execute((Object)cryptoKeyId.toString()));
            return cryptoKey2;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CryptoKey> getActiveCryptoKeys(CryptoRepoFile cryptoRepoFile, CryptoKeyRole cryptoKeyRole) {
        AssertUtil.assertNotNull((String)"cryptoRepoFile", (Object)((Object)cryptoRepoFile));
        AssertUtil.assertNotNull((String)"cryptoKeyRole", (Object)cryptoKeyRole);
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getActiveCryptoKeys_cryptoRepoFile_cryptoKeyRole");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection cryptoKeys = (Collection)query.execute((Object)cryptoRepoFile, (Object)cryptoKeyRole);
            logger.debug("getCryptoKeys: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            cryptoKeys = this.load(cryptoKeys);
            logger.debug("getCryptoKeys: Loading result-set with {} elements took {} ms.", (Object)cryptoKeys.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = cryptoKeys;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CryptoKey> getCryptoKeysChangedAfterExclLastSyncFromRepositoryId(long localRevision, UUID exclLastSyncFromRepositoryId) {
        AssertUtil.assertNotNull((String)"exclLastSyncFromRepositoryId", (Object)exclLastSyncFromRepositoryId);
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCryptoKeysChangedAfter_localRevision_exclLastSyncFromRepositoryId");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection cryptoKeys = (Collection)query.execute((Object)localRevision, (Object)exclLastSyncFromRepositoryId.toString());
            logger.debug("getCryptoKeysChangedAfter: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            cryptoKeys = this.load(cryptoKeys);
            logger.debug("getCryptoKeysChangedAfter: Loading result-set with {} elements took {} ms.", (Object)cryptoKeys.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = cryptoKeys;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CryptoKey> getCryptoKeys(CryptoRepoFile cryptoRepoFile) {
        AssertUtil.assertNotNull((String)"cryptoRepoFile", (Object)((Object)cryptoRepoFile));
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCryptoKeys_cryptoRepoFile");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection cryptoKeys = (Collection)query.execute((Object)cryptoRepoFile);
            logger.debug("getCryptoKeys: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            cryptoKeys = this.load(cryptoKeys);
            logger.debug("getCryptoKeys: Loading result-set with {} elements took {} ms.", (Object)cryptoKeys.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = cryptoKeys;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    public void deletePersistent(CryptoKey entity) {
        this.deleteDependentObjects(entity);
        this.pm().flush();
        super.deletePersistent((Entity)entity);
    }

    public void deletePersistentAll(Collection<? extends CryptoKey> entities) {
        for (CryptoKey cryptoKey : entities) {
            this.deleteDependentObjects(cryptoKey);
        }
        this.pm().flush();
        super.deletePersistentAll(entities);
    }

    protected void deleteDependentObjects(CryptoKey cryptoKey) {
        AssertUtil.assertNotNull((String)"cryptoKey", (Object)((Object)cryptoKey));
        CryptoLinkDao cryptoLinkDao = (CryptoLinkDao)this.getDao(CryptoLinkDao.class);
        Collection<CryptoLink> cryptoLinksFrom = cryptoLinkDao.getCryptoLinksFrom(cryptoKey);
        Collection<CryptoLink> cryptoLinksTo = cryptoLinkDao.getCryptoLinksTo(cryptoKey);
        HashSet<CryptoLink> cryptoLinks = new HashSet<CryptoLink>(cryptoLinksFrom.size() + cryptoLinksTo.size());
        cryptoLinks.addAll(cryptoLinksFrom);
        cryptoLinks.addAll(cryptoLinksTo);
        cryptoLinkDao.deletePersistentAll(cryptoLinks);
    }
}

