/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.dto.Uid;
import co.codewizards.cloudstore.core.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.UUID;
import javax.jdo.annotations.Discriminator;
import javax.jdo.annotations.DiscriminatorStrategy;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.enhancer.Persistable;
import org.datanucleus.state.StateManager;
import org.subshare.core.io.InputStreamSource;
import org.subshare.core.io.MultiInputStream;
import org.subshare.core.sign.Signable;
import org.subshare.core.sign.Signature;
import org.subshare.core.user.UserRepoKey;
import org.subshare.core.user.UserRepoKeyImpl;
import org.subshare.crypto.CryptoRegistry;
import org.subshare.local.persistence.SignatureImpl;
import org.subshare.local.persistence.UserRepoKeyPublicKey;

@PersistenceCapable
@Discriminator(strategy=DiscriminatorStrategy.VALUE_MAP, value="InvitationUserRepoKeyPublicKey")
@Inheritance(strategy=InheritanceStrategy.SUPERCLASS_TABLE)
public class InvitationUserRepoKeyPublicKey
extends UserRepoKeyPublicKey
implements Signable,
Persistable {
    private Date validTo;
    @Persistent(nullValue=NullValue.EXCEPTION)
    @Embedded(nullIndicatorColumn="signatureCreated")
    private SignatureImpl signature;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public InvitationUserRepoKeyPublicKey() {
    }

    public InvitationUserRepoKeyPublicKey(UserRepoKey.PublicKeyWithSignature publicKey) {
        super((UserRepoKey.PublicKey)publicKey);
        this.setValidTo(publicKey.getValidTo());
        this.setSignature(publicKey.getSignature());
    }

    public InvitationUserRepoKeyPublicKey(Uid userRepoKeyId) {
        super(userRepoKeyId);
    }

    public Date getValidTo() {
        return InvitationUserRepoKeyPublicKey.dnGetvalidTo(this);
    }

    public void setValidTo(Date validTo) {
        if (!Util.equal((Object)InvitationUserRepoKeyPublicKey.dnGetvalidTo(this), (Object)validTo)) {
            InvitationUserRepoKeyPublicKey.dnSetvalidTo(this, validTo);
        }
    }

    @Override
    protected UserRepoKey.PublicKey createPublicKey() {
        try {
            return new UserRepoKeyImpl.PublicKeyImpl(this.getUserRepoKeyId(), this.getServerRepositoryId(), CryptoRegistry.getInstance().decodePublicKey(this.getPublicKeyData()), this.getValidTo(), true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSignedDataType() {
        return "PublicKey";
    }

    @Override
    public int getSignedDataVersion() {
        return 0;
    }

    @Override
    public InputStream getSignedData(int signedDataVersion) {
        try {
            byte separatorIndex = 0;
            InputStreamSource[] inputStreamSourceArray = new InputStreamSource[5];
            inputStreamSourceArray[0] = InputStreamSource.Helper.createInputStreamSource((Uid)this.getUserRepoKeyId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[1] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[2] = InputStreamSource.Helper.createInputStreamSource((UUID)this.getServerRepositoryId());
            separatorIndex = (byte)(separatorIndex + 1);
            inputStreamSourceArray[3] = InputStreamSource.Helper.createInputStreamSource((byte)separatorIndex);
            inputStreamSourceArray[4] = InputStreamSource.Helper.createInputStreamSource((byte[])this.getPublicKeyData());
            return new MultiInputStream(inputStreamSourceArray);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public Signature getSignature() {
        return InvitationUserRepoKeyPublicKey.dnGetsignature(this);
    }

    public void setSignature(Signature signature) {
        if (!Util.equal((Object)InvitationUserRepoKeyPublicKey.dnGetsignature(this), (Object)signature)) {
            InvitationUserRepoKeyPublicKey.dnSetsignature(this, SignatureImpl.copy(signature));
        }
    }

    static {
        dnFieldNames = InvitationUserRepoKeyPublicKey.__dnFieldNamesInit();
        dnFieldTypes = InvitationUserRepoKeyPublicKey.__dnFieldTypesInit();
        dnFieldFlags = InvitationUserRepoKeyPublicKey.__dnFieldFlagsInit();
        dnInheritedFieldCount = InvitationUserRepoKeyPublicKey.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = InvitationUserRepoKeyPublicKey.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)InvitationUserRepoKeyPublicKey.___dn$loadClass("org.subshare.local.persistence.InvitationUserRepoKeyPublicKey"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new InvitationUserRepoKeyPublicKey());
    }

    @Override
    public boolean dnIsDetached() {
        return false;
    }

    @Override
    public Persistable dnNewInstance(StateManager sm) {
        InvitationUserRepoKeyPublicKey result = new InvitationUserRepoKeyPublicKey();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    @Override
    public Persistable dnNewInstance(StateManager sm, Object obj) {
        InvitationUserRepoKeyPublicKey result = new InvitationUserRepoKeyPublicKey();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    @Override
    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.signature = (SignatureImpl)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 1: {
                this.validTo = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    @Override
    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.signature);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.validTo);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(InvitationUserRepoKeyPublicKey obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.signature = obj.signature;
                break;
            }
            case 1: {
                this.validTo = obj.validTo;
                break;
            }
            default: {
                super.dnCopyField(obj, index);
            }
        }
    }

    @Override
    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof InvitationUserRepoKeyPublicKey)) {
            throw new IllegalArgumentException("object is not an object of type org.subshare.local.persistence.InvitationUserRepoKeyPublicKey");
        }
        InvitationUserRepoKeyPublicKey other = (InvitationUserRepoKeyPublicKey)((Object)obj);
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"signature", "validTo"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{InvitationUserRepoKeyPublicKey.___dn$loadClass("org.subshare.local.persistence.SignatureImpl"), InvitationUserRepoKeyPublicKey.___dn$loadClass("java.util.Date")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{10, 21};
    }

    protected static int __dnGetInheritedFieldCount() {
        return UserRepoKeyPublicKey.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 2 + UserRepoKeyPublicKey.dnGetManagedFieldCount();
    }

    private static Class __dnPersistableSuperclassInit() {
        return InvitationUserRepoKeyPublicKey.___dn$loadClass("org.subshare.local.persistence.UserRepoKeyPublicKey");
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        InvitationUserRepoKeyPublicKey o = (InvitationUserRepoKeyPublicKey)((Object)super.clone());
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static SignatureImpl dnGetsignature(InvitationUserRepoKeyPublicKey objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return (SignatureImpl)objPC.dnStateManager.getObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.signature);
        }
        return objPC.signature;
    }

    private static void dnSetsignature(InvitationUserRepoKeyPublicKey objPC, SignatureImpl val) {
        if (objPC.dnStateManager == null) {
            objPC.signature = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0 + dnInheritedFieldCount, (Object)objPC.signature, (Object)val);
        }
    }

    private static Date dnGetvalidTo(InvitationUserRepoKeyPublicKey objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.validTo);
        }
        return objPC.validTo;
    }

    private static void dnSetvalidTo(InvitationUserRepoKeyPublicKey objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1 + dnInheritedFieldCount, (Object)objPC.validTo, (Object)val);
        } else {
            objPC.validTo = val;
        }
    }
}

